/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53globalresolver.Route53GlobalResolverAsyncClient;
import software.amazon.awssdk.services.route53globalresolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53globalresolver.model.GlobalResolversItem;
import software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversResponse;

public class ListGlobalResolversPublisher
implements SdkPublisher<ListGlobalResolversResponse> {
    private final Route53GlobalResolverAsyncClient client;
    private final ListGlobalResolversRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGlobalResolversPublisher(Route53GlobalResolverAsyncClient client, ListGlobalResolversRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGlobalResolversPublisher(Route53GlobalResolverAsyncClient client, ListGlobalResolversRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGlobalResolversResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGlobalResolversResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GlobalResolversItem> globalResolvers() {
        Function<ListGlobalResolversResponse, Iterator> getIterator = response -> {
            if (response != null && response.globalResolvers() != null) {
                return response.globalResolvers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGlobalResolversResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGlobalResolversResponseFetcher
    implements AsyncPageFetcher<ListGlobalResolversResponse> {
        private ListGlobalResolversResponseFetcher() {
        }

        public boolean hasNextPage(ListGlobalResolversResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGlobalResolversResponse> nextPage(ListGlobalResolversResponse previousPage) {
            if (previousPage == null) {
                return ListGlobalResolversPublisher.this.client.listGlobalResolvers(ListGlobalResolversPublisher.this.firstRequest);
            }
            return ListGlobalResolversPublisher.this.client.listGlobalResolvers((ListGlobalResolversRequest)((Object)ListGlobalResolversPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

