/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53globalresolver.Route53GlobalResolverAsyncClient;
import software.amazon.awssdk.services.route53globalresolver.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53globalresolver.model.FirewallDomainListsItem;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsResponse;

public class ListFirewallDomainListsPublisher
implements SdkPublisher<ListFirewallDomainListsResponse> {
    private final Route53GlobalResolverAsyncClient client;
    private final ListFirewallDomainListsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFirewallDomainListsPublisher(Route53GlobalResolverAsyncClient client, ListFirewallDomainListsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFirewallDomainListsPublisher(Route53GlobalResolverAsyncClient client, ListFirewallDomainListsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFirewallDomainListsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFirewallDomainListsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FirewallDomainListsItem> firewallDomainLists() {
        Function<ListFirewallDomainListsResponse, Iterator> getIterator = response -> {
            if (response != null && response.firewallDomainLists() != null) {
                return response.firewallDomainLists().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFirewallDomainListsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFirewallDomainListsResponseFetcher
    implements AsyncPageFetcher<ListFirewallDomainListsResponse> {
        private ListFirewallDomainListsResponseFetcher() {
        }

        public boolean hasNextPage(ListFirewallDomainListsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFirewallDomainListsResponse> nextPage(ListFirewallDomainListsResponse previousPage) {
            if (previousPage == null) {
                return ListFirewallDomainListsPublisher.this.client.listFirewallDomainLists(ListFirewallDomainListsPublisher.this.firstRequest);
            }
            return ListFirewallDomainListsPublisher.this.client.listFirewallDomainLists((ListFirewallDomainListsRequest)((Object)ListFirewallDomainListsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

