/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53globalresolver.model.DNSViewSummary;
import software.amazon.awssdk.services.route53globalresolver.model.DNSViewsCopier;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDnsViewsResponse
extends Route53GlobalResolverResponse
implements ToCopyableBuilder<Builder, ListDnsViewsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDnsViewsResponse.getter(ListDnsViewsResponse::nextToken)).setter(ListDnsViewsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<DNSViewSummary>> DNS_VIEWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dnsViews").getter(ListDnsViewsResponse.getter(ListDnsViewsResponse::dnsViews)).setter(ListDnsViewsResponse.setter(Builder::dnsViews)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsViews").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DNSViewSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, DNS_VIEWS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDnsViewsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<DNSViewSummary> dnsViews;

    private ListDnsViewsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.dnsViews = builder.dnsViews;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasDnsViews() {
        return this.dnsViews != null && !(this.dnsViews instanceof SdkAutoConstructList);
    }

    public final List<DNSViewSummary> dnsViews() {
        return this.dnsViews;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsViews() ? this.dnsViews() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDnsViewsResponse)) {
            return false;
        }
        ListDnsViewsResponse other = (ListDnsViewsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasDnsViews() == other.hasDnsViews() && Objects.equals(this.dnsViews(), other.dnsViews());
    }

    public final String toString() {
        return ToString.builder((String)"ListDnsViewsResponse").add("NextToken", (Object)this.nextToken()).add("DnsViews", this.hasDnsViews() ? this.dnsViews() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "dnsViews": {
                return Optional.ofNullable(clazz.cast(this.dnsViews()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("dnsViews", DNS_VIEWS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDnsViewsResponse, T> g) {
        return obj -> g.apply((ListDnsViewsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53GlobalResolverResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<DNSViewSummary> dnsViews = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDnsViewsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.dnsViews(model.dnsViews);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<DNSViewSummary.Builder> getDnsViews() {
            List<DNSViewSummary.Builder> result = DNSViewsCopier.copyToBuilder(this.dnsViews);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDnsViews(Collection<DNSViewSummary.BuilderImpl> dnsViews) {
            this.dnsViews = DNSViewsCopier.copyFromBuilder(dnsViews);
        }

        @Override
        public final Builder dnsViews(Collection<DNSViewSummary> dnsViews) {
            this.dnsViews = DNSViewsCopier.copy(dnsViews);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsViews(DNSViewSummary ... dnsViews) {
            this.dnsViews(Arrays.asList(dnsViews));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsViews(Consumer<DNSViewSummary.Builder> ... dnsViews) {
            this.dnsViews(Stream.of(dnsViews).map(c -> (DNSViewSummary)((DNSViewSummary.Builder)DNSViewSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDnsViewsResponse build() {
            return new ListDnsViewsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53GlobalResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDnsViewsResponse> {
        public Builder nextToken(String var1);

        public Builder dnsViews(Collection<DNSViewSummary> var1);

        public Builder dnsViews(DNSViewSummary ... var1);

        public Builder dnsViews(Consumer<DNSViewSummary.Builder> ... var1);
    }
}

