/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53globalresolver.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53globalresolver.model.CRResourceStatus;
import software.amazon.awssdk.services.route53globalresolver.model.IPv4AddressesCopier;
import software.amazon.awssdk.services.route53globalresolver.model.RegionsCopier;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGlobalResolverResponse
extends Route53GlobalResolverResponse
implements ToCopyableBuilder<Builder, CreateGlobalResolverResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CreateGlobalResolverResponse.getter(CreateGlobalResolverResponse::id)).setter(CreateGlobalResolverResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateGlobalResolverResponse.getter(CreateGlobalResolverResponse::arn)).setter(CreateGlobalResolverResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateGlobalResolverResponse.getter(CreateGlobalResolverResponse::clientToken)).setter(CreateGlobalResolverResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CreateGlobalResolverResponse.getter(CreateGlobalResolverResponse::createdAt)).setter(CreateGlobalResolverResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateGlobalResolverResponse.getter(CreateGlobalResolverResponse::description)).setter(CreateGlobalResolverResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dnsName").getter(CreateGlobalResolverResponse.getter(CreateGlobalResolverResponse::dnsName)).setter(CreateGlobalResolverResponse.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsName").build()}).build();
    private static final SdkField<List<String>> IPV4_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ipv4Addresses").getter(CreateGlobalResolverResponse.getter(CreateGlobalResolverResponse::ipv4Addresses)).setter(CreateGlobalResolverResponse.setter(Builder::ipv4Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipv4Addresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateGlobalResolverResponse.getter(CreateGlobalResolverResponse::name)).setter(CreateGlobalResolverResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> OBSERVABILITY_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("observabilityRegion").getter(CreateGlobalResolverResponse.getter(CreateGlobalResolverResponse::observabilityRegion)).setter(CreateGlobalResolverResponse.setter(Builder::observabilityRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("observabilityRegion").build()}).build();
    private static final SdkField<List<String>> REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("regions").getter(CreateGlobalResolverResponse.getter(CreateGlobalResolverResponse::regions)).setter(CreateGlobalResolverResponse.setter(Builder::regions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateGlobalResolverResponse.getter(CreateGlobalResolverResponse::statusAsString)).setter(CreateGlobalResolverResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(CreateGlobalResolverResponse.getter(CreateGlobalResolverResponse::updatedAt)).setter(CreateGlobalResolverResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, CLIENT_TOKEN_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, DNS_NAME_FIELD, IPV4_ADDRESSES_FIELD, NAME_FIELD, OBSERVABILITY_REGION_FIELD, REGIONS_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateGlobalResolverResponse.memberNameToFieldInitializer();
    private final String id;
    private final String arn;
    private final String clientToken;
    private final Instant createdAt;
    private final String description;
    private final String dnsName;
    private final List<String> ipv4Addresses;
    private final String name;
    private final String observabilityRegion;
    private final List<String> regions;
    private final String status;
    private final Instant updatedAt;

    private CreateGlobalResolverResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.clientToken = builder.clientToken;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.dnsName = builder.dnsName;
        this.ipv4Addresses = builder.ipv4Addresses;
        this.name = builder.name;
        this.observabilityRegion = builder.observabilityRegion;
        this.regions = builder.regions;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final boolean hasIpv4Addresses() {
        return this.ipv4Addresses != null && !(this.ipv4Addresses instanceof SdkAutoConstructList);
    }

    public final List<String> ipv4Addresses() {
        return this.ipv4Addresses;
    }

    public final String name() {
        return this.name;
    }

    public final String observabilityRegion() {
        return this.observabilityRegion;
    }

    public final boolean hasRegions() {
        return this.regions != null && !(this.regions instanceof SdkAutoConstructList);
    }

    public final List<String> regions() {
        return this.regions;
    }

    public final CRResourceStatus status() {
        return CRResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv4Addresses() ? this.ipv4Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.observabilityRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegions() ? this.regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGlobalResolverResponse)) {
            return false;
        }
        CreateGlobalResolverResponse other = (CreateGlobalResolverResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.dnsName(), other.dnsName()) && this.hasIpv4Addresses() == other.hasIpv4Addresses() && Objects.equals(this.ipv4Addresses(), other.ipv4Addresses()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.observabilityRegion(), other.observabilityRegion()) && this.hasRegions() == other.hasRegions() && Objects.equals(this.regions(), other.regions()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGlobalResolverResponse").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("ClientToken", (Object)this.clientToken()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("DnsName", (Object)this.dnsName()).add("Ipv4Addresses", this.hasIpv4Addresses() ? this.ipv4Addresses() : null).add("Name", (Object)this.name()).add("ObservabilityRegion", (Object)this.observabilityRegion()).add("Regions", this.hasRegions() ? this.regions() : null).add("Status", (Object)this.statusAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "dnsName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "ipv4Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipv4Addresses()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "observabilityRegion": {
                return Optional.ofNullable(clazz.cast(this.observabilityRegion()));
            }
            case "regions": {
                return Optional.ofNullable(clazz.cast(this.regions()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("dnsName", DNS_NAME_FIELD);
        map.put("ipv4Addresses", IPV4_ADDRESSES_FIELD);
        map.put("name", NAME_FIELD);
        map.put("observabilityRegion", OBSERVABILITY_REGION_FIELD);
        map.put("regions", REGIONS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGlobalResolverResponse, T> g) {
        return obj -> g.apply((CreateGlobalResolverResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53GlobalResolverResponse.BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String clientToken;
        private Instant createdAt;
        private String description;
        private String dnsName;
        private List<String> ipv4Addresses = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String observabilityRegion;
        private List<String> regions = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGlobalResolverResponse model) {
            super(model);
            this.id(model.id);
            this.arn(model.arn);
            this.clientToken(model.clientToken);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.dnsName(model.dnsName);
            this.ipv4Addresses(model.ipv4Addresses);
            this.name(model.name);
            this.observabilityRegion(model.observabilityRegion);
            this.regions(model.regions);
            this.status(model.status);
            this.updatedAt(model.updatedAt);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final Collection<String> getIpv4Addresses() {
            if (this.ipv4Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ipv4Addresses;
        }

        public final void setIpv4Addresses(Collection<String> ipv4Addresses) {
            this.ipv4Addresses = IPv4AddressesCopier.copy(ipv4Addresses);
        }

        @Override
        public final Builder ipv4Addresses(Collection<String> ipv4Addresses) {
            this.ipv4Addresses = IPv4AddressesCopier.copy(ipv4Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Addresses(String ... ipv4Addresses) {
            this.ipv4Addresses(Arrays.asList(ipv4Addresses));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getObservabilityRegion() {
            return this.observabilityRegion;
        }

        public final void setObservabilityRegion(String observabilityRegion) {
            this.observabilityRegion = observabilityRegion;
        }

        @Override
        public final Builder observabilityRegion(String observabilityRegion) {
            this.observabilityRegion = observabilityRegion;
            return this;
        }

        public final Collection<String> getRegions() {
            if (this.regions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionsCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String ... regions) {
            this.regions(Arrays.asList(regions));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CRResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public CreateGlobalResolverResponse build() {
            return new CreateGlobalResolverResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53GlobalResolverResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGlobalResolverResponse> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder clientToken(String var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder dnsName(String var1);

        public Builder ipv4Addresses(Collection<String> var1);

        public Builder ipv4Addresses(String ... var1);

        public Builder name(String var1);

        public Builder observabilityRegion(String var1);

        public Builder regions(Collection<String> var1);

        public Builder regions(String ... var1);

        public Builder status(String var1);

        public Builder status(CRResourceStatus var1);

        public Builder updatedAt(Instant var1);
    }
}

