/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateHostedZoneAssociationRequest extends Route53GlobalResolverRequest implements
        ToCopyableBuilder<UpdateHostedZoneAssociationRequest.Builder, UpdateHostedZoneAssociationRequest> {
    private static final SdkField<String> HOSTED_ZONE_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostedZoneAssociationId").getter(getter(UpdateHostedZoneAssociationRequest::hostedZoneAssociationId))
            .setter(setter(Builder::hostedZoneAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("hostedZoneAssociationId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateHostedZoneAssociationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            HOSTED_ZONE_ASSOCIATION_ID_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String hostedZoneAssociationId;

    private final String name;

    private UpdateHostedZoneAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.hostedZoneAssociationId = builder.hostedZoneAssociationId;
        this.name = builder.name;
    }

    /**
     * <p>
     * The ID of the private hosted zone association.
     * </p>
     * 
     * @return The ID of the private hosted zone association.
     */
    public final String hostedZoneAssociationId() {
        return hostedZoneAssociationId;
    }

    /**
     * <p>
     * The name you want to update the hosted zone association to.
     * </p>
     * 
     * @return The name you want to update the hosted zone association to.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHostedZoneAssociationRequest)) {
            return false;
        }
        UpdateHostedZoneAssociationRequest other = (UpdateHostedZoneAssociationRequest) obj;
        return Objects.equals(hostedZoneAssociationId(), other.hostedZoneAssociationId()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateHostedZoneAssociationRequest").add("HostedZoneAssociationId", hostedZoneAssociationId())
                .add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "hostedZoneAssociationId":
            return Optional.ofNullable(clazz.cast(hostedZoneAssociationId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("hostedZoneAssociationId", HOSTED_ZONE_ASSOCIATION_ID_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateHostedZoneAssociationRequest, T> g) {
        return obj -> g.apply((UpdateHostedZoneAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53GlobalResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateHostedZoneAssociationRequest> {
        /**
         * <p>
         * The ID of the private hosted zone association.
         * </p>
         * 
         * @param hostedZoneAssociationId
         *        The ID of the private hosted zone association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneAssociationId(String hostedZoneAssociationId);

        /**
         * <p>
         * The name you want to update the hosted zone association to.
         * </p>
         * 
         * @param name
         *        The name you want to update the hosted zone association to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53GlobalResolverRequest.BuilderImpl implements Builder {
        private String hostedZoneAssociationId;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHostedZoneAssociationRequest model) {
            super(model);
            hostedZoneAssociationId(model.hostedZoneAssociationId);
            name(model.name);
        }

        public final String getHostedZoneAssociationId() {
            return hostedZoneAssociationId;
        }

        public final void setHostedZoneAssociationId(String hostedZoneAssociationId) {
            this.hostedZoneAssociationId = hostedZoneAssociationId;
        }

        @Override
        public final Builder hostedZoneAssociationId(String hostedZoneAssociationId) {
            this.hostedZoneAssociationId = hostedZoneAssociationId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHostedZoneAssociationRequest build() {
            return new UpdateHostedZoneAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
