/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDnsViewRequest extends Route53GlobalResolverRequest implements
        ToCopyableBuilder<UpdateDnsViewRequest.Builder, UpdateDnsViewRequest> {
    private static final SdkField<String> DNS_VIEW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dnsViewId").getter(getter(UpdateDnsViewRequest::dnsViewId)).setter(setter(Builder::dnsViewId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("dnsViewId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateDnsViewRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateDnsViewRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DNSSEC_VALIDATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dnssecValidation").getter(getter(UpdateDnsViewRequest::dnssecValidationAsString))
            .setter(setter(Builder::dnssecValidation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnssecValidation").build()).build();

    private static final SdkField<String> EDNS_CLIENT_SUBNET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ednsClientSubnet").getter(getter(UpdateDnsViewRequest::ednsClientSubnetAsString))
            .setter(setter(Builder::ednsClientSubnet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ednsClientSubnet").build()).build();

    private static final SdkField<String> FIREWALL_RULES_FAIL_OPEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("firewallRulesFailOpen").getter(getter(UpdateDnsViewRequest::firewallRulesFailOpenAsString))
            .setter(setter(Builder::firewallRulesFailOpen))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firewallRulesFailOpen").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DNS_VIEW_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, DNSSEC_VALIDATION_FIELD, EDNS_CLIENT_SUBNET_FIELD, FIREWALL_RULES_FAIL_OPEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dnsViewId;

    private final String name;

    private final String description;

    private final String dnssecValidation;

    private final String ednsClientSubnet;

    private final String firewallRulesFailOpen;

    private UpdateDnsViewRequest(BuilderImpl builder) {
        super(builder);
        this.dnsViewId = builder.dnsViewId;
        this.name = builder.name;
        this.description = builder.description;
        this.dnssecValidation = builder.dnssecValidation;
        this.ednsClientSubnet = builder.ednsClientSubnet;
        this.firewallRulesFailOpen = builder.firewallRulesFailOpen;
    }

    /**
     * <p>
     * The unique identifier of the DNS view to update.
     * </p>
     * 
     * @return The unique identifier of the DNS view to update.
     */
    public final String dnsViewId() {
        return dnsViewId;
    }

    /**
     * <p>
     * The name of the DNS view.
     * </p>
     * 
     * @return The name of the DNS view.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the DNS view.
     * </p>
     * 
     * @return A description of the DNS view.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Whether to enable DNSSEC validation for the DNS view.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnssecValidation}
     * will return {@link DnsSecValidationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dnssecValidationAsString}.
     * </p>
     * 
     * @return Whether to enable DNSSEC validation for the DNS view.
     * @see DnsSecValidationType
     */
    public final DnsSecValidationType dnssecValidation() {
        return DnsSecValidationType.fromValue(dnssecValidation);
    }

    /**
     * <p>
     * Whether to enable DNSSEC validation for the DNS view.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dnssecValidation}
     * will return {@link DnsSecValidationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #dnssecValidationAsString}.
     * </p>
     * 
     * @return Whether to enable DNSSEC validation for the DNS view.
     * @see DnsSecValidationType
     */
    public final String dnssecValidationAsString() {
        return dnssecValidation;
    }

    /**
     * <p>
     * Whether to enable EDNS Client Subnet injection for the DNS view.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ednsClientSubnet}
     * will return {@link EdnsClientSubnetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #ednsClientSubnetAsString}.
     * </p>
     * 
     * @return Whether to enable EDNS Client Subnet injection for the DNS view.
     * @see EdnsClientSubnetType
     */
    public final EdnsClientSubnetType ednsClientSubnet() {
        return EdnsClientSubnetType.fromValue(ednsClientSubnet);
    }

    /**
     * <p>
     * Whether to enable EDNS Client Subnet injection for the DNS view.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ednsClientSubnet}
     * will return {@link EdnsClientSubnetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #ednsClientSubnetAsString}.
     * </p>
     * 
     * @return Whether to enable EDNS Client Subnet injection for the DNS view.
     * @see EdnsClientSubnetType
     */
    public final String ednsClientSubnetAsString() {
        return ednsClientSubnet;
    }

    /**
     * <p>
     * Whether firewall rules should fail open when they cannot be evaluated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #firewallRulesFailOpen} will return {@link FirewallRulesFailOpenType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #firewallRulesFailOpenAsString}.
     * </p>
     * 
     * @return Whether firewall rules should fail open when they cannot be evaluated.
     * @see FirewallRulesFailOpenType
     */
    public final FirewallRulesFailOpenType firewallRulesFailOpen() {
        return FirewallRulesFailOpenType.fromValue(firewallRulesFailOpen);
    }

    /**
     * <p>
     * Whether firewall rules should fail open when they cannot be evaluated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #firewallRulesFailOpen} will return {@link FirewallRulesFailOpenType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #firewallRulesFailOpenAsString}.
     * </p>
     * 
     * @return Whether firewall rules should fail open when they cannot be evaluated.
     * @see FirewallRulesFailOpenType
     */
    public final String firewallRulesFailOpenAsString() {
        return firewallRulesFailOpen;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dnsViewId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dnssecValidationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ednsClientSubnetAsString());
        hashCode = 31 * hashCode + Objects.hashCode(firewallRulesFailOpenAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDnsViewRequest)) {
            return false;
        }
        UpdateDnsViewRequest other = (UpdateDnsViewRequest) obj;
        return Objects.equals(dnsViewId(), other.dnsViewId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(dnssecValidationAsString(), other.dnssecValidationAsString())
                && Objects.equals(ednsClientSubnetAsString(), other.ednsClientSubnetAsString())
                && Objects.equals(firewallRulesFailOpenAsString(), other.firewallRulesFailOpenAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDnsViewRequest").add("DnsViewId", dnsViewId()).add("Name", name())
                .add("Description", description()).add("DnssecValidation", dnssecValidationAsString())
                .add("EdnsClientSubnet", ednsClientSubnetAsString())
                .add("FirewallRulesFailOpen", firewallRulesFailOpenAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dnsViewId":
            return Optional.ofNullable(clazz.cast(dnsViewId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "dnssecValidation":
            return Optional.ofNullable(clazz.cast(dnssecValidationAsString()));
        case "ednsClientSubnet":
            return Optional.ofNullable(clazz.cast(ednsClientSubnetAsString()));
        case "firewallRulesFailOpen":
            return Optional.ofNullable(clazz.cast(firewallRulesFailOpenAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dnsViewId", DNS_VIEW_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("dnssecValidation", DNSSEC_VALIDATION_FIELD);
        map.put("ednsClientSubnet", EDNS_CLIENT_SUBNET_FIELD);
        map.put("firewallRulesFailOpen", FIREWALL_RULES_FAIL_OPEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDnsViewRequest, T> g) {
        return obj -> g.apply((UpdateDnsViewRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53GlobalResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDnsViewRequest> {
        /**
         * <p>
         * The unique identifier of the DNS view to update.
         * </p>
         * 
         * @param dnsViewId
         *        The unique identifier of the DNS view to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsViewId(String dnsViewId);

        /**
         * <p>
         * The name of the DNS view.
         * </p>
         * 
         * @param name
         *        The name of the DNS view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the DNS view.
         * </p>
         * 
         * @param description
         *        A description of the DNS view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Whether to enable DNSSEC validation for the DNS view.
         * </p>
         * 
         * @param dnssecValidation
         *        Whether to enable DNSSEC validation for the DNS view.
         * @see DnsSecValidationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsSecValidationType
         */
        Builder dnssecValidation(String dnssecValidation);

        /**
         * <p>
         * Whether to enable DNSSEC validation for the DNS view.
         * </p>
         * 
         * @param dnssecValidation
         *        Whether to enable DNSSEC validation for the DNS view.
         * @see DnsSecValidationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsSecValidationType
         */
        Builder dnssecValidation(DnsSecValidationType dnssecValidation);

        /**
         * <p>
         * Whether to enable EDNS Client Subnet injection for the DNS view.
         * </p>
         * 
         * @param ednsClientSubnet
         *        Whether to enable EDNS Client Subnet injection for the DNS view.
         * @see EdnsClientSubnetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EdnsClientSubnetType
         */
        Builder ednsClientSubnet(String ednsClientSubnet);

        /**
         * <p>
         * Whether to enable EDNS Client Subnet injection for the DNS view.
         * </p>
         * 
         * @param ednsClientSubnet
         *        Whether to enable EDNS Client Subnet injection for the DNS view.
         * @see EdnsClientSubnetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EdnsClientSubnetType
         */
        Builder ednsClientSubnet(EdnsClientSubnetType ednsClientSubnet);

        /**
         * <p>
         * Whether firewall rules should fail open when they cannot be evaluated.
         * </p>
         * 
         * @param firewallRulesFailOpen
         *        Whether firewall rules should fail open when they cannot be evaluated.
         * @see FirewallRulesFailOpenType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallRulesFailOpenType
         */
        Builder firewallRulesFailOpen(String firewallRulesFailOpen);

        /**
         * <p>
         * Whether firewall rules should fail open when they cannot be evaluated.
         * </p>
         * 
         * @param firewallRulesFailOpen
         *        Whether firewall rules should fail open when they cannot be evaluated.
         * @see FirewallRulesFailOpenType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallRulesFailOpenType
         */
        Builder firewallRulesFailOpen(FirewallRulesFailOpenType firewallRulesFailOpen);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53GlobalResolverRequest.BuilderImpl implements Builder {
        private String dnsViewId;

        private String name;

        private String description;

        private String dnssecValidation;

        private String ednsClientSubnet;

        private String firewallRulesFailOpen;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDnsViewRequest model) {
            super(model);
            dnsViewId(model.dnsViewId);
            name(model.name);
            description(model.description);
            dnssecValidation(model.dnssecValidation);
            ednsClientSubnet(model.ednsClientSubnet);
            firewallRulesFailOpen(model.firewallRulesFailOpen);
        }

        public final String getDnsViewId() {
            return dnsViewId;
        }

        public final void setDnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
        }

        @Override
        public final Builder dnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDnssecValidation() {
            return dnssecValidation;
        }

        public final void setDnssecValidation(String dnssecValidation) {
            this.dnssecValidation = dnssecValidation;
        }

        @Override
        public final Builder dnssecValidation(String dnssecValidation) {
            this.dnssecValidation = dnssecValidation;
            return this;
        }

        @Override
        public final Builder dnssecValidation(DnsSecValidationType dnssecValidation) {
            this.dnssecValidation(dnssecValidation == null ? null : dnssecValidation.toString());
            return this;
        }

        public final String getEdnsClientSubnet() {
            return ednsClientSubnet;
        }

        public final void setEdnsClientSubnet(String ednsClientSubnet) {
            this.ednsClientSubnet = ednsClientSubnet;
        }

        @Override
        public final Builder ednsClientSubnet(String ednsClientSubnet) {
            this.ednsClientSubnet = ednsClientSubnet;
            return this;
        }

        @Override
        public final Builder ednsClientSubnet(EdnsClientSubnetType ednsClientSubnet) {
            this.ednsClientSubnet(ednsClientSubnet == null ? null : ednsClientSubnet.toString());
            return this;
        }

        public final String getFirewallRulesFailOpen() {
            return firewallRulesFailOpen;
        }

        public final void setFirewallRulesFailOpen(String firewallRulesFailOpen) {
            this.firewallRulesFailOpen = firewallRulesFailOpen;
        }

        @Override
        public final Builder firewallRulesFailOpen(String firewallRulesFailOpen) {
            this.firewallRulesFailOpen = firewallRulesFailOpen;
            return this;
        }

        @Override
        public final Builder firewallRulesFailOpen(FirewallRulesFailOpenType firewallRulesFailOpen) {
            this.firewallRulesFailOpen(firewallRulesFailOpen == null ? null : firewallRulesFailOpen.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDnsViewRequest build() {
            return new UpdateDnsViewRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
