/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccessSourceRequest extends Route53GlobalResolverRequest implements
        ToCopyableBuilder<UpdateAccessSourceRequest.Builder, UpdateAccessSourceRequest> {
    private static final SdkField<String> ACCESS_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessSourceId").getter(getter(UpdateAccessSourceRequest::accessSourceId))
            .setter(setter(Builder::accessSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("accessSourceId").build()).build();

    private static final SdkField<String> CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cidr")
            .getter(getter(UpdateAccessSourceRequest::cidr)).setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidr").build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAddressType").getter(getter(UpdateAccessSourceRequest::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateAccessSourceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(UpdateAccessSourceRequest::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_SOURCE_ID_FIELD,
            CIDR_FIELD, IP_ADDRESS_TYPE_FIELD, NAME_FIELD, PROTOCOL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accessSourceId;

    private final String cidr;

    private final String ipAddressType;

    private final String name;

    private final String protocol;

    private UpdateAccessSourceRequest(BuilderImpl builder) {
        super(builder);
        this.accessSourceId = builder.accessSourceId;
        this.cidr = builder.cidr;
        this.ipAddressType = builder.ipAddressType;
        this.name = builder.name;
        this.protocol = builder.protocol;
    }

    /**
     * <p>
     * The unique identifier of the access source to update.
     * </p>
     * 
     * @return The unique identifier of the access source to update.
     */
    public final String accessSourceId() {
        return accessSourceId;
    }

    /**
     * <p>
     * The CIDR block for the access source.
     * </p>
     * 
     * @return The CIDR block for the access source.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * The IP address type for the access source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the access source.
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The IP address type for the access source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for the access source.
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    /**
     * <p>
     * The name of the access source.
     * </p>
     * 
     * @return The name of the access source.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The protocol for the access source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link DnsProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol for the access source.
     * @see DnsProtocol
     */
    public final DnsProtocol protocol() {
        return DnsProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol for the access source.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link DnsProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol for the access source.
     * @see DnsProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccessSourceRequest)) {
            return false;
        }
        UpdateAccessSourceRequest other = (UpdateAccessSourceRequest) obj;
        return Objects.equals(accessSourceId(), other.accessSourceId()) && Objects.equals(cidr(), other.cidr())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(protocolAsString(), other.protocolAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAccessSourceRequest").add("AccessSourceId", accessSourceId()).add("Cidr", cidr())
                .add("IpAddressType", ipAddressTypeAsString()).add("Name", name()).add("Protocol", protocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessSourceId":
            return Optional.ofNullable(clazz.cast(accessSourceId()));
        case "cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "ipAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessSourceId", ACCESS_SOURCE_ID_FIELD);
        map.put("cidr", CIDR_FIELD);
        map.put("ipAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccessSourceRequest, T> g) {
        return obj -> g.apply((UpdateAccessSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53GlobalResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAccessSourceRequest> {
        /**
         * <p>
         * The unique identifier of the access source to update.
         * </p>
         * 
         * @param accessSourceId
         *        The unique identifier of the access source to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessSourceId(String accessSourceId);

        /**
         * <p>
         * The CIDR block for the access source.
         * </p>
         * 
         * @param cidr
         *        The CIDR block for the access source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * The IP address type for the access source.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type for the access source.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The IP address type for the access source.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type for the access source.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        /**
         * <p>
         * The name of the access source.
         * </p>
         * 
         * @param name
         *        The name of the access source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The protocol for the access source.
         * </p>
         * 
         * @param protocol
         *        The protocol for the access source.
         * @see DnsProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol for the access source.
         * </p>
         * 
         * @param protocol
         *        The protocol for the access source.
         * @see DnsProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsProtocol
         */
        Builder protocol(DnsProtocol protocol);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53GlobalResolverRequest.BuilderImpl implements Builder {
        private String accessSourceId;

        private String cidr;

        private String ipAddressType;

        private String name;

        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccessSourceRequest model) {
            super(model);
            accessSourceId(model.accessSourceId);
            cidr(model.cidr);
            ipAddressType(model.ipAddressType);
            name(model.name);
            protocol(model.protocol);
        }

        public final String getAccessSourceId() {
            return accessSourceId;
        }

        public final void setAccessSourceId(String accessSourceId) {
            this.accessSourceId = accessSourceId;
        }

        @Override
        public final Builder accessSourceId(String accessSourceId) {
            this.accessSourceId = accessSourceId;
            return this;
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(DnsProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAccessSourceRequest build() {
            return new UpdateAccessSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
