/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListManagedFirewallDomainListsRequest extends Route53GlobalResolverRequest implements
        ToCopyableBuilder<ListManagedFirewallDomainListsRequest.Builder, ListManagedFirewallDomainListsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListManagedFirewallDomainListsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max_results").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListManagedFirewallDomainListsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next_token").build()).build();

    private static final SdkField<String> MANAGED_FIREWALL_DOMAIN_LIST_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("managedFirewallDomainListType")
            .getter(getter(ListManagedFirewallDomainListsRequest::managedFirewallDomainListType))
            .setter(setter(Builder::managedFirewallDomainListType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("managedFirewallDomainListType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, MANAGED_FIREWALL_DOMAIN_LIST_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxResults;

    private final String nextToken;

    private final String managedFirewallDomainListType;

    private ListManagedFirewallDomainListsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.managedFirewallDomainListType = builder.managedFirewallDomainListType;
    }

    /**
     * <p>
     * The maximum number of results to retrieve in a single call.
     * </p>
     * 
     * @return The maximum number of results to retrieve in a single call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A pagination token used for large sets of results that can't be returned in a single response.
     * </p>
     * 
     * @return A pagination token used for large sets of results that can't be returned in a single response.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The category of the Manage DNS list either <code>THREAT</code> or <code>CONTENT</code>.
     * </p>
     * 
     * @return The category of the Manage DNS list either <code>THREAT</code> or <code>CONTENT</code>.
     */
    public final String managedFirewallDomainListType() {
        return managedFirewallDomainListType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(managedFirewallDomainListType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListManagedFirewallDomainListsRequest)) {
            return false;
        }
        ListManagedFirewallDomainListsRequest other = (ListManagedFirewallDomainListsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(managedFirewallDomainListType(), other.managedFirewallDomainListType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListManagedFirewallDomainListsRequest").add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("ManagedFirewallDomainListType", managedFirewallDomainListType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "managedFirewallDomainListType":
            return Optional.ofNullable(clazz.cast(managedFirewallDomainListType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("max_results", MAX_RESULTS_FIELD);
        map.put("next_token", NEXT_TOKEN_FIELD);
        map.put("managedFirewallDomainListType", MANAGED_FIREWALL_DOMAIN_LIST_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListManagedFirewallDomainListsRequest, T> g) {
        return obj -> g.apply((ListManagedFirewallDomainListsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53GlobalResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListManagedFirewallDomainListsRequest> {
        /**
         * <p>
         * The maximum number of results to retrieve in a single call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to retrieve in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A pagination token used for large sets of results that can't be returned in a single response.
         * </p>
         * 
         * @param nextToken
         *        A pagination token used for large sets of results that can't be returned in a single response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The category of the Manage DNS list either <code>THREAT</code> or <code>CONTENT</code>.
         * </p>
         * 
         * @param managedFirewallDomainListType
         *        The category of the Manage DNS list either <code>THREAT</code> or <code>CONTENT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedFirewallDomainListType(String managedFirewallDomainListType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53GlobalResolverRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String managedFirewallDomainListType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListManagedFirewallDomainListsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            managedFirewallDomainListType(model.managedFirewallDomainListType);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getManagedFirewallDomainListType() {
            return managedFirewallDomainListType;
        }

        public final void setManagedFirewallDomainListType(String managedFirewallDomainListType) {
            this.managedFirewallDomainListType = managedFirewallDomainListType;
        }

        @Override
        public final Builder managedFirewallDomainListType(String managedFirewallDomainListType) {
            this.managedFirewallDomainListType = managedFirewallDomainListType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListManagedFirewallDomainListsRequest build() {
            return new ListManagedFirewallDomainListsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
