/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFirewallRulesResponse extends Route53GlobalResolverResponse implements
        ToCopyableBuilder<ListFirewallRulesResponse.Builder, ListFirewallRulesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFirewallRulesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<FirewallRulesItem>> FIREWALL_RULES_FIELD = SdkField
            .<List<FirewallRulesItem>> builder(MarshallingType.LIST)
            .memberName("firewallRules")
            .getter(getter(ListFirewallRulesResponse::firewallRules))
            .setter(setter(Builder::firewallRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firewallRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FirewallRulesItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(FirewallRulesItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            FIREWALL_RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<FirewallRulesItem> firewallRules;

    private ListFirewallRulesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.firewallRules = builder.firewallRules;
    }

    /**
     * <p>
     * A pagination token used for large sets of results that can't be returned in a single response. Provide this token
     * in the next call to get the results not returned in this call.
     * </p>
     * 
     * @return A pagination token used for large sets of results that can't be returned in a single response. Provide
     *         this token in the next call to get the results not returned in this call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FirewallRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFirewallRules() {
        return firewallRules != null && !(firewallRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of the firewall rules and information about them.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFirewallRules} method.
     * </p>
     * 
     * @return List of the firewall rules and information about them.
     */
    public final List<FirewallRulesItem> firewallRules() {
        return firewallRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasFirewallRules() ? firewallRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFirewallRulesResponse)) {
            return false;
        }
        ListFirewallRulesResponse other = (ListFirewallRulesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasFirewallRules() == other.hasFirewallRules()
                && Objects.equals(firewallRules(), other.firewallRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFirewallRulesResponse").add("NextToken", nextToken())
                .add("FirewallRules", hasFirewallRules() ? firewallRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "firewallRules":
            return Optional.ofNullable(clazz.cast(firewallRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("firewallRules", FIREWALL_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFirewallRulesResponse, T> g) {
        return obj -> g.apply((ListFirewallRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53GlobalResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFirewallRulesResponse> {
        /**
         * <p>
         * A pagination token used for large sets of results that can't be returned in a single response. Provide this
         * token in the next call to get the results not returned in this call.
         * </p>
         * 
         * @param nextToken
         *        A pagination token used for large sets of results that can't be returned in a single response. Provide
         *        this token in the next call to get the results not returned in this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * List of the firewall rules and information about them.
         * </p>
         * 
         * @param firewallRules
         *        List of the firewall rules and information about them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallRules(Collection<FirewallRulesItem> firewallRules);

        /**
         * <p>
         * List of the firewall rules and information about them.
         * </p>
         * 
         * @param firewallRules
         *        List of the firewall rules and information about them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallRules(FirewallRulesItem... firewallRules);

        /**
         * <p>
         * List of the firewall rules and information about them.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53globalresolver.model.FirewallRulesItem.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.route53globalresolver.model.FirewallRulesItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53globalresolver.model.FirewallRulesItem.Builder#build()} is
         * called immediately and its result is passed to {@link #firewallRules(List<FirewallRulesItem>)}.
         * 
         * @param firewallRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53globalresolver.model.FirewallRulesItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewallRules(java.util.Collection<FirewallRulesItem>)
         */
        Builder firewallRules(Consumer<FirewallRulesItem.Builder>... firewallRules);
    }

    static final class BuilderImpl extends Route53GlobalResolverResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<FirewallRulesItem> firewallRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFirewallRulesResponse model) {
            super(model);
            nextToken(model.nextToken);
            firewallRules(model.firewallRules);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<FirewallRulesItem.Builder> getFirewallRules() {
            List<FirewallRulesItem.Builder> result = FirewallRulesCopier.copyToBuilder(this.firewallRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFirewallRules(Collection<FirewallRulesItem.BuilderImpl> firewallRules) {
            this.firewallRules = FirewallRulesCopier.copyFromBuilder(firewallRules);
        }

        @Override
        public final Builder firewallRules(Collection<FirewallRulesItem> firewallRules) {
            this.firewallRules = FirewallRulesCopier.copy(firewallRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallRules(FirewallRulesItem... firewallRules) {
            firewallRules(Arrays.asList(firewallRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallRules(Consumer<FirewallRulesItem.Builder>... firewallRules) {
            firewallRules(Stream.of(firewallRules).map(c -> FirewallRulesItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListFirewallRulesResponse build() {
            return new ListFirewallRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
