/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFirewallDomainListsResponse extends Route53GlobalResolverResponse implements
        ToCopyableBuilder<ListFirewallDomainListsResponse.Builder, ListFirewallDomainListsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFirewallDomainListsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<FirewallDomainListsItem>> FIREWALL_DOMAIN_LISTS_FIELD = SdkField
            .<List<FirewallDomainListsItem>> builder(MarshallingType.LIST)
            .memberName("firewallDomainLists")
            .getter(getter(ListFirewallDomainListsResponse::firewallDomainLists))
            .setter(setter(Builder::firewallDomainLists))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firewallDomainLists").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FirewallDomainListsItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(FirewallDomainListsItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            FIREWALL_DOMAIN_LISTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<FirewallDomainListsItem> firewallDomainLists;

    private ListFirewallDomainListsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.firewallDomainLists = builder.firewallDomainLists;
    }

    /**
     * <p>
     * A pagination token used for large sets of results that can't be returned in a single response. Provide this token
     * in the next call to get the results not returned in this call.
     * </p>
     * 
     * @return A pagination token used for large sets of results that can't be returned in a single response. Provide
     *         this token in the next call to get the results not returned in this call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the FirewallDomainLists property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFirewallDomainLists() {
        return firewallDomainLists != null && !(firewallDomainLists instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of the DNS Firewall domain lists.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFirewallDomainLists} method.
     * </p>
     * 
     * @return List of the DNS Firewall domain lists.
     */
    public final List<FirewallDomainListsItem> firewallDomainLists() {
        return firewallDomainLists;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasFirewallDomainLists() ? firewallDomainLists() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFirewallDomainListsResponse)) {
            return false;
        }
        ListFirewallDomainListsResponse other = (ListFirewallDomainListsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasFirewallDomainLists() == other.hasFirewallDomainLists()
                && Objects.equals(firewallDomainLists(), other.firewallDomainLists());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFirewallDomainListsResponse").add("NextToken", nextToken())
                .add("FirewallDomainLists", hasFirewallDomainLists() ? firewallDomainLists() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "firewallDomainLists":
            return Optional.ofNullable(clazz.cast(firewallDomainLists()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("firewallDomainLists", FIREWALL_DOMAIN_LISTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFirewallDomainListsResponse, T> g) {
        return obj -> g.apply((ListFirewallDomainListsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53GlobalResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFirewallDomainListsResponse> {
        /**
         * <p>
         * A pagination token used for large sets of results that can't be returned in a single response. Provide this
         * token in the next call to get the results not returned in this call.
         * </p>
         * 
         * @param nextToken
         *        A pagination token used for large sets of results that can't be returned in a single response. Provide
         *        this token in the next call to get the results not returned in this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * List of the DNS Firewall domain lists.
         * </p>
         * 
         * @param firewallDomainLists
         *        List of the DNS Firewall domain lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallDomainLists(Collection<FirewallDomainListsItem> firewallDomainLists);

        /**
         * <p>
         * List of the DNS Firewall domain lists.
         * </p>
         * 
         * @param firewallDomainLists
         *        List of the DNS Firewall domain lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallDomainLists(FirewallDomainListsItem... firewallDomainLists);

        /**
         * <p>
         * List of the DNS Firewall domain lists.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53globalresolver.model.FirewallDomainListsItem.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.route53globalresolver.model.FirewallDomainListsItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53globalresolver.model.FirewallDomainListsItem.Builder#build()}
         * is called immediately and its result is passed to {@link #firewallDomainLists(List<FirewallDomainListsItem>)}.
         * 
         * @param firewallDomainLists
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53globalresolver.model.FirewallDomainListsItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewallDomainLists(java.util.Collection<FirewallDomainListsItem>)
         */
        Builder firewallDomainLists(Consumer<FirewallDomainListsItem.Builder>... firewallDomainLists);
    }

    static final class BuilderImpl extends Route53GlobalResolverResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<FirewallDomainListsItem> firewallDomainLists = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFirewallDomainListsResponse model) {
            super(model);
            nextToken(model.nextToken);
            firewallDomainLists(model.firewallDomainLists);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<FirewallDomainListsItem.Builder> getFirewallDomainLists() {
            List<FirewallDomainListsItem.Builder> result = FirewallDomainListsCopier.copyToBuilder(this.firewallDomainLists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFirewallDomainLists(Collection<FirewallDomainListsItem.BuilderImpl> firewallDomainLists) {
            this.firewallDomainLists = FirewallDomainListsCopier.copyFromBuilder(firewallDomainLists);
        }

        @Override
        public final Builder firewallDomainLists(Collection<FirewallDomainListsItem> firewallDomainLists) {
            this.firewallDomainLists = FirewallDomainListsCopier.copy(firewallDomainLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallDomainLists(FirewallDomainListsItem... firewallDomainLists) {
            firewallDomainLists(Arrays.asList(firewallDomainLists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallDomainLists(Consumer<FirewallDomainListsItem.Builder>... firewallDomainLists) {
            firewallDomainLists(Stream.of(firewallDomainLists)
                    .map(c -> FirewallDomainListsItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListFirewallDomainListsResponse build() {
            return new ListFirewallDomainListsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
