/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccessSourceResponse extends Route53GlobalResolverResponse implements
        ToCopyableBuilder<GetAccessSourceResponse.Builder, GetAccessSourceResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetAccessSourceResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cidr")
            .getter(getter(GetAccessSourceResponse::cidr)).setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidr").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetAccessSourceResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetAccessSourceResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAddressType").getter(getter(GetAccessSourceResponse::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetAccessSourceResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DNS_VIEW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dnsViewId").getter(getter(GetAccessSourceResponse::dnsViewId)).setter(setter(Builder::dnsViewId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsViewId").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(GetAccessSourceResponse::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetAccessSourceResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetAccessSourceResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CIDR_FIELD,
            CREATED_AT_FIELD, ID_FIELD, IP_ADDRESS_TYPE_FIELD, NAME_FIELD, DNS_VIEW_ID_FIELD, PROTOCOL_FIELD, STATUS_FIELD,
            UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String cidr;

    private final Instant createdAt;

    private final String id;

    private final String ipAddressType;

    private final String name;

    private final String dnsViewId;

    private final String protocol;

    private final String status;

    private final Instant updatedAt;

    private GetAccessSourceResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.cidr = builder.cidr;
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.ipAddressType = builder.ipAddressType;
        this.name = builder.name;
        this.dnsViewId = builder.dnsViewId;
        this.protocol = builder.protocol;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the access source.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the access source.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The IP range for the rule's parameters in CIDR notation.
     * </p>
     * 
     * @return The IP range for the rule's parameters in CIDR notation.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * The time and date the rule was created.
     * </p>
     * 
     * @return The time and date the rule was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * ID for the rule.
     * </p>
     * 
     * @return ID for the rule.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The IP address type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type.
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The IP address type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type.
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    /**
     * <p>
     * Name for the access source.
     * </p>
     * 
     * @return Name for the access source.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * ID for the DNS view that the rule is associated to.
     * </p>
     * 
     * @return ID for the DNS view that the rule is associated to.
     */
    public final String dnsViewId() {
        return dnsViewId;
    }

    /**
     * <p>
     * The protocol determines how data is transmitted to a Global Resolver instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link DnsProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol determines how data is transmitted to a Global Resolver instance.
     * @see DnsProtocol
     */
    public final DnsProtocol protocol() {
        return DnsProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol determines how data is transmitted to a Global Resolver instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link DnsProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol determines how data is transmitted to a Global Resolver instance.
     * @see DnsProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * Information about the status of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CRResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Information about the status of the rule.
     * @see CRResourceStatus
     */
    public final CRResourceStatus status() {
        return CRResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * Information about the status of the rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CRResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Information about the status of the rule.
     * @see CRResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time and date the access source was updated.
     * </p>
     * 
     * @return The time and date the access source was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(dnsViewId());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessSourceResponse)) {
            return false;
        }
        GetAccessSourceResponse other = (GetAccessSourceResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(cidr(), other.cidr())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(id(), other.id())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(dnsViewId(), other.dnsViewId()) && Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccessSourceResponse").add("Arn", arn()).add("Cidr", cidr()).add("CreatedAt", createdAt())
                .add("Id", id()).add("IpAddressType", ipAddressTypeAsString()).add("Name", name()).add("DnsViewId", dnsViewId())
                .add("Protocol", protocolAsString()).add("Status", statusAsString()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "ipAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "dnsViewId":
            return Optional.ofNullable(clazz.cast(dnsViewId()));
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("cidr", CIDR_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("id", ID_FIELD);
        map.put("ipAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("dnsViewId", DNS_VIEW_ID_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAccessSourceResponse, T> g) {
        return obj -> g.apply((GetAccessSourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53GlobalResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAccessSourceResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the access source.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the access source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The IP range for the rule's parameters in CIDR notation.
         * </p>
         * 
         * @param cidr
         *        The IP range for the rule's parameters in CIDR notation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * The time and date the rule was created.
         * </p>
         * 
         * @param createdAt
         *        The time and date the rule was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * ID for the rule.
         * </p>
         * 
         * @param id
         *        ID for the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The IP address type.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The IP address type.
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type.
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        /**
         * <p>
         * Name for the access source.
         * </p>
         * 
         * @param name
         *        Name for the access source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * ID for the DNS view that the rule is associated to.
         * </p>
         * 
         * @param dnsViewId
         *        ID for the DNS view that the rule is associated to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsViewId(String dnsViewId);

        /**
         * <p>
         * The protocol determines how data is transmitted to a Global Resolver instance.
         * </p>
         * 
         * @param protocol
         *        The protocol determines how data is transmitted to a Global Resolver instance.
         * @see DnsProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol determines how data is transmitted to a Global Resolver instance.
         * </p>
         * 
         * @param protocol
         *        The protocol determines how data is transmitted to a Global Resolver instance.
         * @see DnsProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsProtocol
         */
        Builder protocol(DnsProtocol protocol);

        /**
         * <p>
         * Information about the status of the rule.
         * </p>
         * 
         * @param status
         *        Information about the status of the rule.
         * @see CRResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CRResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Information about the status of the rule.
         * </p>
         * 
         * @param status
         *        Information about the status of the rule.
         * @see CRResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CRResourceStatus
         */
        Builder status(CRResourceStatus status);

        /**
         * <p>
         * The time and date the access source was updated.
         * </p>
         * 
         * @param updatedAt
         *        The time and date the access source was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl extends Route53GlobalResolverResponse.BuilderImpl implements Builder {
        private String arn;

        private String cidr;

        private Instant createdAt;

        private String id;

        private String ipAddressType;

        private String name;

        private String dnsViewId;

        private String protocol;

        private String status;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessSourceResponse model) {
            super(model);
            arn(model.arn);
            cidr(model.cidr);
            createdAt(model.createdAt);
            id(model.id);
            ipAddressType(model.ipAddressType);
            name(model.name);
            dnsViewId(model.dnsViewId);
            protocol(model.protocol);
            status(model.status);
            updatedAt(model.updatedAt);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDnsViewId() {
            return dnsViewId;
        }

        public final void setDnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
        }

        @Override
        public final Builder dnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(DnsProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CRResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetAccessSourceResponse build() {
            return new GetAccessSourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
