/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccessSourceRequest extends Route53GlobalResolverRequest implements
        ToCopyableBuilder<CreateAccessSourceRequest.Builder, CreateAccessSourceRequest> {
    private static final SdkField<String> CIDR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cidr")
            .getter(getter(CreateAccessSourceRequest::cidr)).setter(setter(Builder::cidr))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidr").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateAccessSourceRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAddressType").getter(getter(CreateAccessSourceRequest::ipAddressTypeAsString))
            .setter(setter(Builder::ipAddressType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddressType").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAccessSourceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DNS_VIEW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dnsViewId").getter(getter(CreateAccessSourceRequest::dnsViewId)).setter(setter(Builder::dnsViewId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsViewId").build()).build();

    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("protocol").getter(getter(CreateAccessSourceRequest::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocol").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateAccessSourceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_FIELD,
            CLIENT_TOKEN_FIELD, IP_ADDRESS_TYPE_FIELD, NAME_FIELD, DNS_VIEW_ID_FIELD, PROTOCOL_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String cidr;

    private final String clientToken;

    private final String ipAddressType;

    private final String name;

    private final String dnsViewId;

    private final String protocol;

    private final Map<String, String> tags;

    private CreateAccessSourceRequest(BuilderImpl builder) {
        super(builder);
        this.cidr = builder.cidr;
        this.clientToken = builder.clientToken;
        this.ipAddressType = builder.ipAddressType;
        this.name = builder.name;
        this.dnsViewId = builder.dnsViewId;
        this.protocol = builder.protocol;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The IP address or CIDR range that is allowed to send DNS queries to the Route 53 Global Resolver.
     * </p>
     * 
     * @return The IP address or CIDR range that is allowed to send DNS queries to the Route 53 Global Resolver.
     */
    public final String cidr() {
        return cidr;
    }

    /**
     * <p>
     * A unique string that identifies the request and ensures idempotency.
     * </p>
     * 
     * @return A unique string that identifies the request and ensures idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The IP address type for this access source. Valid values are IPv4 and IPv6 (if the Route 53 Global Resolver
     * supports dual-stack).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for this access source. Valid values are IPv4 and IPv6 (if the Route 53 Global
     *         Resolver supports dual-stack).
     * @see IpAddressType
     */
    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(ipAddressType);
    }

    /**
     * <p>
     * The IP address type for this access source. Valid values are IPv4 and IPv6 (if the Route 53 Global Resolver
     * supports dual-stack).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipAddressType}
     * will return {@link IpAddressType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ipAddressTypeAsString}.
     * </p>
     * 
     * @return The IP address type for this access source. Valid values are IPv4 and IPv6 (if the Route 53 Global
     *         Resolver supports dual-stack).
     * @see IpAddressType
     */
    public final String ipAddressTypeAsString() {
        return ipAddressType;
    }

    /**
     * <p>
     * A descriptive name for the access source.
     * </p>
     * 
     * @return A descriptive name for the access source.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the DNS view to associate with this access source.
     * </p>
     * 
     * @return The ID of the DNS view to associate with this access source.
     */
    public final String dnsViewId() {
        return dnsViewId;
    }

    /**
     * <p>
     * The DNS protocol that is permitted for this access source. Valid values are Do53 (DNS over port 53), DoT (DNS
     * over TLS), and DoH (DNS over HTTPS).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link DnsProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The DNS protocol that is permitted for this access source. Valid values are Do53 (DNS over port 53), DoT
     *         (DNS over TLS), and DoH (DNS over HTTPS).
     * @see DnsProtocol
     */
    public final DnsProtocol protocol() {
        return DnsProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The DNS protocol that is permitted for this access source. Valid values are Do53 (DNS over port 53), DoT (DNS
     * over TLS), and DoH (DNS over HTTPS).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link DnsProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The DNS protocol that is permitted for this access source. Valid values are Do53 (DNS over port 53), DoT
     *         (DNS over TLS), and DoH (DNS over HTTPS).
     * @see DnsProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags to associate with the access source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to associate with the access source.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cidr());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(dnsViewId());
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessSourceRequest)) {
            return false;
        }
        CreateAccessSourceRequest other = (CreateAccessSourceRequest) obj;
        return Objects.equals(cidr(), other.cidr()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(ipAddressTypeAsString(), other.ipAddressTypeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(dnsViewId(), other.dnsViewId()) && Objects.equals(protocolAsString(), other.protocolAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccessSourceRequest").add("Cidr", cidr()).add("ClientToken", clientToken())
                .add("IpAddressType", ipAddressTypeAsString()).add("Name", name()).add("DnsViewId", dnsViewId())
                .add("Protocol", protocolAsString()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cidr":
            return Optional.ofNullable(clazz.cast(cidr()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ipAddressType":
            return Optional.ofNullable(clazz.cast(ipAddressTypeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "dnsViewId":
            return Optional.ofNullable(clazz.cast(dnsViewId()));
        case "protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cidr", CIDR_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("ipAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("dnsViewId", DNS_VIEW_ID_FIELD);
        map.put("protocol", PROTOCOL_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessSourceRequest, T> g) {
        return obj -> g.apply((CreateAccessSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53GlobalResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAccessSourceRequest> {
        /**
         * <p>
         * The IP address or CIDR range that is allowed to send DNS queries to the Route 53 Global Resolver.
         * </p>
         * 
         * @param cidr
         *        The IP address or CIDR range that is allowed to send DNS queries to the Route 53 Global Resolver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidr(String cidr);

        /**
         * <p>
         * A unique string that identifies the request and ensures idempotency.
         * </p>
         * 
         * @param clientToken
         *        A unique string that identifies the request and ensures idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The IP address type for this access source. Valid values are IPv4 and IPv6 (if the Route 53 Global Resolver
         * supports dual-stack).
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type for this access source. Valid values are IPv4 and IPv6 (if the Route 53 Global
         *        Resolver supports dual-stack).
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(String ipAddressType);

        /**
         * <p>
         * The IP address type for this access source. Valid values are IPv4 and IPv6 (if the Route 53 Global Resolver
         * supports dual-stack).
         * </p>
         * 
         * @param ipAddressType
         *        The IP address type for this access source. Valid values are IPv4 and IPv6 (if the Route 53 Global
         *        Resolver supports dual-stack).
         * @see IpAddressType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpAddressType
         */
        Builder ipAddressType(IpAddressType ipAddressType);

        /**
         * <p>
         * A descriptive name for the access source.
         * </p>
         * 
         * @param name
         *        A descriptive name for the access source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the DNS view to associate with this access source.
         * </p>
         * 
         * @param dnsViewId
         *        The ID of the DNS view to associate with this access source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsViewId(String dnsViewId);

        /**
         * <p>
         * The DNS protocol that is permitted for this access source. Valid values are Do53 (DNS over port 53), DoT (DNS
         * over TLS), and DoH (DNS over HTTPS).
         * </p>
         * 
         * @param protocol
         *        The DNS protocol that is permitted for this access source. Valid values are Do53 (DNS over port 53),
         *        DoT (DNS over TLS), and DoH (DNS over HTTPS).
         * @see DnsProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The DNS protocol that is permitted for this access source. Valid values are Do53 (DNS over port 53), DoT (DNS
         * over TLS), and DoH (DNS over HTTPS).
         * </p>
         * 
         * @param protocol
         *        The DNS protocol that is permitted for this access source. Valid values are Do53 (DNS over port 53),
         *        DoT (DNS over TLS), and DoH (DNS over HTTPS).
         * @see DnsProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsProtocol
         */
        Builder protocol(DnsProtocol protocol);

        /**
         * <p>
         * Tags to associate with the access source.
         * </p>
         * 
         * @param tags
         *        Tags to associate with the access source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53GlobalResolverRequest.BuilderImpl implements Builder {
        private String cidr;

        private String clientToken;

        private String ipAddressType;

        private String name;

        private String dnsViewId;

        private String protocol;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessSourceRequest model) {
            super(model);
            cidr(model.cidr);
            clientToken(model.clientToken);
            ipAddressType(model.ipAddressType);
            name(model.name);
            dnsViewId(model.dnsViewId);
            protocol(model.protocol);
            tags(model.tags);
        }

        public final String getCidr() {
            return cidr;
        }

        public final void setCidr(String cidr) {
            this.cidr = cidr;
        }

        @Override
        public final Builder cidr(String cidr) {
            this.cidr = cidr;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getIpAddressType() {
            return ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDnsViewId() {
            return dnsViewId;
        }

        public final void setDnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
        }

        @Override
        public final Builder dnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
            return this;
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(DnsProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAccessSourceRequest build() {
            return new CreateAccessSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
