/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateFirewallRuleResponse extends Route53GlobalResolverResponse implements
        ToCopyableBuilder<BatchUpdateFirewallRuleResponse.Builder, BatchUpdateFirewallRuleResponse> {
    private static final SdkField<List<BatchUpdateFirewallRuleOutputItem>> FAILURES_FIELD = SdkField
            .<List<BatchUpdateFirewallRuleOutputItem>> builder(MarshallingType.LIST)
            .memberName("failures")
            .getter(getter(BatchUpdateFirewallRuleResponse::failures))
            .setter(setter(Builder::failures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchUpdateFirewallRuleOutputItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchUpdateFirewallRuleOutputItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<BatchUpdateFirewallRuleOutputItem>> SUCCESSES_FIELD = SdkField
            .<List<BatchUpdateFirewallRuleOutputItem>> builder(MarshallingType.LIST)
            .memberName("successes")
            .getter(getter(BatchUpdateFirewallRuleResponse::successes))
            .setter(setter(Builder::successes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchUpdateFirewallRuleOutputItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchUpdateFirewallRuleOutputItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURES_FIELD,
            SUCCESSES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchUpdateFirewallRuleOutputItem> failures;

    private final List<BatchUpdateFirewallRuleOutputItem> successes;

    private BatchUpdateFirewallRuleResponse(BuilderImpl builder) {
        super(builder);
        this.failures = builder.failures;
        this.successes = builder.successes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Failures property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFailures() {
        return failures != null && !(failures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * High level information about the DNS Firewall rules that failed to update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailures} method.
     * </p>
     * 
     * @return High level information about the DNS Firewall rules that failed to update.
     */
    public final List<BatchUpdateFirewallRuleOutputItem> failures() {
        return failures;
    }

    /**
     * For responses, this returns true if the service returned a value for the Successes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSuccesses() {
        return successes != null && !(successes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * High level information about the DNS Firewall rules that were successfully updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSuccesses} method.
     * </p>
     * 
     * @return High level information about the DNS Firewall rules that were successfully updated.
     */
    public final List<BatchUpdateFirewallRuleOutputItem> successes() {
        return successes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFailures() ? failures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSuccesses() ? successes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateFirewallRuleResponse)) {
            return false;
        }
        BatchUpdateFirewallRuleResponse other = (BatchUpdateFirewallRuleResponse) obj;
        return hasFailures() == other.hasFailures() && Objects.equals(failures(), other.failures())
                && hasSuccesses() == other.hasSuccesses() && Objects.equals(successes(), other.successes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateFirewallRuleResponse").add("Failures", hasFailures() ? failures() : null)
                .add("Successes", hasSuccesses() ? successes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "failures":
            return Optional.ofNullable(clazz.cast(failures()));
        case "successes":
            return Optional.ofNullable(clazz.cast(successes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("failures", FAILURES_FIELD);
        map.put("successes", SUCCESSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateFirewallRuleResponse, T> g) {
        return obj -> g.apply((BatchUpdateFirewallRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53GlobalResolverResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdateFirewallRuleResponse> {
        /**
         * <p>
         * High level information about the DNS Firewall rules that failed to update.
         * </p>
         * 
         * @param failures
         *        High level information about the DNS Firewall rules that failed to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(Collection<BatchUpdateFirewallRuleOutputItem> failures);

        /**
         * <p>
         * High level information about the DNS Firewall rules that failed to update.
         * </p>
         * 
         * @param failures
         *        High level information about the DNS Firewall rules that failed to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failures(BatchUpdateFirewallRuleOutputItem... failures);

        /**
         * <p>
         * High level information about the DNS Firewall rules that failed to update.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleOutputItem.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleOutputItem#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleOutputItem.Builder#build()}
         * is called immediately and its result is passed to {@link #failures(List<BatchUpdateFirewallRuleOutputItem>)}.
         * 
         * @param failures
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleOutputItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failures(java.util.Collection<BatchUpdateFirewallRuleOutputItem>)
         */
        Builder failures(Consumer<BatchUpdateFirewallRuleOutputItem.Builder>... failures);

        /**
         * <p>
         * High level information about the DNS Firewall rules that were successfully updated.
         * </p>
         * 
         * @param successes
         *        High level information about the DNS Firewall rules that were successfully updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successes(Collection<BatchUpdateFirewallRuleOutputItem> successes);

        /**
         * <p>
         * High level information about the DNS Firewall rules that were successfully updated.
         * </p>
         * 
         * @param successes
         *        High level information about the DNS Firewall rules that were successfully updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successes(BatchUpdateFirewallRuleOutputItem... successes);

        /**
         * <p>
         * High level information about the DNS Firewall rules that were successfully updated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleOutputItem.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleOutputItem#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleOutputItem.Builder#build()}
         * is called immediately and its result is passed to {@link #successes(List<BatchUpdateFirewallRuleOutputItem>)}.
         * 
         * @param successes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleOutputItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successes(java.util.Collection<BatchUpdateFirewallRuleOutputItem>)
         */
        Builder successes(Consumer<BatchUpdateFirewallRuleOutputItem.Builder>... successes);
    }

    static final class BuilderImpl extends Route53GlobalResolverResponse.BuilderImpl implements Builder {
        private List<BatchUpdateFirewallRuleOutputItem> failures = DefaultSdkAutoConstructList.getInstance();

        private List<BatchUpdateFirewallRuleOutputItem> successes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateFirewallRuleResponse model) {
            super(model);
            failures(model.failures);
            successes(model.successes);
        }

        public final List<BatchUpdateFirewallRuleOutputItem.Builder> getFailures() {
            List<BatchUpdateFirewallRuleOutputItem.Builder> result = BatchUpdateFirewallRuleOutputItemsCopier
                    .copyToBuilder(this.failures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailures(Collection<BatchUpdateFirewallRuleOutputItem.BuilderImpl> failures) {
            this.failures = BatchUpdateFirewallRuleOutputItemsCopier.copyFromBuilder(failures);
        }

        @Override
        public final Builder failures(Collection<BatchUpdateFirewallRuleOutputItem> failures) {
            this.failures = BatchUpdateFirewallRuleOutputItemsCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(BatchUpdateFirewallRuleOutputItem... failures) {
            failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<BatchUpdateFirewallRuleOutputItem.Builder>... failures) {
            failures(Stream.of(failures).map(c -> BatchUpdateFirewallRuleOutputItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<BatchUpdateFirewallRuleOutputItem.Builder> getSuccesses() {
            List<BatchUpdateFirewallRuleOutputItem.Builder> result = BatchUpdateFirewallRuleOutputItemsCopier
                    .copyToBuilder(this.successes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccesses(Collection<BatchUpdateFirewallRuleOutputItem.BuilderImpl> successes) {
            this.successes = BatchUpdateFirewallRuleOutputItemsCopier.copyFromBuilder(successes);
        }

        @Override
        public final Builder successes(Collection<BatchUpdateFirewallRuleOutputItem> successes) {
            this.successes = BatchUpdateFirewallRuleOutputItemsCopier.copy(successes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successes(BatchUpdateFirewallRuleOutputItem... successes) {
            successes(Arrays.asList(successes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successes(Consumer<BatchUpdateFirewallRuleOutputItem.Builder>... successes) {
            successes(Stream.of(successes).map(c -> BatchUpdateFirewallRuleOutputItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateFirewallRuleResponse build() {
            return new BatchUpdateFirewallRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
