/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateFirewallRuleRequest extends Route53GlobalResolverRequest implements
        ToCopyableBuilder<BatchUpdateFirewallRuleRequest.Builder, BatchUpdateFirewallRuleRequest> {
    private static final SdkField<List<BatchUpdateFirewallRuleInputItem>> FIREWALL_RULES_FIELD = SdkField
            .<List<BatchUpdateFirewallRuleInputItem>> builder(MarshallingType.LIST)
            .memberName("firewallRules")
            .getter(getter(BatchUpdateFirewallRuleRequest::firewallRules))
            .setter(setter(Builder::firewallRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firewallRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BatchUpdateFirewallRuleInputItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(BatchUpdateFirewallRuleInputItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIREWALL_RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<BatchUpdateFirewallRuleInputItem> firewallRules;

    private BatchUpdateFirewallRuleRequest(BuilderImpl builder) {
        super(builder);
        this.firewallRules = builder.firewallRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the FirewallRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFirewallRules() {
        return firewallRules != null && !(firewallRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The DNS Firewall rule IDs to be updated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFirewallRules} method.
     * </p>
     * 
     * @return The DNS Firewall rule IDs to be updated.
     */
    public final List<BatchUpdateFirewallRuleInputItem> firewallRules() {
        return firewallRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFirewallRules() ? firewallRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateFirewallRuleRequest)) {
            return false;
        }
        BatchUpdateFirewallRuleRequest other = (BatchUpdateFirewallRuleRequest) obj;
        return hasFirewallRules() == other.hasFirewallRules() && Objects.equals(firewallRules(), other.firewallRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateFirewallRuleRequest")
                .add("FirewallRules", hasFirewallRules() ? firewallRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "firewallRules":
            return Optional.ofNullable(clazz.cast(firewallRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("firewallRules", FIREWALL_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateFirewallRuleRequest, T> g) {
        return obj -> g.apply((BatchUpdateFirewallRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Route53GlobalResolverRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdateFirewallRuleRequest> {
        /**
         * <p>
         * The DNS Firewall rule IDs to be updated.
         * </p>
         * 
         * @param firewallRules
         *        The DNS Firewall rule IDs to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallRules(Collection<BatchUpdateFirewallRuleInputItem> firewallRules);

        /**
         * <p>
         * The DNS Firewall rule IDs to be updated.
         * </p>
         * 
         * @param firewallRules
         *        The DNS Firewall rule IDs to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallRules(BatchUpdateFirewallRuleInputItem... firewallRules);

        /**
         * <p>
         * The DNS Firewall rule IDs to be updated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleInputItem.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleInputItem#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleInputItem.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #firewallRules(List<BatchUpdateFirewallRuleInputItem>)}.
         * 
         * @param firewallRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleInputItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firewallRules(java.util.Collection<BatchUpdateFirewallRuleInputItem>)
         */
        Builder firewallRules(Consumer<BatchUpdateFirewallRuleInputItem.Builder>... firewallRules);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Route53GlobalResolverRequest.BuilderImpl implements Builder {
        private List<BatchUpdateFirewallRuleInputItem> firewallRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateFirewallRuleRequest model) {
            super(model);
            firewallRules(model.firewallRules);
        }

        public final List<BatchUpdateFirewallRuleInputItem.Builder> getFirewallRules() {
            List<BatchUpdateFirewallRuleInputItem.Builder> result = BatchUpdateFirewallRuleInputItemsCopier
                    .copyToBuilder(this.firewallRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFirewallRules(Collection<BatchUpdateFirewallRuleInputItem.BuilderImpl> firewallRules) {
            this.firewallRules = BatchUpdateFirewallRuleInputItemsCopier.copyFromBuilder(firewallRules);
        }

        @Override
        public final Builder firewallRules(Collection<BatchUpdateFirewallRuleInputItem> firewallRules) {
            this.firewallRules = BatchUpdateFirewallRuleInputItemsCopier.copy(firewallRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallRules(BatchUpdateFirewallRuleInputItem... firewallRules) {
            firewallRules(Arrays.asList(firewallRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder firewallRules(Consumer<BatchUpdateFirewallRuleInputItem.Builder>... firewallRules) {
            firewallRules(Stream.of(firewallRules).map(c -> BatchUpdateFirewallRuleInputItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateFirewallRuleRequest build() {
            return new BatchUpdateFirewallRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
