/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a firewall rule that was deleted in a batch operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteFirewallRuleResult implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDeleteFirewallRuleResult.Builder, BatchDeleteFirewallRuleResult> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(BatchDeleteFirewallRuleResult::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(BatchDeleteFirewallRuleResult::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(BatchDeleteFirewallRuleResult::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(BatchDeleteFirewallRuleResult::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, ID_FIELD,
            NAME_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clientToken;

    private final String id;

    private final String name;

    private final String status;

    private BatchDeleteFirewallRuleResult(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
    }

    /**
     * <p>
     * The unique string that identified the request and ensured idempotency.
     * </p>
     * 
     * @return The unique string that identified the request and ensured idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The unique identifier of the deleted firewall rule.
     * </p>
     * 
     * @return The unique identifier of the deleted firewall rule.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the deleted firewall rule.
     * </p>
     * 
     * @return The name of the deleted firewall rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The final status of the deleted firewall rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CRResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The final status of the deleted firewall rule.
     * @see CRResourceStatus
     */
    public final CRResourceStatus status() {
        return CRResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The final status of the deleted firewall rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CRResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The final status of the deleted firewall rule.
     * @see CRResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteFirewallRuleResult)) {
            return false;
        }
        BatchDeleteFirewallRuleResult other = (BatchDeleteFirewallRuleResult) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteFirewallRuleResult").add("ClientToken", clientToken()).add("Id", id())
                .add("Name", name()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteFirewallRuleResult, T> g) {
        return obj -> g.apply((BatchDeleteFirewallRuleResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDeleteFirewallRuleResult> {
        /**
         * <p>
         * The unique string that identified the request and ensured idempotency.
         * </p>
         * 
         * @param clientToken
         *        The unique string that identified the request and ensured idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The unique identifier of the deleted firewall rule.
         * </p>
         * 
         * @param id
         *        The unique identifier of the deleted firewall rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the deleted firewall rule.
         * </p>
         * 
         * @param name
         *        The name of the deleted firewall rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The final status of the deleted firewall rule.
         * </p>
         * 
         * @param status
         *        The final status of the deleted firewall rule.
         * @see CRResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CRResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The final status of the deleted firewall rule.
         * </p>
         * 
         * @param status
         *        The final status of the deleted firewall rule.
         * @see CRResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CRResourceStatus
         */
        Builder status(CRResourceStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String clientToken;

        private String id;

        private String name;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteFirewallRuleResult model) {
            clientToken(model.clientToken);
            id(model.id);
            name(model.name);
            status(model.status);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CRResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public BatchDeleteFirewallRuleResult build() {
            return new BatchDeleteFirewallRuleResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
