/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a DNS Firewall rule to create in a batch operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchCreateFirewallRuleInputItem implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchCreateFirewallRuleInputItem.Builder, BatchCreateFirewallRuleInputItem> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(BatchCreateFirewallRuleInputItem::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> BLOCK_OVERRIDE_DNS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blockOverrideDnsType").getter(getter(BatchCreateFirewallRuleInputItem::blockOverrideDnsTypeAsString))
            .setter(setter(Builder::blockOverrideDnsType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockOverrideDnsType").build())
            .build();

    private static final SdkField<String> BLOCK_OVERRIDE_DOMAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blockOverrideDomain").getter(getter(BatchCreateFirewallRuleInputItem::blockOverrideDomain))
            .setter(setter(Builder::blockOverrideDomain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockOverrideDomain").build())
            .build();

    private static final SdkField<Integer> BLOCK_OVERRIDE_TTL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("blockOverrideTtl").getter(getter(BatchCreateFirewallRuleInputItem::blockOverrideTtl))
            .setter(setter(Builder::blockOverrideTtl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockOverrideTtl").build()).build();

    private static final SdkField<String> BLOCK_RESPONSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blockResponse").getter(getter(BatchCreateFirewallRuleInputItem::blockResponseAsString))
            .setter(setter(Builder::blockResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockResponse").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientToken").getter(getter(BatchCreateFirewallRuleInputItem::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()).build();

    private static final SdkField<String> CONFIDENCE_THRESHOLD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("confidenceThreshold").getter(getter(BatchCreateFirewallRuleInputItem::confidenceThresholdAsString))
            .setter(setter(Builder::confidenceThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidenceThreshold").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(BatchCreateFirewallRuleInputItem::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DNS_ADVANCED_PROTECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dnsAdvancedProtection").getter(getter(BatchCreateFirewallRuleInputItem::dnsAdvancedProtectionAsString))
            .setter(setter(Builder::dnsAdvancedProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsAdvancedProtection").build())
            .build();

    private static final SdkField<String> FIREWALL_DOMAIN_LIST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("firewallDomainListId").getter(getter(BatchCreateFirewallRuleInputItem::firewallDomainListId))
            .setter(setter(Builder::firewallDomainListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firewallDomainListId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(BatchCreateFirewallRuleInputItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Long> PRIORITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("priority")
            .getter(getter(BatchCreateFirewallRuleInputItem::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<String> DNS_VIEW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dnsViewId").getter(getter(BatchCreateFirewallRuleInputItem::dnsViewId))
            .setter(setter(Builder::dnsViewId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsViewId").build()).build();

    private static final SdkField<String> Q_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("qType")
            .getter(getter(BatchCreateFirewallRuleInputItem::qType)).setter(setter(Builder::qType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            BLOCK_OVERRIDE_DNS_TYPE_FIELD, BLOCK_OVERRIDE_DOMAIN_FIELD, BLOCK_OVERRIDE_TTL_FIELD, BLOCK_RESPONSE_FIELD,
            CLIENT_TOKEN_FIELD, CONFIDENCE_THRESHOLD_FIELD, DESCRIPTION_FIELD, DNS_ADVANCED_PROTECTION_FIELD,
            FIREWALL_DOMAIN_LIST_ID_FIELD, NAME_FIELD, PRIORITY_FIELD, DNS_VIEW_ID_FIELD, Q_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String blockOverrideDnsType;

    private final String blockOverrideDomain;

    private final Integer blockOverrideTtl;

    private final String blockResponse;

    private final String clientToken;

    private final String confidenceThreshold;

    private final String description;

    private final String dnsAdvancedProtection;

    private final String firewallDomainListId;

    private final String name;

    private final Long priority;

    private final String dnsViewId;

    private final String qType;

    private BatchCreateFirewallRuleInputItem(BuilderImpl builder) {
        this.action = builder.action;
        this.blockOverrideDnsType = builder.blockOverrideDnsType;
        this.blockOverrideDomain = builder.blockOverrideDomain;
        this.blockOverrideTtl = builder.blockOverrideTtl;
        this.blockResponse = builder.blockResponse;
        this.clientToken = builder.clientToken;
        this.confidenceThreshold = builder.confidenceThreshold;
        this.description = builder.description;
        this.dnsAdvancedProtection = builder.dnsAdvancedProtection;
        this.firewallDomainListId = builder.firewallDomainListId;
        this.name = builder.name;
        this.priority = builder.priority;
        this.dnsViewId = builder.dnsViewId;
        this.qType = builder.qType;
    }

    /**
     * <p>
     * The action to take when a DNS query matches the firewall rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link FirewallRuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to take when a DNS query matches the firewall rule.
     * @see FirewallRuleAction
     */
    public final FirewallRuleAction action() {
        return FirewallRuleAction.fromValue(action);
    }

    /**
     * <p>
     * The action to take when a DNS query matches the firewall rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link FirewallRuleAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to take when a DNS query matches the firewall rule.
     * @see FirewallRuleAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The DNS record type for the custom response when the action is BLOCK.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #blockOverrideDnsType} will return {@link BlockOverrideDnsQueryType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #blockOverrideDnsTypeAsString}.
     * </p>
     * 
     * @return The DNS record type for the custom response when the action is BLOCK.
     * @see BlockOverrideDnsQueryType
     */
    public final BlockOverrideDnsQueryType blockOverrideDnsType() {
        return BlockOverrideDnsQueryType.fromValue(blockOverrideDnsType);
    }

    /**
     * <p>
     * The DNS record type for the custom response when the action is BLOCK.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #blockOverrideDnsType} will return {@link BlockOverrideDnsQueryType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #blockOverrideDnsTypeAsString}.
     * </p>
     * 
     * @return The DNS record type for the custom response when the action is BLOCK.
     * @see BlockOverrideDnsQueryType
     */
    public final String blockOverrideDnsTypeAsString() {
        return blockOverrideDnsType;
    }

    /**
     * <p>
     * The custom domain name for the BLOCK response.
     * </p>
     * 
     * @return The custom domain name for the BLOCK response.
     */
    public final String blockOverrideDomain() {
        return blockOverrideDomain;
    }

    /**
     * <p>
     * The TTL value for the custom response when the action is BLOCK.
     * </p>
     * 
     * @return The TTL value for the custom response when the action is BLOCK.
     */
    public final Integer blockOverrideTtl() {
        return blockOverrideTtl;
    }

    /**
     * <p>
     * The type of block response to return when the action is BLOCK.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blockResponse}
     * will return {@link FirewallBlockResponse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #blockResponseAsString}.
     * </p>
     * 
     * @return The type of block response to return when the action is BLOCK.
     * @see FirewallBlockResponse
     */
    public final FirewallBlockResponse blockResponse() {
        return FirewallBlockResponse.fromValue(blockResponse);
    }

    /**
     * <p>
     * The type of block response to return when the action is BLOCK.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blockResponse}
     * will return {@link FirewallBlockResponse#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #blockResponseAsString}.
     * </p>
     * 
     * @return The type of block response to return when the action is BLOCK.
     * @see FirewallBlockResponse
     */
    public final String blockResponseAsString() {
        return blockResponse;
    }

    /**
     * <p>
     * A unique string that identifies the request and ensures idempotency.
     * </p>
     * 
     * @return A unique string that identifies the request and ensures idempotency.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The confidence threshold for advanced threat detection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #confidenceThreshold} will return {@link ConfidenceThreshold#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #confidenceThresholdAsString}.
     * </p>
     * 
     * @return The confidence threshold for advanced threat detection.
     * @see ConfidenceThreshold
     */
    public final ConfidenceThreshold confidenceThreshold() {
        return ConfidenceThreshold.fromValue(confidenceThreshold);
    }

    /**
     * <p>
     * The confidence threshold for advanced threat detection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #confidenceThreshold} will return {@link ConfidenceThreshold#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #confidenceThresholdAsString}.
     * </p>
     * 
     * @return The confidence threshold for advanced threat detection.
     * @see ConfidenceThreshold
     */
    public final String confidenceThresholdAsString() {
        return confidenceThreshold;
    }

    /**
     * <p>
     * A description of the firewall rule.
     * </p>
     * 
     * @return A description of the firewall rule.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Whether to enable advanced DNS threat protection for the firewall rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dnsAdvancedProtection} will return {@link DnsAdvancedProtection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dnsAdvancedProtectionAsString}.
     * </p>
     * 
     * @return Whether to enable advanced DNS threat protection for the firewall rule.
     * @see DnsAdvancedProtection
     */
    public final DnsAdvancedProtection dnsAdvancedProtection() {
        return DnsAdvancedProtection.fromValue(dnsAdvancedProtection);
    }

    /**
     * <p>
     * Whether to enable advanced DNS threat protection for the firewall rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dnsAdvancedProtection} will return {@link DnsAdvancedProtection#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dnsAdvancedProtectionAsString}.
     * </p>
     * 
     * @return Whether to enable advanced DNS threat protection for the firewall rule.
     * @see DnsAdvancedProtection
     */
    public final String dnsAdvancedProtectionAsString() {
        return dnsAdvancedProtection;
    }

    /**
     * <p>
     * The ID of the firewall domain list to associate with the rule.
     * </p>
     * 
     * @return The ID of the firewall domain list to associate with the rule.
     */
    public final String firewallDomainListId() {
        return firewallDomainListId;
    }

    /**
     * <p>
     * A name for the firewall rule.
     * </p>
     * 
     * @return A name for the firewall rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The priority of the firewall rule.
     * </p>
     * 
     * @return The priority of the firewall rule.
     */
    public final Long priority() {
        return priority;
    }

    /**
     * <p>
     * The ID of the DNS view to associate the firewall rule with.
     * </p>
     * 
     * @return The ID of the DNS view to associate the firewall rule with.
     */
    public final String dnsViewId() {
        return dnsViewId;
    }

    /**
     * <p>
     * The DNS query type that the firewall rule should match.
     * </p>
     * 
     * @return The DNS query type that the firewall rule should match.
     */
    public final String qType() {
        return qType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blockOverrideDnsTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blockOverrideDomain());
        hashCode = 31 * hashCode + Objects.hashCode(blockOverrideTtl());
        hashCode = 31 * hashCode + Objects.hashCode(blockResponseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(confidenceThresholdAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dnsAdvancedProtectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(firewallDomainListId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(dnsViewId());
        hashCode = 31 * hashCode + Objects.hashCode(qType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateFirewallRuleInputItem)) {
            return false;
        }
        BatchCreateFirewallRuleInputItem other = (BatchCreateFirewallRuleInputItem) obj;
        return Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(blockOverrideDnsTypeAsString(), other.blockOverrideDnsTypeAsString())
                && Objects.equals(blockOverrideDomain(), other.blockOverrideDomain())
                && Objects.equals(blockOverrideTtl(), other.blockOverrideTtl())
                && Objects.equals(blockResponseAsString(), other.blockResponseAsString())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(confidenceThresholdAsString(), other.confidenceThresholdAsString())
                && Objects.equals(description(), other.description())
                && Objects.equals(dnsAdvancedProtectionAsString(), other.dnsAdvancedProtectionAsString())
                && Objects.equals(firewallDomainListId(), other.firewallDomainListId()) && Objects.equals(name(), other.name())
                && Objects.equals(priority(), other.priority()) && Objects.equals(dnsViewId(), other.dnsViewId())
                && Objects.equals(qType(), other.qType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchCreateFirewallRuleInputItem").add("Action", actionAsString())
                .add("BlockOverrideDnsType", blockOverrideDnsTypeAsString()).add("BlockOverrideDomain", blockOverrideDomain())
                .add("BlockOverrideTtl", blockOverrideTtl()).add("BlockResponse", blockResponseAsString())
                .add("ClientToken", clientToken()).add("ConfidenceThreshold", confidenceThresholdAsString())
                .add("Description", description()).add("DnsAdvancedProtection", dnsAdvancedProtectionAsString())
                .add("FirewallDomainListId", firewallDomainListId()).add("Name", name()).add("Priority", priority())
                .add("DnsViewId", dnsViewId()).add("QType", qType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "blockOverrideDnsType":
            return Optional.ofNullable(clazz.cast(blockOverrideDnsTypeAsString()));
        case "blockOverrideDomain":
            return Optional.ofNullable(clazz.cast(blockOverrideDomain()));
        case "blockOverrideTtl":
            return Optional.ofNullable(clazz.cast(blockOverrideTtl()));
        case "blockResponse":
            return Optional.ofNullable(clazz.cast(blockResponseAsString()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "confidenceThreshold":
            return Optional.ofNullable(clazz.cast(confidenceThresholdAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "dnsAdvancedProtection":
            return Optional.ofNullable(clazz.cast(dnsAdvancedProtectionAsString()));
        case "firewallDomainListId":
            return Optional.ofNullable(clazz.cast(firewallDomainListId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "dnsViewId":
            return Optional.ofNullable(clazz.cast(dnsViewId()));
        case "qType":
            return Optional.ofNullable(clazz.cast(qType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("action", ACTION_FIELD);
        map.put("blockOverrideDnsType", BLOCK_OVERRIDE_DNS_TYPE_FIELD);
        map.put("blockOverrideDomain", BLOCK_OVERRIDE_DOMAIN_FIELD);
        map.put("blockOverrideTtl", BLOCK_OVERRIDE_TTL_FIELD);
        map.put("blockResponse", BLOCK_RESPONSE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("confidenceThreshold", CONFIDENCE_THRESHOLD_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("dnsAdvancedProtection", DNS_ADVANCED_PROTECTION_FIELD);
        map.put("firewallDomainListId", FIREWALL_DOMAIN_LIST_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("priority", PRIORITY_FIELD);
        map.put("dnsViewId", DNS_VIEW_ID_FIELD);
        map.put("qType", Q_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateFirewallRuleInputItem, T> g) {
        return obj -> g.apply((BatchCreateFirewallRuleInputItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchCreateFirewallRuleInputItem> {
        /**
         * <p>
         * The action to take when a DNS query matches the firewall rule.
         * </p>
         * 
         * @param action
         *        The action to take when a DNS query matches the firewall rule.
         * @see FirewallRuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallRuleAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action to take when a DNS query matches the firewall rule.
         * </p>
         * 
         * @param action
         *        The action to take when a DNS query matches the firewall rule.
         * @see FirewallRuleAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallRuleAction
         */
        Builder action(FirewallRuleAction action);

        /**
         * <p>
         * The DNS record type for the custom response when the action is BLOCK.
         * </p>
         * 
         * @param blockOverrideDnsType
         *        The DNS record type for the custom response when the action is BLOCK.
         * @see BlockOverrideDnsQueryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlockOverrideDnsQueryType
         */
        Builder blockOverrideDnsType(String blockOverrideDnsType);

        /**
         * <p>
         * The DNS record type for the custom response when the action is BLOCK.
         * </p>
         * 
         * @param blockOverrideDnsType
         *        The DNS record type for the custom response when the action is BLOCK.
         * @see BlockOverrideDnsQueryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlockOverrideDnsQueryType
         */
        Builder blockOverrideDnsType(BlockOverrideDnsQueryType blockOverrideDnsType);

        /**
         * <p>
         * The custom domain name for the BLOCK response.
         * </p>
         * 
         * @param blockOverrideDomain
         *        The custom domain name for the BLOCK response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockOverrideDomain(String blockOverrideDomain);

        /**
         * <p>
         * The TTL value for the custom response when the action is BLOCK.
         * </p>
         * 
         * @param blockOverrideTtl
         *        The TTL value for the custom response when the action is BLOCK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockOverrideTtl(Integer blockOverrideTtl);

        /**
         * <p>
         * The type of block response to return when the action is BLOCK.
         * </p>
         * 
         * @param blockResponse
         *        The type of block response to return when the action is BLOCK.
         * @see FirewallBlockResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallBlockResponse
         */
        Builder blockResponse(String blockResponse);

        /**
         * <p>
         * The type of block response to return when the action is BLOCK.
         * </p>
         * 
         * @param blockResponse
         *        The type of block response to return when the action is BLOCK.
         * @see FirewallBlockResponse
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirewallBlockResponse
         */
        Builder blockResponse(FirewallBlockResponse blockResponse);

        /**
         * <p>
         * A unique string that identifies the request and ensures idempotency.
         * </p>
         * 
         * @param clientToken
         *        A unique string that identifies the request and ensures idempotency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The confidence threshold for advanced threat detection.
         * </p>
         * 
         * @param confidenceThreshold
         *        The confidence threshold for advanced threat detection.
         * @see ConfidenceThreshold
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfidenceThreshold
         */
        Builder confidenceThreshold(String confidenceThreshold);

        /**
         * <p>
         * The confidence threshold for advanced threat detection.
         * </p>
         * 
         * @param confidenceThreshold
         *        The confidence threshold for advanced threat detection.
         * @see ConfidenceThreshold
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfidenceThreshold
         */
        Builder confidenceThreshold(ConfidenceThreshold confidenceThreshold);

        /**
         * <p>
         * A description of the firewall rule.
         * </p>
         * 
         * @param description
         *        A description of the firewall rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Whether to enable advanced DNS threat protection for the firewall rule.
         * </p>
         * 
         * @param dnsAdvancedProtection
         *        Whether to enable advanced DNS threat protection for the firewall rule.
         * @see DnsAdvancedProtection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsAdvancedProtection
         */
        Builder dnsAdvancedProtection(String dnsAdvancedProtection);

        /**
         * <p>
         * Whether to enable advanced DNS threat protection for the firewall rule.
         * </p>
         * 
         * @param dnsAdvancedProtection
         *        Whether to enable advanced DNS threat protection for the firewall rule.
         * @see DnsAdvancedProtection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DnsAdvancedProtection
         */
        Builder dnsAdvancedProtection(DnsAdvancedProtection dnsAdvancedProtection);

        /**
         * <p>
         * The ID of the firewall domain list to associate with the rule.
         * </p>
         * 
         * @param firewallDomainListId
         *        The ID of the firewall domain list to associate with the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firewallDomainListId(String firewallDomainListId);

        /**
         * <p>
         * A name for the firewall rule.
         * </p>
         * 
         * @param name
         *        A name for the firewall rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The priority of the firewall rule.
         * </p>
         * 
         * @param priority
         *        The priority of the firewall rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Long priority);

        /**
         * <p>
         * The ID of the DNS view to associate the firewall rule with.
         * </p>
         * 
         * @param dnsViewId
         *        The ID of the DNS view to associate the firewall rule with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsViewId(String dnsViewId);

        /**
         * <p>
         * The DNS query type that the firewall rule should match.
         * </p>
         * 
         * @param qType
         *        The DNS query type that the firewall rule should match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qType(String qType);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String blockOverrideDnsType;

        private String blockOverrideDomain;

        private Integer blockOverrideTtl;

        private String blockResponse;

        private String clientToken;

        private String confidenceThreshold;

        private String description;

        private String dnsAdvancedProtection;

        private String firewallDomainListId;

        private String name;

        private Long priority;

        private String dnsViewId;

        private String qType;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateFirewallRuleInputItem model) {
            action(model.action);
            blockOverrideDnsType(model.blockOverrideDnsType);
            blockOverrideDomain(model.blockOverrideDomain);
            blockOverrideTtl(model.blockOverrideTtl);
            blockResponse(model.blockResponse);
            clientToken(model.clientToken);
            confidenceThreshold(model.confidenceThreshold);
            description(model.description);
            dnsAdvancedProtection(model.dnsAdvancedProtection);
            firewallDomainListId(model.firewallDomainListId);
            name(model.name);
            priority(model.priority);
            dnsViewId(model.dnsViewId);
            qType(model.qType);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(FirewallRuleAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getBlockOverrideDnsType() {
            return blockOverrideDnsType;
        }

        public final void setBlockOverrideDnsType(String blockOverrideDnsType) {
            this.blockOverrideDnsType = blockOverrideDnsType;
        }

        @Override
        public final Builder blockOverrideDnsType(String blockOverrideDnsType) {
            this.blockOverrideDnsType = blockOverrideDnsType;
            return this;
        }

        @Override
        public final Builder blockOverrideDnsType(BlockOverrideDnsQueryType blockOverrideDnsType) {
            this.blockOverrideDnsType(blockOverrideDnsType == null ? null : blockOverrideDnsType.toString());
            return this;
        }

        public final String getBlockOverrideDomain() {
            return blockOverrideDomain;
        }

        public final void setBlockOverrideDomain(String blockOverrideDomain) {
            this.blockOverrideDomain = blockOverrideDomain;
        }

        @Override
        public final Builder blockOverrideDomain(String blockOverrideDomain) {
            this.blockOverrideDomain = blockOverrideDomain;
            return this;
        }

        public final Integer getBlockOverrideTtl() {
            return blockOverrideTtl;
        }

        public final void setBlockOverrideTtl(Integer blockOverrideTtl) {
            this.blockOverrideTtl = blockOverrideTtl;
        }

        @Override
        public final Builder blockOverrideTtl(Integer blockOverrideTtl) {
            this.blockOverrideTtl = blockOverrideTtl;
            return this;
        }

        public final String getBlockResponse() {
            return blockResponse;
        }

        public final void setBlockResponse(String blockResponse) {
            this.blockResponse = blockResponse;
        }

        @Override
        public final Builder blockResponse(String blockResponse) {
            this.blockResponse = blockResponse;
            return this;
        }

        @Override
        public final Builder blockResponse(FirewallBlockResponse blockResponse) {
            this.blockResponse(blockResponse == null ? null : blockResponse.toString());
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getConfidenceThreshold() {
            return confidenceThreshold;
        }

        public final void setConfidenceThreshold(String confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
        }

        @Override
        public final Builder confidenceThreshold(String confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
            return this;
        }

        @Override
        public final Builder confidenceThreshold(ConfidenceThreshold confidenceThreshold) {
            this.confidenceThreshold(confidenceThreshold == null ? null : confidenceThreshold.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDnsAdvancedProtection() {
            return dnsAdvancedProtection;
        }

        public final void setDnsAdvancedProtection(String dnsAdvancedProtection) {
            this.dnsAdvancedProtection = dnsAdvancedProtection;
        }

        @Override
        public final Builder dnsAdvancedProtection(String dnsAdvancedProtection) {
            this.dnsAdvancedProtection = dnsAdvancedProtection;
            return this;
        }

        @Override
        public final Builder dnsAdvancedProtection(DnsAdvancedProtection dnsAdvancedProtection) {
            this.dnsAdvancedProtection(dnsAdvancedProtection == null ? null : dnsAdvancedProtection.toString());
            return this;
        }

        public final String getFirewallDomainListId() {
            return firewallDomainListId;
        }

        public final void setFirewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
        }

        @Override
        public final Builder firewallDomainListId(String firewallDomainListId) {
            this.firewallDomainListId = firewallDomainListId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Long getPriority() {
            return priority;
        }

        public final void setPriority(Long priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Long priority) {
            this.priority = priority;
            return this;
        }

        public final String getDnsViewId() {
            return dnsViewId;
        }

        public final void setDnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
        }

        @Override
        public final Builder dnsViewId(String dnsViewId) {
            this.dnsViewId = dnsViewId;
            return this;
        }

        public final String getQType() {
            return qType;
        }

        public final void setQType(String qType) {
            this.qType = qType;
        }

        @Override
        public final Builder qType(String qType) {
            this.qType = qType;
            return this;
        }

        @Override
        public BatchCreateFirewallRuleInputItem build() {
            return new BatchCreateFirewallRuleInputItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
