/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53globalresolver;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.route53globalresolver.model.AccessDeniedException;
import software.amazon.awssdk.services.route53globalresolver.model.AssociateHostedZoneRequest;
import software.amazon.awssdk.services.route53globalresolver.model.AssociateHostedZoneResponse;
import software.amazon.awssdk.services.route53globalresolver.model.BatchCreateFirewallRuleRequest;
import software.amazon.awssdk.services.route53globalresolver.model.BatchCreateFirewallRuleResponse;
import software.amazon.awssdk.services.route53globalresolver.model.BatchDeleteFirewallRuleRequest;
import software.amazon.awssdk.services.route53globalresolver.model.BatchDeleteFirewallRuleResponse;
import software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleRequest;
import software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ConflictException;
import software.amazon.awssdk.services.route53globalresolver.model.CreateAccessSourceRequest;
import software.amazon.awssdk.services.route53globalresolver.model.CreateAccessSourceResponse;
import software.amazon.awssdk.services.route53globalresolver.model.CreateAccessTokenRequest;
import software.amazon.awssdk.services.route53globalresolver.model.CreateAccessTokenResponse;
import software.amazon.awssdk.services.route53globalresolver.model.CreateDnsViewRequest;
import software.amazon.awssdk.services.route53globalresolver.model.CreateDnsViewResponse;
import software.amazon.awssdk.services.route53globalresolver.model.CreateFirewallDomainListRequest;
import software.amazon.awssdk.services.route53globalresolver.model.CreateFirewallDomainListResponse;
import software.amazon.awssdk.services.route53globalresolver.model.CreateFirewallRuleRequest;
import software.amazon.awssdk.services.route53globalresolver.model.CreateFirewallRuleResponse;
import software.amazon.awssdk.services.route53globalresolver.model.CreateGlobalResolverRequest;
import software.amazon.awssdk.services.route53globalresolver.model.CreateGlobalResolverResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteAccessSourceRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteAccessSourceResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteAccessTokenRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteAccessTokenResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteDnsViewRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteDnsViewResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteFirewallDomainListRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteFirewallDomainListResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteFirewallRuleRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteFirewallRuleResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteGlobalResolverRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DeleteGlobalResolverResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DisableDnsViewRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DisableDnsViewResponse;
import software.amazon.awssdk.services.route53globalresolver.model.DisassociateHostedZoneRequest;
import software.amazon.awssdk.services.route53globalresolver.model.DisassociateHostedZoneResponse;
import software.amazon.awssdk.services.route53globalresolver.model.EnableDnsViewRequest;
import software.amazon.awssdk.services.route53globalresolver.model.EnableDnsViewResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetAccessSourceRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetAccessSourceResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetAccessTokenRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetAccessTokenResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetDnsViewRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetDnsViewResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetFirewallDomainListRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetFirewallDomainListResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetFirewallRuleRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetFirewallRuleResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetGlobalResolverRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetGlobalResolverResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetHostedZoneAssociationRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetHostedZoneAssociationResponse;
import software.amazon.awssdk.services.route53globalresolver.model.GetManagedFirewallDomainListRequest;
import software.amazon.awssdk.services.route53globalresolver.model.GetManagedFirewallDomainListResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ImportFirewallDomainsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ImportFirewallDomainsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.InternalServerException;
import software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.route53globalresolver.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ResourceNotFoundException;
import software.amazon.awssdk.services.route53globalresolver.model.Route53GlobalResolverException;
import software.amazon.awssdk.services.route53globalresolver.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.route53globalresolver.model.TagResourceRequest;
import software.amazon.awssdk.services.route53globalresolver.model.TagResourceResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ThrottlingException;
import software.amazon.awssdk.services.route53globalresolver.model.UntagResourceRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UntagResourceResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateAccessSourceRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateAccessSourceResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateAccessTokenRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateAccessTokenResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateDnsViewRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateDnsViewResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateFirewallDomainsRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateFirewallDomainsResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateFirewallRuleRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateFirewallRuleResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateGlobalResolverRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateGlobalResolverResponse;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateHostedZoneAssociationRequest;
import software.amazon.awssdk.services.route53globalresolver.model.UpdateHostedZoneAssociationResponse;
import software.amazon.awssdk.services.route53globalresolver.model.ValidationException;
import software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessSourcesIterable;
import software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessTokensIterable;
import software.amazon.awssdk.services.route53globalresolver.paginators.ListDNSViewsIterable;
import software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainListsIterable;
import software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainsIterable;
import software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallRulesIterable;
import software.amazon.awssdk.services.route53globalresolver.paginators.ListGlobalResolversIterable;
import software.amazon.awssdk.services.route53globalresolver.paginators.ListHostedZoneAssociationsIterable;
import software.amazon.awssdk.services.route53globalresolver.paginators.ListManagedFirewallDomainListsIterable;

/**
 * Service client for accessing Amazon Route 53 Global Resolver. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon Route 53 Global Resolver is a global, internet-accessible DNS resolver that enables customers to resolve and
 * forward traffic for both public and private domains while ensuring security and authenticity of queries over the
 * internet. Route 53 Global Resolver supports DNS-over-port 53 (Do53), DNS-over-TLS (DoT), and DNS-over-HTTPS (DoH)
 * protocols through global anycast IP addresses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Route53GlobalResolverClient extends AwsClient {
    String SERVICE_NAME = "route53globalresolver";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "route53globalresolver";

    /**
     * <p>
     * Associates a Route 53 private hosted zone with a Route 53 Global Resolver resource. This allows the resolver to
     * resolve DNS queries for the private hosted zone from anywhere globally.
     * </p>
     *
     * @param associateHostedZoneRequest
     * @return Result of the AssociateHostedZone operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.AssociateHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/AssociateHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateHostedZoneResponse associateHostedZone(AssociateHostedZoneRequest associateHostedZoneRequest)
            throws InternalServerException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a Route 53 private hosted zone with a Route 53 Global Resolver resource. This allows the resolver to
     * resolve DNS queries for the private hosted zone from anywhere globally.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateHostedZoneRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateHostedZoneRequest#builder()}
     * </p>
     *
     * @param associateHostedZoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.AssociateHostedZoneRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateHostedZone operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.AssociateHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/AssociateHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateHostedZoneResponse associateHostedZone(
            Consumer<AssociateHostedZoneRequest.Builder> associateHostedZoneRequest) throws InternalServerException,
            ValidationException, ConflictException, ServiceQuotaExceededException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return associateHostedZone(AssociateHostedZoneRequest.builder().applyMutation(associateHostedZoneRequest).build());
    }

    /**
     * <p>
     * Creates multiple DNS firewall rules in a single operation. This is more efficient than creating rules
     * individually when you need to set up multiple rules at once.
     * </p>
     *
     * @param batchCreateFirewallRuleRequest
     * @return Result of the BatchCreateFirewallRule operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.BatchCreateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/BatchCreateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchCreateFirewallRuleResponse batchCreateFirewallRule(BatchCreateFirewallRuleRequest batchCreateFirewallRuleRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates multiple DNS firewall rules in a single operation. This is more efficient than creating rules
     * individually when you need to set up multiple rules at once.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreateFirewallRuleRequest.Builder} avoiding
     * the need to create one manually via {@link BatchCreateFirewallRuleRequest#builder()}
     * </p>
     *
     * @param batchCreateFirewallRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.BatchCreateFirewallRuleRequest.Builder}
     *        to create a request.
     * @return Result of the BatchCreateFirewallRule operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.BatchCreateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/BatchCreateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchCreateFirewallRuleResponse batchCreateFirewallRule(
            Consumer<BatchCreateFirewallRuleRequest.Builder> batchCreateFirewallRuleRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        return batchCreateFirewallRule(BatchCreateFirewallRuleRequest.builder().applyMutation(batchCreateFirewallRuleRequest)
                .build());
    }

    /**
     * <p>
     * Deletes multiple DNS firewall rules in a single operation. This is more efficient than deleting rules
     * individually.
     * </p>
     *
     * @param batchDeleteFirewallRuleRequest
     * @return Result of the BatchDeleteFirewallRule operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.BatchDeleteFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/BatchDeleteFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteFirewallRuleResponse batchDeleteFirewallRule(BatchDeleteFirewallRuleRequest batchDeleteFirewallRuleRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes multiple DNS firewall rules in a single operation. This is more efficient than deleting rules
     * individually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteFirewallRuleRequest.Builder} avoiding
     * the need to create one manually via {@link BatchDeleteFirewallRuleRequest#builder()}
     * </p>
     *
     * @param batchDeleteFirewallRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.BatchDeleteFirewallRuleRequest.Builder}
     *        to create a request.
     * @return Result of the BatchDeleteFirewallRule operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.BatchDeleteFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/BatchDeleteFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteFirewallRuleResponse batchDeleteFirewallRule(
            Consumer<BatchDeleteFirewallRuleRequest.Builder> batchDeleteFirewallRuleRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        return batchDeleteFirewallRule(BatchDeleteFirewallRuleRequest.builder().applyMutation(batchDeleteFirewallRuleRequest)
                .build());
    }

    /**
     * <p>
     * Updates multiple DNS firewall rules in a single operation. This is more efficient than updating rules
     * individually.
     * </p>
     *
     * @param batchUpdateFirewallRuleRequest
     * @return Result of the BatchUpdateFirewallRule operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.BatchUpdateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/BatchUpdateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateFirewallRuleResponse batchUpdateFirewallRule(BatchUpdateFirewallRuleRequest batchUpdateFirewallRuleRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates multiple DNS firewall rules in a single operation. This is more efficient than updating rules
     * individually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateFirewallRuleRequest.Builder} avoiding
     * the need to create one manually via {@link BatchUpdateFirewallRuleRequest#builder()}
     * </p>
     *
     * @param batchUpdateFirewallRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.BatchUpdateFirewallRuleRequest.Builder}
     *        to create a request.
     * @return Result of the BatchUpdateFirewallRule operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.BatchUpdateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/BatchUpdateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateFirewallRuleResponse batchUpdateFirewallRule(
            Consumer<BatchUpdateFirewallRuleRequest.Builder> batchUpdateFirewallRuleRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        return batchUpdateFirewallRule(BatchUpdateFirewallRuleRequest.builder().applyMutation(batchUpdateFirewallRuleRequest)
                .build());
    }

    /**
     * <p>
     * Creates an access source for a DNS view. Access sources define IP addresses or CIDR ranges that are allowed to
     * send DNS queries to the Route 53 Global Resolver, along with the permitted DNS protocols.
     * </p>
     *
     * @param createAccessSourceRequest
     * @return Result of the CreateAccessSource operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.CreateAccessSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateAccessSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccessSourceResponse createAccessSource(CreateAccessSourceRequest createAccessSourceRequest)
            throws InternalServerException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an access source for a DNS view. Access sources define IP addresses or CIDR ranges that are allowed to
     * send DNS queries to the Route 53 Global Resolver, along with the permitted DNS protocols.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccessSourceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAccessSourceRequest#builder()}
     * </p>
     *
     * @param createAccessSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.CreateAccessSourceRequest.Builder} to
     *        create a request.
     * @return Result of the CreateAccessSource operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.CreateAccessSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateAccessSource"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccessSourceResponse createAccessSource(Consumer<CreateAccessSourceRequest.Builder> createAccessSourceRequest)
            throws InternalServerException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        return createAccessSource(CreateAccessSourceRequest.builder().applyMutation(createAccessSourceRequest).build());
    }

    /**
     * <p>
     * Creates an access token for a DNS view. Access tokens provide token-based authentication for DNS-over-HTTPS (DoH)
     * and DNS-over-TLS (DoT) connections to the Route 53 Global Resolver.
     * </p>
     *
     * @param createAccessTokenRequest
     * @return Result of the CreateAccessToken operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.CreateAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccessTokenResponse createAccessToken(CreateAccessTokenRequest createAccessTokenRequest)
            throws InternalServerException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an access token for a DNS view. Access tokens provide token-based authentication for DNS-over-HTTPS (DoH)
     * and DNS-over-TLS (DoT) connections to the Route 53 Global Resolver.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccessTokenRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAccessTokenRequest#builder()}
     * </p>
     *
     * @param createAccessTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.CreateAccessTokenRequest.Builder} to
     *        create a request.
     * @return Result of the CreateAccessToken operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.CreateAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccessTokenResponse createAccessToken(Consumer<CreateAccessTokenRequest.Builder> createAccessTokenRequest)
            throws InternalServerException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        return createAccessToken(CreateAccessTokenRequest.builder().applyMutation(createAccessTokenRequest).build());
    }

    /**
     * <p>
     * Creates a DNS view within a Route 53 Global Resolver. A DNS view models end users, user groups, networks, and
     * devices, and serves as a parent resource that holds configurations controlling access, authorization, DNS
     * firewall rules, and forwarding rules.
     * </p>
     *
     * @param createDnsViewRequest
     * @return Result of the CreateDNSView operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.CreateDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDnsViewResponse createDNSView(CreateDnsViewRequest createDnsViewRequest) throws InternalServerException,
            ValidationException, ConflictException, ServiceQuotaExceededException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a DNS view within a Route 53 Global Resolver. A DNS view models end users, user groups, networks, and
     * devices, and serves as a parent resource that holds configurations controlling access, authorization, DNS
     * firewall rules, and forwarding rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDnsViewRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDnsViewRequest#builder()}
     * </p>
     *
     * @param createDnsViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.CreateDnsViewRequest.Builder} to create
     *        a request.
     * @return Result of the CreateDNSView operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.CreateDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDnsViewResponse createDNSView(Consumer<CreateDnsViewRequest.Builder> createDnsViewRequest)
            throws InternalServerException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        return createDNSView(CreateDnsViewRequest.builder().applyMutation(createDnsViewRequest).build());
    }

    /**
     * <p>
     * Creates a firewall domain list. Domain lists are reusable sets of domain specifications that you use in DNS
     * firewall rules to allow, block, or alert on DNS queries to specific domains.
     * </p>
     *
     * @param createFirewallDomainListRequest
     * @return Result of the CreateFirewallDomainList operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.CreateFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFirewallDomainListResponse createFirewallDomainList(
            CreateFirewallDomainListRequest createFirewallDomainListRequest) throws InternalServerException, ValidationException,
            ConflictException, ServiceQuotaExceededException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a firewall domain list. Domain lists are reusable sets of domain specifications that you use in DNS
     * firewall rules to allow, block, or alert on DNS queries to specific domains.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFirewallDomainListRequest.Builder} avoiding
     * the need to create one manually via {@link CreateFirewallDomainListRequest#builder()}
     * </p>
     *
     * @param createFirewallDomainListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.CreateFirewallDomainListRequest.Builder}
     *        to create a request.
     * @return Result of the CreateFirewallDomainList operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.CreateFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFirewallDomainListResponse createFirewallDomainList(
            Consumer<CreateFirewallDomainListRequest.Builder> createFirewallDomainListRequest) throws InternalServerException,
            ValidationException, ConflictException, ServiceQuotaExceededException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return createFirewallDomainList(CreateFirewallDomainListRequest.builder().applyMutation(createFirewallDomainListRequest)
                .build());
    }

    /**
     * <p>
     * Creates a DNS firewall rule. Firewall rules define actions (ALLOW, BLOCK, or ALERT) to take on DNS queries that
     * match specified domain lists, managed domain lists, or advanced threat protections.
     * </p>
     *
     * @param createFirewallRuleRequest
     * @return Result of the CreateFirewallRule operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.CreateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFirewallRuleResponse createFirewallRule(CreateFirewallRuleRequest createFirewallRuleRequest)
            throws InternalServerException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a DNS firewall rule. Firewall rules define actions (ALLOW, BLOCK, or ALERT) to take on DNS queries that
     * match specified domain lists, managed domain lists, or advanced threat protections.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFirewallRuleRequest.Builder} avoiding the
     * need to create one manually via {@link CreateFirewallRuleRequest#builder()}
     * </p>
     *
     * @param createFirewallRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.CreateFirewallRuleRequest.Builder} to
     *        create a request.
     * @return Result of the CreateFirewallRule operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.CreateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFirewallRuleResponse createFirewallRule(Consumer<CreateFirewallRuleRequest.Builder> createFirewallRuleRequest)
            throws InternalServerException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        return createFirewallRule(CreateFirewallRuleRequest.builder().applyMutation(createFirewallRuleRequest).build());
    }

    /**
     * <p>
     * Creates a new Route 53 Global Resolver instance. A Route 53 Global Resolver is a global, internet-accessible DNS
     * resolver that provides secure DNS resolution for both public and private domains through global anycast IP
     * addresses.
     * </p>
     *
     * @param createGlobalResolverRequest
     * @return Result of the CreateGlobalResolver operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.CreateGlobalResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateGlobalResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGlobalResolverResponse createGlobalResolver(CreateGlobalResolverRequest createGlobalResolverRequest)
            throws InternalServerException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Route 53 Global Resolver instance. A Route 53 Global Resolver is a global, internet-accessible DNS
     * resolver that provides secure DNS resolution for both public and private domains through global anycast IP
     * addresses.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGlobalResolverRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGlobalResolverRequest#builder()}
     * </p>
     *
     * @param createGlobalResolverRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.CreateGlobalResolverRequest.Builder} to
     *        create a request.
     * @return Result of the CreateGlobalResolver operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.CreateGlobalResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/CreateGlobalResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGlobalResolverResponse createGlobalResolver(
            Consumer<CreateGlobalResolverRequest.Builder> createGlobalResolverRequest) throws InternalServerException,
            ValidationException, ConflictException, ServiceQuotaExceededException, AccessDeniedException, ThrottlingException,
            AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return createGlobalResolver(CreateGlobalResolverRequest.builder().applyMutation(createGlobalResolverRequest).build());
    }

    /**
     * <p>
     * Deletes an access source. This operation cannot be undone.
     * </p>
     *
     * @param deleteAccessSourceRequest
     * @return Result of the DeleteAccessSource operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DeleteAccessSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteAccessSource"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccessSourceResponse deleteAccessSource(DeleteAccessSourceRequest deleteAccessSourceRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an access source. This operation cannot be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccessSourceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAccessSourceRequest#builder()}
     * </p>
     *
     * @param deleteAccessSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.DeleteAccessSourceRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteAccessSource operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DeleteAccessSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteAccessSource"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccessSourceResponse deleteAccessSource(Consumer<DeleteAccessSourceRequest.Builder> deleteAccessSourceRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return deleteAccessSource(DeleteAccessSourceRequest.builder().applyMutation(deleteAccessSourceRequest).build());
    }

    /**
     * <p>
     * Deletes an access token. This operation cannot be undone.
     * </p>
     *
     * @param deleteAccessTokenRequest
     * @return Result of the DeleteAccessToken operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DeleteAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccessTokenResponse deleteAccessToken(DeleteAccessTokenRequest deleteAccessTokenRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an access token. This operation cannot be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccessTokenRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAccessTokenRequest#builder()}
     * </p>
     *
     * @param deleteAccessTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.DeleteAccessTokenRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteAccessToken operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DeleteAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccessTokenResponse deleteAccessToken(Consumer<DeleteAccessTokenRequest.Builder> deleteAccessTokenRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return deleteAccessToken(DeleteAccessTokenRequest.builder().applyMutation(deleteAccessTokenRequest).build());
    }

    /**
     * <p>
     * Deletes a DNS view. This operation cannot be undone.
     * </p>
     *
     * @param deleteDnsViewRequest
     * @return Result of the DeleteDNSView operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DeleteDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDnsViewResponse deleteDNSView(DeleteDnsViewRequest deleteDnsViewRequest) throws InternalServerException,
            ValidationException, ConflictException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a DNS view. This operation cannot be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDnsViewRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDnsViewRequest#builder()}
     * </p>
     *
     * @param deleteDnsViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.DeleteDnsViewRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteDNSView operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DeleteDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDnsViewResponse deleteDNSView(Consumer<DeleteDnsViewRequest.Builder> deleteDnsViewRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return deleteDNSView(DeleteDnsViewRequest.builder().applyMutation(deleteDnsViewRequest).build());
    }

    /**
     * <p>
     * Deletes a firewall domain list. This operation cannot be undone.
     * </p>
     *
     * @param deleteFirewallDomainListRequest
     * @return Result of the DeleteFirewallDomainList operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DeleteFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFirewallDomainListResponse deleteFirewallDomainList(
            DeleteFirewallDomainListRequest deleteFirewallDomainListRequest) throws InternalServerException, ValidationException,
            ConflictException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a firewall domain list. This operation cannot be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFirewallDomainListRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteFirewallDomainListRequest#builder()}
     * </p>
     *
     * @param deleteFirewallDomainListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.DeleteFirewallDomainListRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteFirewallDomainList operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DeleteFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFirewallDomainListResponse deleteFirewallDomainList(
            Consumer<DeleteFirewallDomainListRequest.Builder> deleteFirewallDomainListRequest) throws InternalServerException,
            ValidationException, ConflictException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return deleteFirewallDomainList(DeleteFirewallDomainListRequest.builder().applyMutation(deleteFirewallDomainListRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a DNS firewall rule. This operation cannot be undone.
     * </p>
     *
     * @param deleteFirewallRuleRequest
     * @return Result of the DeleteFirewallRule operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DeleteFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFirewallRuleResponse deleteFirewallRule(DeleteFirewallRuleRequest deleteFirewallRuleRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a DNS firewall rule. This operation cannot be undone.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFirewallRuleRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteFirewallRuleRequest#builder()}
     * </p>
     *
     * @param deleteFirewallRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.DeleteFirewallRuleRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteFirewallRule operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DeleteFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFirewallRuleResponse deleteFirewallRule(Consumer<DeleteFirewallRuleRequest.Builder> deleteFirewallRuleRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return deleteFirewallRule(DeleteFirewallRuleRequest.builder().applyMutation(deleteFirewallRuleRequest).build());
    }

    /**
     * <p>
     * Deletes a Route 53 Global Resolver instance. This operation cannot be undone. All associated DNS views, access
     * sources, tokens, and firewall rules are also deleted.
     * </p>
     *
     * @param deleteGlobalResolverRequest
     * @return Result of the DeleteGlobalResolver operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DeleteGlobalResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteGlobalResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGlobalResolverResponse deleteGlobalResolver(DeleteGlobalResolverRequest deleteGlobalResolverRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Route 53 Global Resolver instance. This operation cannot be undone. All associated DNS views, access
     * sources, tokens, and firewall rules are also deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGlobalResolverRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGlobalResolverRequest#builder()}
     * </p>
     *
     * @param deleteGlobalResolverRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.DeleteGlobalResolverRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteGlobalResolver operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DeleteGlobalResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DeleteGlobalResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGlobalResolverResponse deleteGlobalResolver(
            Consumer<DeleteGlobalResolverRequest.Builder> deleteGlobalResolverRequest) throws InternalServerException,
            ValidationException, ConflictException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return deleteGlobalResolver(DeleteGlobalResolverRequest.builder().applyMutation(deleteGlobalResolverRequest).build());
    }

    /**
     * <p>
     * Disables a DNS view, preventing it from serving DNS queries.
     * </p>
     *
     * @param disableDnsViewRequest
     * @return Result of the DisableDNSView operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DisableDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DisableDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableDnsViewResponse disableDNSView(DisableDnsViewRequest disableDnsViewRequest) throws InternalServerException,
            ValidationException, ConflictException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables a DNS view, preventing it from serving DNS queries.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableDnsViewRequest.Builder} avoiding the need to
     * create one manually via {@link DisableDnsViewRequest#builder()}
     * </p>
     *
     * @param disableDnsViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.DisableDnsViewRequest.Builder} to
     *        create a request.
     * @return Result of the DisableDNSView operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DisableDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DisableDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableDnsViewResponse disableDNSView(Consumer<DisableDnsViewRequest.Builder> disableDnsViewRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return disableDNSView(DisableDnsViewRequest.builder().applyMutation(disableDnsViewRequest).build());
    }

    /**
     * <p>
     * Disassociates a Route 53 private hosted zone from a Route 53 Global Resolver resource.
     * </p>
     *
     * @param disassociateHostedZoneRequest
     * @return Result of the DisassociateHostedZone operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DisassociateHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DisassociateHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateHostedZoneResponse disassociateHostedZone(DisassociateHostedZoneRequest disassociateHostedZoneRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a Route 53 private hosted zone from a Route 53 Global Resolver resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateHostedZoneRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateHostedZoneRequest#builder()}
     * </p>
     *
     * @param disassociateHostedZoneRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.DisassociateHostedZoneRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateHostedZone operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.DisassociateHostedZone
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/DisassociateHostedZone"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateHostedZoneResponse disassociateHostedZone(
            Consumer<DisassociateHostedZoneRequest.Builder> disassociateHostedZoneRequest) throws InternalServerException,
            ValidationException, ConflictException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return disassociateHostedZone(DisassociateHostedZoneRequest.builder().applyMutation(disassociateHostedZoneRequest)
                .build());
    }

    /**
     * <p>
     * Enables a disabled DNS view, allowing it to serve DNS queries again.
     * </p>
     *
     * @param enableDnsViewRequest
     * @return Result of the EnableDNSView operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.EnableDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/EnableDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableDnsViewResponse enableDNSView(EnableDnsViewRequest enableDnsViewRequest) throws InternalServerException,
            ValidationException, ConflictException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables a disabled DNS view, allowing it to serve DNS queries again.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableDnsViewRequest.Builder} avoiding the need to
     * create one manually via {@link EnableDnsViewRequest#builder()}
     * </p>
     *
     * @param enableDnsViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.EnableDnsViewRequest.Builder} to create
     *        a request.
     * @return Result of the EnableDNSView operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.EnableDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/EnableDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableDnsViewResponse enableDNSView(Consumer<EnableDnsViewRequest.Builder> enableDnsViewRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return enableDNSView(EnableDnsViewRequest.builder().applyMutation(enableDnsViewRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an access source.
     * </p>
     *
     * @param getAccessSourceRequest
     * @return Result of the GetAccessSource operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetAccessSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetAccessSource"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccessSourceResponse getAccessSource(GetAccessSourceRequest getAccessSourceRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an access source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccessSourceRequest.Builder} avoiding the need
     * to create one manually via {@link GetAccessSourceRequest#builder()}
     * </p>
     *
     * @param getAccessSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.GetAccessSourceRequest.Builder} to
     *        create a request.
     * @return Result of the GetAccessSource operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetAccessSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetAccessSource"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccessSourceResponse getAccessSource(Consumer<GetAccessSourceRequest.Builder> getAccessSourceRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return getAccessSource(GetAccessSourceRequest.builder().applyMutation(getAccessSourceRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an access token.
     * </p>
     *
     * @param getAccessTokenRequest
     * @return Result of the GetAccessToken operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccessTokenResponse getAccessToken(GetAccessTokenRequest getAccessTokenRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an access token.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccessTokenRequest.Builder} avoiding the need to
     * create one manually via {@link GetAccessTokenRequest#builder()}
     * </p>
     *
     * @param getAccessTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.GetAccessTokenRequest.Builder} to
     *        create a request.
     * @return Result of the GetAccessToken operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccessTokenResponse getAccessToken(Consumer<GetAccessTokenRequest.Builder> getAccessTokenRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return getAccessToken(GetAccessTokenRequest.builder().applyMutation(getAccessTokenRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a DNS view.
     * </p>
     *
     * @param getDnsViewRequest
     * @return Result of the GetDNSView operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDnsViewResponse getDNSView(GetDnsViewRequest getDnsViewRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a DNS view.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDnsViewRequest.Builder} avoiding the need to
     * create one manually via {@link GetDnsViewRequest#builder()}
     * </p>
     *
     * @param getDnsViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.GetDnsViewRequest.Builder} to create a
     *        request.
     * @return Result of the GetDNSView operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDnsViewResponse getDNSView(Consumer<GetDnsViewRequest.Builder> getDnsViewRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        return getDNSView(GetDnsViewRequest.builder().applyMutation(getDnsViewRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a firewall domain list.
     * </p>
     *
     * @param getFirewallDomainListRequest
     * @return Result of the GetFirewallDomainList operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFirewallDomainListResponse getFirewallDomainList(GetFirewallDomainListRequest getFirewallDomainListRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a firewall domain list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFirewallDomainListRequest.Builder} avoiding the
     * need to create one manually via {@link GetFirewallDomainListRequest#builder()}
     * </p>
     *
     * @param getFirewallDomainListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.GetFirewallDomainListRequest.Builder}
     *        to create a request.
     * @return Result of the GetFirewallDomainList operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetFirewallDomainList
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFirewallDomainListResponse getFirewallDomainList(
            Consumer<GetFirewallDomainListRequest.Builder> getFirewallDomainListRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        return getFirewallDomainList(GetFirewallDomainListRequest.builder().applyMutation(getFirewallDomainListRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a DNS firewall rule.
     * </p>
     *
     * @param getFirewallRuleRequest
     * @return Result of the GetFirewallRule operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFirewallRuleResponse getFirewallRule(GetFirewallRuleRequest getFirewallRuleRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a DNS firewall rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFirewallRuleRequest.Builder} avoiding the need
     * to create one manually via {@link GetFirewallRuleRequest#builder()}
     * </p>
     *
     * @param getFirewallRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.GetFirewallRuleRequest.Builder} to
     *        create a request.
     * @return Result of the GetFirewallRule operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFirewallRuleResponse getFirewallRule(Consumer<GetFirewallRuleRequest.Builder> getFirewallRuleRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return getFirewallRule(GetFirewallRuleRequest.builder().applyMutation(getFirewallRuleRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a Route 53 Global Resolver instance.
     * </p>
     *
     * @param getGlobalResolverRequest
     * @return Result of the GetGlobalResolver operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetGlobalResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetGlobalResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGlobalResolverResponse getGlobalResolver(GetGlobalResolverRequest getGlobalResolverRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a Route 53 Global Resolver instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGlobalResolverRequest.Builder} avoiding the need
     * to create one manually via {@link GetGlobalResolverRequest#builder()}
     * </p>
     *
     * @param getGlobalResolverRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.GetGlobalResolverRequest.Builder} to
     *        create a request.
     * @return Result of the GetGlobalResolver operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetGlobalResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetGlobalResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGlobalResolverResponse getGlobalResolver(Consumer<GetGlobalResolverRequest.Builder> getGlobalResolverRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return getGlobalResolver(GetGlobalResolverRequest.builder().applyMutation(getGlobalResolverRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a hosted zone association.
     * </p>
     *
     * @param getHostedZoneAssociationRequest
     * @return Result of the GetHostedZoneAssociation operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetHostedZoneAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetHostedZoneAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetHostedZoneAssociationResponse getHostedZoneAssociation(
            GetHostedZoneAssociationRequest getHostedZoneAssociationRequest) throws InternalServerException, ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a hosted zone association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetHostedZoneAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link GetHostedZoneAssociationRequest#builder()}
     * </p>
     *
     * @param getHostedZoneAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.GetHostedZoneAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the GetHostedZoneAssociation operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetHostedZoneAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetHostedZoneAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetHostedZoneAssociationResponse getHostedZoneAssociation(
            Consumer<GetHostedZoneAssociationRequest.Builder> getHostedZoneAssociationRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        return getHostedZoneAssociation(GetHostedZoneAssociationRequest.builder().applyMutation(getHostedZoneAssociationRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about an AWS-managed firewall domain list. Managed domain lists contain domains associated
     * with malicious activity, content categories, or specific threats.
     * </p>
     *
     * @param getManagedFirewallDomainListRequest
     * @return Result of the GetManagedFirewallDomainList operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetManagedFirewallDomainList
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetManagedFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedFirewallDomainListResponse getManagedFirewallDomainList(
            GetManagedFirewallDomainListRequest getManagedFirewallDomainListRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an AWS-managed firewall domain list. Managed domain lists contain domains associated
     * with malicious activity, content categories, or specific threats.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetManagedFirewallDomainListRequest.Builder}
     * avoiding the need to create one manually via {@link GetManagedFirewallDomainListRequest#builder()}
     * </p>
     *
     * @param getManagedFirewallDomainListRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.GetManagedFirewallDomainListRequest.Builder}
     *        to create a request.
     * @return Result of the GetManagedFirewallDomainList operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.GetManagedFirewallDomainList
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/GetManagedFirewallDomainList"
     *      target="_top">AWS API Documentation</a>
     */
    default GetManagedFirewallDomainListResponse getManagedFirewallDomainList(
            Consumer<GetManagedFirewallDomainListRequest.Builder> getManagedFirewallDomainListRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return getManagedFirewallDomainList(GetManagedFirewallDomainListRequest.builder()
                .applyMutation(getManagedFirewallDomainListRequest).build());
    }

    /**
     * <p>
     * Imports a list of domains from an Amazon S3 file into a firewall domain list. The file should contain one domain
     * per line.
     * </p>
     *
     * @param importFirewallDomainsRequest
     * @return Result of the ImportFirewallDomains operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ImportFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ImportFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportFirewallDomainsResponse importFirewallDomains(ImportFirewallDomainsRequest importFirewallDomainsRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports a list of domains from an Amazon S3 file into a firewall domain list. The file should contain one domain
     * per line.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportFirewallDomainsRequest.Builder} avoiding the
     * need to create one manually via {@link ImportFirewallDomainsRequest#builder()}
     * </p>
     *
     * @param importFirewallDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ImportFirewallDomainsRequest.Builder}
     *        to create a request.
     * @return Result of the ImportFirewallDomains operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ImportFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ImportFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportFirewallDomainsResponse importFirewallDomains(
            Consumer<ImportFirewallDomainsRequest.Builder> importFirewallDomainsRequest) throws InternalServerException,
            ValidationException, ConflictException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return importFirewallDomains(ImportFirewallDomainsRequest.builder().applyMutation(importFirewallDomainsRequest).build());
    }

    /**
     * <p>
     * Lists all access sources with pagination support.
     * </p>
     *
     * @param listAccessSourcesRequest
     * @return Result of the ListAccessSources operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListAccessSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListAccessSources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessSourcesResponse listAccessSources(ListAccessSourcesRequest listAccessSourcesRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all access sources with pagination support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListAccessSourcesRequest#builder()}
     * </p>
     *
     * @param listAccessSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesRequest.Builder} to
     *        create a request.
     * @return Result of the ListAccessSources operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListAccessSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListAccessSources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessSourcesResponse listAccessSources(Consumer<ListAccessSourcesRequest.Builder> listAccessSourcesRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        return listAccessSources(ListAccessSourcesRequest.builder().applyMutation(listAccessSourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccessSources(software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessSourcesIterable responses = client.listAccessSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessSourcesIterable responses = client
     *             .listAccessSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessSourcesIterable responses = client.listAccessSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessSources(software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccessSourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListAccessSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListAccessSources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessSourcesIterable listAccessSourcesPaginator(ListAccessSourcesRequest listAccessSourcesRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        return new ListAccessSourcesIterable(this, listAccessSourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccessSources(software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessSourcesIterable responses = client.listAccessSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessSourcesIterable responses = client
     *             .listAccessSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessSourcesIterable responses = client.listAccessSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessSources(software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListAccessSourcesRequest#builder()}
     * </p>
     *
     * @param listAccessSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListAccessSourcesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListAccessSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListAccessSources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessSourcesIterable listAccessSourcesPaginator(
            Consumer<ListAccessSourcesRequest.Builder> listAccessSourcesRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        return listAccessSourcesPaginator(ListAccessSourcesRequest.builder().applyMutation(listAccessSourcesRequest).build());
    }

    /**
     * <p>
     * Lists all access tokens for a DNS view with pagination support.
     * </p>
     *
     * @param listAccessTokensRequest
     * @return Result of the ListAccessTokens operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListAccessTokens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListAccessTokens"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessTokensResponse listAccessTokens(ListAccessTokensRequest listAccessTokensRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all access tokens for a DNS view with pagination support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessTokensRequest.Builder} avoiding the need
     * to create one manually via {@link ListAccessTokensRequest#builder()}
     * </p>
     *
     * @param listAccessTokensRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensRequest.Builder} to
     *        create a request.
     * @return Result of the ListAccessTokens operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListAccessTokens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListAccessTokens"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessTokensResponse listAccessTokens(Consumer<ListAccessTokensRequest.Builder> listAccessTokensRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return listAccessTokens(ListAccessTokensRequest.builder().applyMutation(listAccessTokensRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccessTokens(software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessTokensIterable responses = client.listAccessTokensPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessTokensIterable responses = client
     *             .listAccessTokensPaginator(request);
     *     for (software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessTokensIterable responses = client.listAccessTokensPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessTokens(software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccessTokensRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListAccessTokens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListAccessTokens"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessTokensIterable listAccessTokensPaginator(ListAccessTokensRequest listAccessTokensRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return new ListAccessTokensIterable(this, listAccessTokensRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccessTokens(software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessTokensIterable responses = client.listAccessTokensPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessTokensIterable responses = client
     *             .listAccessTokensPaginator(request);
     *     for (software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListAccessTokensIterable responses = client.listAccessTokensPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessTokens(software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessTokensRequest.Builder} avoiding the need
     * to create one manually via {@link ListAccessTokensRequest#builder()}
     * </p>
     *
     * @param listAccessTokensRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListAccessTokensRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListAccessTokens
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListAccessTokens"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessTokensIterable listAccessTokensPaginator(Consumer<ListAccessTokensRequest.Builder> listAccessTokensRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return listAccessTokensPaginator(ListAccessTokensRequest.builder().applyMutation(listAccessTokensRequest).build());
    }

    /**
     * <p>
     * Lists all DNS views for a Route 53 Global Resolver with pagination support.
     * </p>
     *
     * @param listDnsViewsRequest
     * @return Result of the ListDNSViews operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListDNSViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListDNSViews"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDnsViewsResponse listDNSViews(ListDnsViewsRequest listDnsViewsRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all DNS views for a Route 53 Global Resolver with pagination support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDnsViewsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDnsViewsRequest#builder()}
     * </p>
     *
     * @param listDnsViewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsRequest.Builder} to create
     *        a request.
     * @return Result of the ListDNSViews operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListDNSViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListDNSViews"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDnsViewsResponse listDNSViews(Consumer<ListDnsViewsRequest.Builder> listDnsViewsRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return listDNSViews(ListDnsViewsRequest.builder().applyMutation(listDnsViewsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDNSViews(software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListDNSViewsIterable responses = client.listDNSViewsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53globalresolver.paginators.ListDNSViewsIterable responses = client
     *             .listDNSViewsPaginator(request);
     *     for (software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListDNSViewsIterable responses = client.listDNSViewsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDNSViews(software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDnsViewsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListDNSViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListDNSViews"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDNSViewsIterable listDNSViewsPaginator(ListDnsViewsRequest listDnsViewsRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        return new ListDNSViewsIterable(this, listDnsViewsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDNSViews(software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListDNSViewsIterable responses = client.listDNSViewsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53globalresolver.paginators.ListDNSViewsIterable responses = client
     *             .listDNSViewsPaginator(request);
     *     for (software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListDNSViewsIterable responses = client.listDNSViewsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDNSViews(software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDnsViewsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDnsViewsRequest#builder()}
     * </p>
     *
     * @param listDnsViewsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListDnsViewsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListDNSViews
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListDNSViews"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDNSViewsIterable listDNSViewsPaginator(Consumer<ListDnsViewsRequest.Builder> listDnsViewsRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return listDNSViewsPaginator(ListDnsViewsRequest.builder().applyMutation(listDnsViewsRequest).build());
    }

    /**
     * <p>
     * Lists all firewall domain lists for a Route 53 Global Resolver with pagination support.
     * </p>
     *
     * @param listFirewallDomainListsRequest
     * @return Result of the ListFirewallDomainLists operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListFirewallDomainLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallDomainListsResponse listFirewallDomainLists(ListFirewallDomainListsRequest listFirewallDomainListsRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all firewall domain lists for a Route 53 Global Resolver with pagination support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallDomainListsRequest.Builder} avoiding
     * the need to create one manually via {@link ListFirewallDomainListsRequest#builder()}
     * </p>
     *
     * @param listFirewallDomainListsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsRequest.Builder}
     *        to create a request.
     * @return Result of the ListFirewallDomainLists operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListFirewallDomainLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallDomainListsResponse listFirewallDomainLists(
            Consumer<ListFirewallDomainListsRequest.Builder> listFirewallDomainListsRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        return listFirewallDomainLists(ListFirewallDomainListsRequest.builder().applyMutation(listFirewallDomainListsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFirewallDomainLists(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainListsIterable responses = client.listFirewallDomainListsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainListsIterable responses = client
     *             .listFirewallDomainListsPaginator(request);
     *     for (software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainListsIterable responses = client.listFirewallDomainListsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallDomainLists(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFirewallDomainListsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListFirewallDomainLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallDomainListsIterable listFirewallDomainListsPaginator(
            ListFirewallDomainListsRequest listFirewallDomainListsRequest) throws InternalServerException, ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        return new ListFirewallDomainListsIterable(this, listFirewallDomainListsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFirewallDomainLists(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainListsIterable responses = client.listFirewallDomainListsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainListsIterable responses = client
     *             .listFirewallDomainListsPaginator(request);
     *     for (software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainListsIterable responses = client.listFirewallDomainListsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallDomainLists(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallDomainListsRequest.Builder} avoiding
     * the need to create one manually via {@link ListFirewallDomainListsRequest#builder()}
     * </p>
     *
     * @param listFirewallDomainListsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainListsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListFirewallDomainLists
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallDomainListsIterable listFirewallDomainListsPaginator(
            Consumer<ListFirewallDomainListsRequest.Builder> listFirewallDomainListsRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        return listFirewallDomainListsPaginator(ListFirewallDomainListsRequest.builder()
                .applyMutation(listFirewallDomainListsRequest).build());
    }

    /**
     * <p>
     * Lists all the domains in DNS Firewall domain list you have created.
     * </p>
     *
     * @param listFirewallDomainsRequest
     * @return Result of the ListFirewallDomains operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallDomainsResponse listFirewallDomains(ListFirewallDomainsRequest listFirewallDomainsRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the domains in DNS Firewall domain list you have created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallDomainsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFirewallDomainsRequest#builder()}
     * </p>
     *
     * @param listFirewallDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsRequest.Builder} to
     *        create a request.
     * @return Result of the ListFirewallDomains operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallDomainsResponse listFirewallDomains(
            Consumer<ListFirewallDomainsRequest.Builder> listFirewallDomainsRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        return listFirewallDomains(ListFirewallDomainsRequest.builder().applyMutation(listFirewallDomainsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFirewallDomains(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainsIterable responses = client.listFirewallDomainsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainsIterable responses = client
     *             .listFirewallDomainsPaginator(request);
     *     for (software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainsIterable responses = client.listFirewallDomainsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallDomains(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFirewallDomainsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallDomainsIterable listFirewallDomainsPaginator(ListFirewallDomainsRequest listFirewallDomainsRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return new ListFirewallDomainsIterable(this, listFirewallDomainsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFirewallDomains(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainsIterable responses = client.listFirewallDomainsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainsIterable responses = client
     *             .listFirewallDomainsPaginator(request);
     *     for (software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallDomainsIterable responses = client.listFirewallDomainsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallDomains(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallDomainsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFirewallDomainsRequest#builder()}
     * </p>
     *
     * @param listFirewallDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListFirewallDomainsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallDomainsIterable listFirewallDomainsPaginator(
            Consumer<ListFirewallDomainsRequest.Builder> listFirewallDomainsRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        return listFirewallDomainsPaginator(ListFirewallDomainsRequest.builder().applyMutation(listFirewallDomainsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all DNS firewall rules for a DNS view with pagination support.
     * </p>
     *
     * @param listFirewallRulesRequest
     * @return Result of the ListFirewallRules operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListFirewallRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallRulesResponse listFirewallRules(ListFirewallRulesRequest listFirewallRulesRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all DNS firewall rules for a DNS view with pagination support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallRulesRequest.Builder} avoiding the need
     * to create one manually via {@link ListFirewallRulesRequest#builder()}
     * </p>
     *
     * @param listFirewallRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesRequest.Builder} to
     *        create a request.
     * @return Result of the ListFirewallRules operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListFirewallRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallRulesResponse listFirewallRules(Consumer<ListFirewallRulesRequest.Builder> listFirewallRulesRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return listFirewallRules(ListFirewallRulesRequest.builder().applyMutation(listFirewallRulesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFirewallRules(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallRulesIterable responses = client.listFirewallRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallRulesIterable responses = client
     *             .listFirewallRulesPaginator(request);
     *     for (software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallRulesIterable responses = client.listFirewallRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallRules(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFirewallRulesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListFirewallRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallRulesIterable listFirewallRulesPaginator(ListFirewallRulesRequest listFirewallRulesRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return new ListFirewallRulesIterable(this, listFirewallRulesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFirewallRules(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallRulesIterable responses = client.listFirewallRulesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallRulesIterable responses = client
     *             .listFirewallRulesPaginator(request);
     *     for (software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListFirewallRulesIterable responses = client.listFirewallRulesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFirewallRules(software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFirewallRulesRequest.Builder} avoiding the need
     * to create one manually via {@link ListFirewallRulesRequest#builder()}
     * </p>
     *
     * @param listFirewallRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListFirewallRulesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListFirewallRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListFirewallRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFirewallRulesIterable listFirewallRulesPaginator(
            Consumer<ListFirewallRulesRequest.Builder> listFirewallRulesRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        return listFirewallRulesPaginator(ListFirewallRulesRequest.builder().applyMutation(listFirewallRulesRequest).build());
    }

    /**
     * <p>
     * Lists all Route 53 Global Resolver instances in your account with pagination support.
     * </p>
     *
     * @param listGlobalResolversRequest
     * @return Result of the ListGlobalResolvers operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListGlobalResolvers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListGlobalResolvers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGlobalResolversResponse listGlobalResolvers(ListGlobalResolversRequest listGlobalResolversRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Route 53 Global Resolver instances in your account with pagination support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGlobalResolversRequest.Builder} avoiding the
     * need to create one manually via {@link ListGlobalResolversRequest#builder()}
     * </p>
     *
     * @param listGlobalResolversRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversRequest.Builder} to
     *        create a request.
     * @return Result of the ListGlobalResolvers operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListGlobalResolvers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListGlobalResolvers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGlobalResolversResponse listGlobalResolvers(
            Consumer<ListGlobalResolversRequest.Builder> listGlobalResolversRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        return listGlobalResolvers(ListGlobalResolversRequest.builder().applyMutation(listGlobalResolversRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGlobalResolvers(software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListGlobalResolversIterable responses = client.listGlobalResolversPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53globalresolver.paginators.ListGlobalResolversIterable responses = client
     *             .listGlobalResolversPaginator(request);
     *     for (software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListGlobalResolversIterable responses = client.listGlobalResolversPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGlobalResolvers(software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGlobalResolversRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListGlobalResolvers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListGlobalResolvers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGlobalResolversIterable listGlobalResolversPaginator(ListGlobalResolversRequest listGlobalResolversRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        return new ListGlobalResolversIterable(this, listGlobalResolversRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGlobalResolvers(software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListGlobalResolversIterable responses = client.listGlobalResolversPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53globalresolver.paginators.ListGlobalResolversIterable responses = client
     *             .listGlobalResolversPaginator(request);
     *     for (software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListGlobalResolversIterable responses = client.listGlobalResolversPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGlobalResolvers(software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGlobalResolversRequest.Builder} avoiding the
     * need to create one manually via {@link ListGlobalResolversRequest#builder()}
     * </p>
     *
     * @param listGlobalResolversRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListGlobalResolversRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListGlobalResolvers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListGlobalResolvers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGlobalResolversIterable listGlobalResolversPaginator(
            Consumer<ListGlobalResolversRequest.Builder> listGlobalResolversRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        return listGlobalResolversPaginator(ListGlobalResolversRequest.builder().applyMutation(listGlobalResolversRequest)
                .build());
    }

    /**
     * <p>
     * Lists all hosted zone associations for a Route 53 Global Resolver resource with pagination support.
     * </p>
     *
     * @param listHostedZoneAssociationsRequest
     * @return Result of the ListHostedZoneAssociations operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListHostedZoneAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListHostedZoneAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHostedZoneAssociationsResponse listHostedZoneAssociations(
            ListHostedZoneAssociationsRequest listHostedZoneAssociationsRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all hosted zone associations for a Route 53 Global Resolver resource with pagination support.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHostedZoneAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListHostedZoneAssociationsRequest#builder()}
     * </p>
     *
     * @param listHostedZoneAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListHostedZoneAssociations operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListHostedZoneAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListHostedZoneAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHostedZoneAssociationsResponse listHostedZoneAssociations(
            Consumer<ListHostedZoneAssociationsRequest.Builder> listHostedZoneAssociationsRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return listHostedZoneAssociations(ListHostedZoneAssociationsRequest.builder()
                .applyMutation(listHostedZoneAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listHostedZoneAssociations(software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListHostedZoneAssociationsIterable responses = client.listHostedZoneAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53globalresolver.paginators.ListHostedZoneAssociationsIterable responses = client
     *             .listHostedZoneAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListHostedZoneAssociationsIterable responses = client.listHostedZoneAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHostedZoneAssociations(software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listHostedZoneAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListHostedZoneAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListHostedZoneAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHostedZoneAssociationsIterable listHostedZoneAssociationsPaginator(
            ListHostedZoneAssociationsRequest listHostedZoneAssociationsRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        return new ListHostedZoneAssociationsIterable(this, listHostedZoneAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listHostedZoneAssociations(software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListHostedZoneAssociationsIterable responses = client.listHostedZoneAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53globalresolver.paginators.ListHostedZoneAssociationsIterable responses = client
     *             .listHostedZoneAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListHostedZoneAssociationsIterable responses = client.listHostedZoneAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listHostedZoneAssociations(software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListHostedZoneAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListHostedZoneAssociationsRequest#builder()}
     * </p>
     *
     * @param listHostedZoneAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListHostedZoneAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListHostedZoneAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListHostedZoneAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListHostedZoneAssociationsIterable listHostedZoneAssociationsPaginator(
            Consumer<ListHostedZoneAssociationsRequest.Builder> listHostedZoneAssociationsRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return listHostedZoneAssociationsPaginator(ListHostedZoneAssociationsRequest.builder()
                .applyMutation(listHostedZoneAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns a paginated list of the AWS Managed DNS Lists and the categories for DNS Firewall. The categories are
     * either <code>THREAT</code> or <code>CONTENT</code>.
     * </p>
     *
     * @param listManagedFirewallDomainListsRequest
     * @return Result of the ListManagedFirewallDomainLists operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListManagedFirewallDomainLists
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListManagedFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedFirewallDomainListsResponse listManagedFirewallDomainLists(
            ListManagedFirewallDomainListsRequest listManagedFirewallDomainListsRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a paginated list of the AWS Managed DNS Lists and the categories for DNS Firewall. The categories are
     * either <code>THREAT</code> or <code>CONTENT</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedFirewallDomainListsRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedFirewallDomainListsRequest#builder()}
     * </p>
     *
     * @param listManagedFirewallDomainListsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsRequest.Builder}
     *        to create a request.
     * @return Result of the ListManagedFirewallDomainLists operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListManagedFirewallDomainLists
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListManagedFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedFirewallDomainListsResponse listManagedFirewallDomainLists(
            Consumer<ListManagedFirewallDomainListsRequest.Builder> listManagedFirewallDomainListsRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        return listManagedFirewallDomainLists(ListManagedFirewallDomainListsRequest.builder()
                .applyMutation(listManagedFirewallDomainListsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedFirewallDomainLists(software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListManagedFirewallDomainListsIterable responses = client.listManagedFirewallDomainListsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53globalresolver.paginators.ListManagedFirewallDomainListsIterable responses = client
     *             .listManagedFirewallDomainListsPaginator(request);
     *     for (software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListManagedFirewallDomainListsIterable responses = client.listManagedFirewallDomainListsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedFirewallDomainLists(software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listManagedFirewallDomainListsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListManagedFirewallDomainLists
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListManagedFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedFirewallDomainListsIterable listManagedFirewallDomainListsPaginator(
            ListManagedFirewallDomainListsRequest listManagedFirewallDomainListsRequest) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        return new ListManagedFirewallDomainListsIterable(this, listManagedFirewallDomainListsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listManagedFirewallDomainLists(software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListManagedFirewallDomainListsIterable responses = client.listManagedFirewallDomainListsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.route53globalresolver.paginators.ListManagedFirewallDomainListsIterable responses = client
     *             .listManagedFirewallDomainListsPaginator(request);
     *     for (software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.route53globalresolver.paginators.ListManagedFirewallDomainListsIterable responses = client.listManagedFirewallDomainListsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedFirewallDomainLists(software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedFirewallDomainListsRequest.Builder}
     * avoiding the need to create one manually via {@link ListManagedFirewallDomainListsRequest#builder()}
     * </p>
     *
     * @param listManagedFirewallDomainListsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListManagedFirewallDomainListsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListManagedFirewallDomainLists
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListManagedFirewallDomainLists"
     *      target="_top">AWS API Documentation</a>
     */
    default ListManagedFirewallDomainListsIterable listManagedFirewallDomainListsPaginator(
            Consumer<ListManagedFirewallDomainListsRequest.Builder> listManagedFirewallDomainListsRequest)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, AwsServiceException,
            SdkClientException, Route53GlobalResolverException {
        return listManagedFirewallDomainListsPaginator(ListManagedFirewallDomainListsRequest.builder()
                .applyMutation(listManagedFirewallDomainListsRequest).build());
    }

    /**
     * <p>
     * Lists the tags associated with a Route 53 Global Resolver resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags associated with a Route 53 Global Resolver resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds or updates tags for a Route 53 Global Resolver resource. Tags are key-value pairs that help you organize and
     * identify your resources.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            ServiceQuotaExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates tags for a Route 53 Global Resolver resource. Tags are key-value pairs that help you organize and
     * identify your resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            ServiceQuotaExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a Route 53 Global Resolver resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a Route 53 Global Resolver resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.UntagResourceRequest.Builder} to create
     *        a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an access source.
     * </p>
     *
     * @param updateAccessSourceRequest
     * @return Result of the UpdateAccessSource operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UpdateAccessSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateAccessSource"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccessSourceResponse updateAccessSource(UpdateAccessSourceRequest updateAccessSourceRequest)
            throws InternalServerException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an access source.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccessSourceRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAccessSourceRequest#builder()}
     * </p>
     *
     * @param updateAccessSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.UpdateAccessSourceRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateAccessSource operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws ServiceQuotaExceededException
     *         The request would exceed one or more service quotas. Check your current usage and quotas, then try again.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UpdateAccessSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateAccessSource"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccessSourceResponse updateAccessSource(Consumer<UpdateAccessSourceRequest.Builder> updateAccessSourceRequest)
            throws InternalServerException, ValidationException, ConflictException, ServiceQuotaExceededException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Route53GlobalResolverException {
        return updateAccessSource(UpdateAccessSourceRequest.builder().applyMutation(updateAccessSourceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of an access token.
     * </p>
     *
     * @param updateAccessTokenRequest
     * @return Result of the UpdateAccessToken operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UpdateAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccessTokenResponse updateAccessToken(UpdateAccessTokenRequest updateAccessTokenRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of an access token.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccessTokenRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateAccessTokenRequest#builder()}
     * </p>
     *
     * @param updateAccessTokenRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.UpdateAccessTokenRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateAccessToken operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UpdateAccessToken
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateAccessToken"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccessTokenResponse updateAccessToken(Consumer<UpdateAccessTokenRequest.Builder> updateAccessTokenRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return updateAccessToken(UpdateAccessTokenRequest.builder().applyMutation(updateAccessTokenRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of a DNS view.
     * </p>
     *
     * @param updateDnsViewRequest
     * @return Result of the UpdateDNSView operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UpdateDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDnsViewResponse updateDNSView(UpdateDnsViewRequest updateDnsViewRequest) throws InternalServerException,
            ValidationException, ConflictException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of a DNS view.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDnsViewRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDnsViewRequest#builder()}
     * </p>
     *
     * @param updateDnsViewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.UpdateDnsViewRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateDNSView operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UpdateDNSView
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateDNSView"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDnsViewResponse updateDNSView(Consumer<UpdateDnsViewRequest.Builder> updateDnsViewRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return updateDNSView(UpdateDnsViewRequest.builder().applyMutation(updateDnsViewRequest).build());
    }

    /**
     * <p>
     * Updates a DNS Firewall domain list from an array of specified domains.
     * </p>
     *
     * @param updateFirewallDomainsRequest
     * @return Result of the UpdateFirewallDomains operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UpdateFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallDomainsResponse updateFirewallDomains(UpdateFirewallDomainsRequest updateFirewallDomainsRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a DNS Firewall domain list from an array of specified domains.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFirewallDomainsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFirewallDomainsRequest#builder()}
     * </p>
     *
     * @param updateFirewallDomainsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.UpdateFirewallDomainsRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateFirewallDomains operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UpdateFirewallDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateFirewallDomains"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallDomainsResponse updateFirewallDomains(
            Consumer<UpdateFirewallDomainsRequest.Builder> updateFirewallDomainsRequest) throws InternalServerException,
            ValidationException, ConflictException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return updateFirewallDomains(UpdateFirewallDomainsRequest.builder().applyMutation(updateFirewallDomainsRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of a DNS firewall rule.
     * </p>
     *
     * @param updateFirewallRuleRequest
     * @return Result of the UpdateFirewallRule operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UpdateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallRuleResponse updateFirewallRule(UpdateFirewallRuleRequest updateFirewallRuleRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of a DNS firewall rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFirewallRuleRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFirewallRuleRequest#builder()}
     * </p>
     *
     * @param updateFirewallRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.UpdateFirewallRuleRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateFirewallRule operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UpdateFirewallRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateFirewallRule"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFirewallRuleResponse updateFirewallRule(Consumer<UpdateFirewallRuleRequest.Builder> updateFirewallRuleRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return updateFirewallRule(UpdateFirewallRuleRequest.builder().applyMutation(updateFirewallRuleRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of a Route 53 Global Resolver instance. You can modify the name, description, and
     * observability region.
     * </p>
     *
     * @param updateGlobalResolverRequest
     * @return Result of the UpdateGlobalResolver operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UpdateGlobalResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateGlobalResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGlobalResolverResponse updateGlobalResolver(UpdateGlobalResolverRequest updateGlobalResolverRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of a Route 53 Global Resolver instance. You can modify the name, description, and
     * observability region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGlobalResolverRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateGlobalResolverRequest#builder()}
     * </p>
     *
     * @param updateGlobalResolverRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.UpdateGlobalResolverRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateGlobalResolver operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UpdateGlobalResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateGlobalResolver"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGlobalResolverResponse updateGlobalResolver(
            Consumer<UpdateGlobalResolverRequest.Builder> updateGlobalResolverRequest) throws InternalServerException,
            ValidationException, ConflictException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return updateGlobalResolver(UpdateGlobalResolverRequest.builder().applyMutation(updateGlobalResolverRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of a hosted zone association.
     * </p>
     *
     * @param updateHostedZoneAssociationRequest
     * @return Result of the UpdateHostedZoneAssociation operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UpdateHostedZoneAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateHostedZoneAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateHostedZoneAssociationResponse updateHostedZoneAssociation(
            UpdateHostedZoneAssociationRequest updateHostedZoneAssociationRequest) throws InternalServerException,
            ValidationException, ConflictException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, Route53GlobalResolverException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of a hosted zone association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateHostedZoneAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateHostedZoneAssociationRequest#builder()}
     * </p>
     *
     * @param updateHostedZoneAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.route53globalresolver.model.UpdateHostedZoneAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateHostedZoneAssociation operation returned by the service.
     * @throws InternalServerException
     *         An internal server error occurred. Try again later.
     * @throws ValidationException
     *         The input parameters are invalid. Check the parameter values and try again.
     * @throws ConflictException
     *         The request conflicts with the current state of the resource. This can occur when trying to modify a
     *         resource that is not in a valid state for the requested operation.
     * @throws AccessDeniedException
     *         You don't have permission to perform this operation. Check your IAM permissions and try again.
     * @throws ThrottlingException
     *         The request was throttled due to too many requests. Wait a moment and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found. Verify the resource ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Route53GlobalResolverException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Route53GlobalResolverClient.UpdateHostedZoneAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/route53globalresolver-2022-09-27/UpdateHostedZoneAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateHostedZoneAssociationResponse updateHostedZoneAssociation(
            Consumer<UpdateHostedZoneAssociationRequest.Builder> updateHostedZoneAssociationRequest)
            throws InternalServerException, ValidationException, ConflictException, AccessDeniedException, ThrottlingException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, Route53GlobalResolverException {
        return updateHostedZoneAssociation(UpdateHostedZoneAssociationRequest.builder()
                .applyMutation(updateHostedZoneAssociationRequest).build());
    }

    /**
     * Create a {@link Route53GlobalResolverClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Route53GlobalResolverClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Route53GlobalResolverClient}.
     */
    static Route53GlobalResolverClientBuilder builder() {
        return new DefaultRoute53GlobalResolverClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default Route53GlobalResolverServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
