/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.route53domains.Route53DomainsClient;
import software.amazon.awssdk.services.route53domains.model.CheckDomainAvailabilityRequest;
import software.amazon.awssdk.services.route53domains.model.CheckDomainAvailabilityResponse;
import software.amazon.awssdk.services.route53domains.model.CheckDomainTransferabilityRequest;
import software.amazon.awssdk.services.route53domains.model.CheckDomainTransferabilityResponse;
import software.amazon.awssdk.services.route53domains.model.DeleteTagsForDomainRequest;
import software.amazon.awssdk.services.route53domains.model.DeleteTagsForDomainResponse;
import software.amazon.awssdk.services.route53domains.model.DisableDomainAutoRenewRequest;
import software.amazon.awssdk.services.route53domains.model.DisableDomainAutoRenewResponse;
import software.amazon.awssdk.services.route53domains.model.DisableDomainTransferLockRequest;
import software.amazon.awssdk.services.route53domains.model.DisableDomainTransferLockResponse;
import software.amazon.awssdk.services.route53domains.model.DomainLimitExceededException;
import software.amazon.awssdk.services.route53domains.model.DuplicateRequestException;
import software.amazon.awssdk.services.route53domains.model.EnableDomainAutoRenewRequest;
import software.amazon.awssdk.services.route53domains.model.EnableDomainAutoRenewResponse;
import software.amazon.awssdk.services.route53domains.model.EnableDomainTransferLockRequest;
import software.amazon.awssdk.services.route53domains.model.EnableDomainTransferLockResponse;
import software.amazon.awssdk.services.route53domains.model.GetContactReachabilityStatusRequest;
import software.amazon.awssdk.services.route53domains.model.GetContactReachabilityStatusResponse;
import software.amazon.awssdk.services.route53domains.model.GetDomainDetailRequest;
import software.amazon.awssdk.services.route53domains.model.GetDomainDetailResponse;
import software.amazon.awssdk.services.route53domains.model.GetDomainSuggestionsRequest;
import software.amazon.awssdk.services.route53domains.model.GetDomainSuggestionsResponse;
import software.amazon.awssdk.services.route53domains.model.GetOperationDetailRequest;
import software.amazon.awssdk.services.route53domains.model.GetOperationDetailResponse;
import software.amazon.awssdk.services.route53domains.model.InvalidInputException;
import software.amazon.awssdk.services.route53domains.model.ListDomainsRequest;
import software.amazon.awssdk.services.route53domains.model.ListDomainsResponse;
import software.amazon.awssdk.services.route53domains.model.ListOperationsRequest;
import software.amazon.awssdk.services.route53domains.model.ListOperationsResponse;
import software.amazon.awssdk.services.route53domains.model.ListTagsForDomainRequest;
import software.amazon.awssdk.services.route53domains.model.ListTagsForDomainResponse;
import software.amazon.awssdk.services.route53domains.model.OperationLimitExceededException;
import software.amazon.awssdk.services.route53domains.model.RegisterDomainRequest;
import software.amazon.awssdk.services.route53domains.model.RegisterDomainResponse;
import software.amazon.awssdk.services.route53domains.model.RenewDomainRequest;
import software.amazon.awssdk.services.route53domains.model.RenewDomainResponse;
import software.amazon.awssdk.services.route53domains.model.ResendContactReachabilityEmailRequest;
import software.amazon.awssdk.services.route53domains.model.ResendContactReachabilityEmailResponse;
import software.amazon.awssdk.services.route53domains.model.RetrieveDomainAuthCodeRequest;
import software.amazon.awssdk.services.route53domains.model.RetrieveDomainAuthCodeResponse;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsException;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsRequest;
import software.amazon.awssdk.services.route53domains.model.TldRulesViolationException;
import software.amazon.awssdk.services.route53domains.model.TransferDomainRequest;
import software.amazon.awssdk.services.route53domains.model.TransferDomainResponse;
import software.amazon.awssdk.services.route53domains.model.UnsupportedTldException;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainContactPrivacyRequest;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainContactPrivacyResponse;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainContactRequest;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainContactResponse;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainNameserversRequest;
import software.amazon.awssdk.services.route53domains.model.UpdateDomainNameserversResponse;
import software.amazon.awssdk.services.route53domains.model.UpdateTagsForDomainRequest;
import software.amazon.awssdk.services.route53domains.model.UpdateTagsForDomainResponse;
import software.amazon.awssdk.services.route53domains.model.ViewBillingRequest;
import software.amazon.awssdk.services.route53domains.model.ViewBillingResponse;
import software.amazon.awssdk.services.route53domains.paginators.ListDomainsIterable;
import software.amazon.awssdk.services.route53domains.paginators.ListOperationsIterable;
import software.amazon.awssdk.services.route53domains.transform.CheckDomainAvailabilityRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.CheckDomainTransferabilityRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.DeleteTagsForDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.DisableDomainAutoRenewRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.DisableDomainTransferLockRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.EnableDomainAutoRenewRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.EnableDomainTransferLockRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.GetContactReachabilityStatusRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.GetDomainDetailRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.GetDomainSuggestionsRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.GetOperationDetailRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.ListDomainsRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.ListOperationsRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.ListTagsForDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.RegisterDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.RenewDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.ResendContactReachabilityEmailRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.RetrieveDomainAuthCodeRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.TransferDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.UpdateDomainContactPrivacyRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.UpdateDomainContactRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.UpdateDomainNameserversRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.UpdateTagsForDomainRequestMarshaller;
import software.amazon.awssdk.services.route53domains.transform.ViewBillingRequestMarshaller;

@SdkInternalApi
final class DefaultRoute53DomainsClient
implements Route53DomainsClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRoute53DomainsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "route53domains";
    }

    @Override
    public CheckDomainAvailabilityResponse checkDomainAvailability(CheckDomainAvailabilityRequest checkDomainAvailabilityRequest) throws InvalidInputException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CheckDomainAvailabilityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CheckDomainAvailabilityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CheckDomainAvailability").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)checkDomainAvailabilityRequest).withMarshaller((Marshaller)new CheckDomainAvailabilityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public CheckDomainTransferabilityResponse checkDomainTransferability(CheckDomainTransferabilityRequest checkDomainTransferabilityRequest) throws InvalidInputException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CheckDomainTransferabilityResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (CheckDomainTransferabilityResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CheckDomainTransferability").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)checkDomainTransferabilityRequest).withMarshaller((Marshaller)new CheckDomainTransferabilityRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DeleteTagsForDomainResponse deleteTagsForDomain(DeleteTagsForDomainRequest deleteTagsForDomainRequest) throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTagsForDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DeleteTagsForDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTagsForDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTagsForDomainRequest).withMarshaller((Marshaller)new DeleteTagsForDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisableDomainAutoRenewResponse disableDomainAutoRenew(DisableDomainAutoRenewRequest disableDomainAutoRenewRequest) throws InvalidInputException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableDomainAutoRenewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisableDomainAutoRenewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableDomainAutoRenew").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableDomainAutoRenewRequest).withMarshaller((Marshaller)new DisableDomainAutoRenewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public DisableDomainTransferLockResponse disableDomainTransferLock(DisableDomainTransferLockRequest disableDomainTransferLockRequest) throws InvalidInputException, DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableDomainTransferLockResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (DisableDomainTransferLockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableDomainTransferLock").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disableDomainTransferLockRequest).withMarshaller((Marshaller)new DisableDomainTransferLockRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public EnableDomainAutoRenewResponse enableDomainAutoRenew(EnableDomainAutoRenewRequest enableDomainAutoRenewRequest) throws InvalidInputException, UnsupportedTldException, TldRulesViolationException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableDomainAutoRenewResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (EnableDomainAutoRenewResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableDomainAutoRenew").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableDomainAutoRenewRequest).withMarshaller((Marshaller)new EnableDomainAutoRenewRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public EnableDomainTransferLockResponse enableDomainTransferLock(EnableDomainTransferLockRequest enableDomainTransferLockRequest) throws InvalidInputException, DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableDomainTransferLockResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (EnableDomainTransferLockResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableDomainTransferLock").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)enableDomainTransferLockRequest).withMarshaller((Marshaller)new EnableDomainTransferLockRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetContactReachabilityStatusResponse getContactReachabilityStatus(GetContactReachabilityStatusRequest getContactReachabilityStatusRequest) throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetContactReachabilityStatusResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetContactReachabilityStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetContactReachabilityStatus").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getContactReachabilityStatusRequest).withMarshaller((Marshaller)new GetContactReachabilityStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDomainDetailResponse getDomainDetail(GetDomainDetailRequest getDomainDetailRequest) throws InvalidInputException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainDetailResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDomainDetailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomainDetail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDomainDetailRequest).withMarshaller((Marshaller)new GetDomainDetailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetDomainSuggestionsResponse getDomainSuggestions(GetDomainSuggestionsRequest getDomainSuggestionsRequest) throws InvalidInputException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDomainSuggestionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetDomainSuggestionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDomainSuggestions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDomainSuggestionsRequest).withMarshaller((Marshaller)new GetDomainSuggestionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public GetOperationDetailResponse getOperationDetail(GetOperationDetailRequest getOperationDetailRequest) throws InvalidInputException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOperationDetailResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (GetOperationDetailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOperationDetail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getOperationDetailRequest).withMarshaller((Marshaller)new GetOperationDetailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDomainsResponse listDomains(ListDomainsRequest listDomainsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDomainsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListDomainsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomains").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDomainsRequest).withMarshaller((Marshaller)new ListDomainsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListDomainsIterable listDomainsPaginator(ListDomainsRequest listDomainsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, Route53DomainsException {
        return new ListDomainsIterable(this, this.applyPaginatorUserAgent(listDomainsRequest));
    }

    @Override
    public ListOperationsResponse listOperations(ListOperationsRequest listOperationsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOperationsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListOperationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOperations").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listOperationsRequest).withMarshaller((Marshaller)new ListOperationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ListOperationsIterable listOperationsPaginator(ListOperationsRequest listOperationsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, Route53DomainsException {
        return new ListOperationsIterable(this, this.applyPaginatorUserAgent(listOperationsRequest));
    }

    @Override
    public ListTagsForDomainResponse listTagsForDomain(ListTagsForDomainRequest listTagsForDomainRequest) throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ListTagsForDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForDomainRequest).withMarshaller((Marshaller)new ListTagsForDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RegisterDomainResponse registerDomain(RegisterDomainRequest registerDomainRequest) throws InvalidInputException, UnsupportedTldException, DuplicateRequestException, TldRulesViolationException, DomainLimitExceededException, OperationLimitExceededException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RegisterDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RegisterDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerDomainRequest).withMarshaller((Marshaller)new RegisterDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RenewDomainResponse renewDomain(RenewDomainRequest renewDomainRequest) throws InvalidInputException, UnsupportedTldException, DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RenewDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RenewDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RenewDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)renewDomainRequest).withMarshaller((Marshaller)new RenewDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ResendContactReachabilityEmailResponse resendContactReachabilityEmail(ResendContactReachabilityEmailRequest resendContactReachabilityEmailRequest) throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ResendContactReachabilityEmailResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ResendContactReachabilityEmailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ResendContactReachabilityEmail").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)resendContactReachabilityEmailRequest).withMarshaller((Marshaller)new ResendContactReachabilityEmailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public RetrieveDomainAuthCodeResponse retrieveDomainAuthCode(RetrieveDomainAuthCodeRequest retrieveDomainAuthCodeRequest) throws InvalidInputException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RetrieveDomainAuthCodeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (RetrieveDomainAuthCodeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RetrieveDomainAuthCode").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)retrieveDomainAuthCodeRequest).withMarshaller((Marshaller)new RetrieveDomainAuthCodeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public TransferDomainResponse transferDomain(TransferDomainRequest transferDomainRequest) throws InvalidInputException, UnsupportedTldException, DuplicateRequestException, TldRulesViolationException, DomainLimitExceededException, OperationLimitExceededException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TransferDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (TransferDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TransferDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)transferDomainRequest).withMarshaller((Marshaller)new TransferDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateDomainContactResponse updateDomainContact(UpdateDomainContactRequest updateDomainContactRequest) throws InvalidInputException, DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDomainContactResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateDomainContactResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDomainContact").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDomainContactRequest).withMarshaller((Marshaller)new UpdateDomainContactRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateDomainContactPrivacyResponse updateDomainContactPrivacy(UpdateDomainContactPrivacyRequest updateDomainContactPrivacyRequest) throws InvalidInputException, DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDomainContactPrivacyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateDomainContactPrivacyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDomainContactPrivacy").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDomainContactPrivacyRequest).withMarshaller((Marshaller)new UpdateDomainContactPrivacyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateDomainNameserversResponse updateDomainNameservers(UpdateDomainNameserversRequest updateDomainNameserversRequest) throws InvalidInputException, DuplicateRequestException, TldRulesViolationException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDomainNameserversResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateDomainNameserversResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDomainNameservers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDomainNameserversRequest).withMarshaller((Marshaller)new UpdateDomainNameserversRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public UpdateTagsForDomainResponse updateTagsForDomain(UpdateTagsForDomainRequest updateTagsForDomainRequest) throws InvalidInputException, OperationLimitExceededException, UnsupportedTldException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTagsForDomainResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (UpdateTagsForDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTagsForDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateTagsForDomainRequest).withMarshaller((Marshaller)new UpdateTagsForDomainRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    @Override
    public ViewBillingResponse viewBilling(ViewBillingRequest viewBillingRequest) throws InvalidInputException, AwsServiceException, SdkClientException, Route53DomainsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ViewBillingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        return (ViewBillingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ViewBilling").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)viewBillingRequest).withMarshaller((Marshaller)new ViewBillingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(Route53DomainsException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedTLD").exceptionBuilderSupplier(UnsupportedTldException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateRequest").exceptionBuilderSupplier(DuplicateRequestException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInput").exceptionBuilderSupplier(InvalidInputException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DomainLimitExceeded").exceptionBuilderSupplier(DomainLimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TLDRulesViolation").exceptionBuilderSupplier(TldRulesViolationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationLimitExceeded").exceptionBuilderSupplier(OperationLimitExceededException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends Route53DomainsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.5.30").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((Route53DomainsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

