/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53domains.model.ListOperationsSortAttributeName;
import software.amazon.awssdk.services.route53domains.model.OperationStatus;
import software.amazon.awssdk.services.route53domains.model.OperationStatusListCopier;
import software.amazon.awssdk.services.route53domains.model.OperationType;
import software.amazon.awssdk.services.route53domains.model.OperationTypeListCopier;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsRequest;
import software.amazon.awssdk.services.route53domains.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOperationsRequest
extends Route53DomainsRequest
implements ToCopyableBuilder<Builder, ListOperationsRequest> {
    private static final SdkField<Instant> SUBMITTED_SINCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SubmittedSince").getter(ListOperationsRequest.getter(ListOperationsRequest::submittedSince)).setter(ListOperationsRequest.setter(Builder::submittedSince)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmittedSince").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListOperationsRequest.getter(ListOperationsRequest::marker)).setter(ListOperationsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxItems").getter(ListOperationsRequest.getter(ListOperationsRequest::maxItems)).setter(ListOperationsRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()}).build();
    private static final SdkField<List<String>> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Status").getter(ListOperationsRequest.getter(ListOperationsRequest::statusAsStrings)).setter(ListOperationsRequest.setter(Builder::statusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Type").getter(ListOperationsRequest.getter(ListOperationsRequest::typeAsStrings)).setter(ListOperationsRequest.setter(Builder::typeWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortBy").getter(ListOperationsRequest.getter(ListOperationsRequest::sortByAsString)).setter(ListOperationsRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(ListOperationsRequest.getter(ListOperationsRequest::sortOrderAsString)).setter(ListOperationsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBMITTED_SINCE_FIELD, MARKER_FIELD, MAX_ITEMS_FIELD, STATUS_FIELD, TYPE_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListOperationsRequest.memberNameToFieldInitializer();
    private final Instant submittedSince;
    private final String marker;
    private final Integer maxItems;
    private final List<String> status;
    private final List<String> type;
    private final String sortBy;
    private final String sortOrder;

    private ListOperationsRequest(BuilderImpl builder) {
        super(builder);
        this.submittedSince = builder.submittedSince;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
        this.status = builder.status;
        this.type = builder.type;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    public final Instant submittedSince() {
        return this.submittedSince;
    }

    public final String marker() {
        return this.marker;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    public final List<OperationStatus> status() {
        return OperationStatusListCopier.copyStringToEnum(this.status);
    }

    public final boolean hasStatus() {
        return this.status != null && !(this.status instanceof SdkAutoConstructList);
    }

    public final List<String> statusAsStrings() {
        return this.status;
    }

    public final List<OperationType> type() {
        return OperationTypeListCopier.copyStringToEnum(this.type);
    }

    public final boolean hasType() {
        return this.type != null && !(this.type instanceof SdkAutoConstructList);
    }

    public final List<String> typeAsStrings() {
        return this.type;
    }

    public final ListOperationsSortAttributeName sortBy() {
        return ListOperationsSortAttributeName.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.submittedSince());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatus() ? this.statusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasType() ? this.typeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOperationsRequest)) {
            return false;
        }
        ListOperationsRequest other = (ListOperationsRequest)((Object)obj);
        return Objects.equals(this.submittedSince(), other.submittedSince()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems()) && this.hasStatus() == other.hasStatus() && Objects.equals(this.statusAsStrings(), other.statusAsStrings()) && this.hasType() == other.hasType() && Objects.equals(this.typeAsStrings(), other.typeAsStrings()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListOperationsRequest").add("SubmittedSince", (Object)this.submittedSince()).add("Marker", (Object)this.marker()).add("MaxItems", (Object)this.maxItems()).add("Status", this.hasStatus() ? this.statusAsStrings() : null).add("Type", this.hasType() ? this.typeAsStrings() : null).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubmittedSince": {
                return Optional.ofNullable(clazz.cast(this.submittedSince()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsStrings()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsStrings()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SubmittedSince", SUBMITTED_SINCE_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOperationsRequest, T> g) {
        return obj -> g.apply((ListOperationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsRequest.BuilderImpl
    implements Builder {
        private Instant submittedSince;
        private String marker;
        private Integer maxItems;
        private List<String> status = DefaultSdkAutoConstructList.getInstance();
        private List<String> type = DefaultSdkAutoConstructList.getInstance();
        private String sortBy;
        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOperationsRequest model) {
            super(model);
            this.submittedSince(model.submittedSince);
            this.marker(model.marker);
            this.maxItems(model.maxItems);
            this.statusWithStrings(model.status);
            this.typeWithStrings(model.type);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
        }

        public final Instant getSubmittedSince() {
            return this.submittedSince;
        }

        public final void setSubmittedSince(Instant submittedSince) {
            this.submittedSince = submittedSince;
        }

        @Override
        public final Builder submittedSince(Instant submittedSince) {
            this.submittedSince = submittedSince;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final Collection<String> getStatus() {
            if (this.status instanceof SdkAutoConstructList) {
                return null;
            }
            return this.status;
        }

        public final void setStatus(Collection<String> status) {
            this.status = OperationStatusListCopier.copy(status);
        }

        @Override
        public final Builder statusWithStrings(Collection<String> status) {
            this.status = OperationStatusListCopier.copy(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusWithStrings(String ... status) {
            this.statusWithStrings(Arrays.asList(status));
            return this;
        }

        @Override
        public final Builder status(Collection<OperationStatus> status) {
            this.status = OperationStatusListCopier.copyEnumToString(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder status(OperationStatus ... status) {
            this.status(Arrays.asList(status));
            return this;
        }

        public final Collection<String> getType() {
            if (this.type instanceof SdkAutoConstructList) {
                return null;
            }
            return this.type;
        }

        public final void setType(Collection<String> type) {
            this.type = OperationTypeListCopier.copy(type);
        }

        @Override
        public final Builder typeWithStrings(Collection<String> type) {
            this.type = OperationTypeListCopier.copy(type);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeWithStrings(String ... type) {
            this.typeWithStrings(Arrays.asList(type));
            return this;
        }

        @Override
        public final Builder type(Collection<OperationType> type) {
            this.type = OperationTypeListCopier.copyEnumToString(type);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder type(OperationType ... type) {
            this.type(Arrays.asList(type));
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ListOperationsSortAttributeName sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListOperationsRequest build() {
            return new ListOperationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53DomainsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOperationsRequest> {
        public Builder submittedSince(Instant var1);

        public Builder marker(String var1);

        public Builder maxItems(Integer var1);

        public Builder statusWithStrings(Collection<String> var1);

        public Builder statusWithStrings(String ... var1);

        public Builder status(Collection<OperationStatus> var1);

        public Builder status(OperationStatus ... var1);

        public Builder typeWithStrings(Collection<String> var1);

        public Builder typeWithStrings(String ... var1);

        public Builder type(Collection<OperationType> var1);

        public Builder type(OperationType ... var1);

        public Builder sortBy(String var1);

        public Builder sortBy(ListOperationsSortAttributeName var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

