/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53domains.Route53DomainsClient;
import software.amazon.awssdk.services.route53domains.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53domains.model.BillingRecord;
import software.amazon.awssdk.services.route53domains.model.ViewBillingRequest;
import software.amazon.awssdk.services.route53domains.model.ViewBillingResponse;

public class ViewBillingIterable
implements SdkIterable<ViewBillingResponse> {
    private final Route53DomainsClient client;
    private final ViewBillingRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ViewBillingIterable(Route53DomainsClient client, ViewBillingRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ViewBillingResponseFetcher();
    }

    public Iterator<ViewBillingResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BillingRecord> billingRecords() {
        Function<ViewBillingResponse, Iterator> getIterator = response -> {
            if (response != null && response.billingRecords() != null) {
                return response.billingRecords().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ViewBillingResponseFetcher
    implements SyncPageFetcher<ViewBillingResponse> {
        private ViewBillingResponseFetcher() {
        }

        public boolean hasNextPage(ViewBillingResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageMarker());
        }

        public ViewBillingResponse nextPage(ViewBillingResponse previousPage) {
            if (previousPage == null) {
                return ViewBillingIterable.this.client.viewBilling(ViewBillingIterable.this.firstRequest);
            }
            return ViewBillingIterable.this.client.viewBilling((ViewBillingRequest)((Object)ViewBillingIterable.this.firstRequest.toBuilder().marker(previousPage.nextPageMarker()).build()));
        }
    }
}

