/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DnssecSigningAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DnssecSigningAttributes> {
    private static final SdkField<Integer> ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Algorithm").getter(DnssecSigningAttributes.getter(DnssecSigningAttributes::algorithm)).setter(DnssecSigningAttributes.setter(Builder::algorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Algorithm").build()}).build();
    private static final SdkField<Integer> FLAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Flags").getter(DnssecSigningAttributes.getter(DnssecSigningAttributes::flags)).setter(DnssecSigningAttributes.setter(Builder::flags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Flags").build()}).build();
    private static final SdkField<String> PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicKey").getter(DnssecSigningAttributes.getter(DnssecSigningAttributes::publicKey)).setter(DnssecSigningAttributes.setter(Builder::publicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD, FLAGS_FIELD, PUBLIC_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DnssecSigningAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer algorithm;
    private final Integer flags;
    private final String publicKey;

    private DnssecSigningAttributes(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.flags = builder.flags;
        this.publicKey = builder.publicKey;
    }

    public final Integer algorithm() {
        return this.algorithm;
    }

    public final Integer flags() {
        return this.flags;
    }

    public final String publicKey() {
        return this.publicKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.flags());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnssecSigningAttributes)) {
            return false;
        }
        DnssecSigningAttributes other = (DnssecSigningAttributes)obj;
        return Objects.equals(this.algorithm(), other.algorithm()) && Objects.equals(this.flags(), other.flags()) && Objects.equals(this.publicKey(), other.publicKey());
    }

    public final String toString() {
        return ToString.builder((String)"DnssecSigningAttributes").add("Algorithm", (Object)this.algorithm()).add("Flags", (Object)this.flags()).add("PublicKey", (Object)this.publicKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Algorithm": {
                return Optional.ofNullable(clazz.cast(this.algorithm()));
            }
            case "Flags": {
                return Optional.ofNullable(clazz.cast(this.flags()));
            }
            case "PublicKey": {
                return Optional.ofNullable(clazz.cast(this.publicKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Algorithm", ALGORITHM_FIELD);
        map.put("Flags", FLAGS_FIELD);
        map.put("PublicKey", PUBLIC_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DnssecSigningAttributes, T> g) {
        return obj -> g.apply((DnssecSigningAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer algorithm;
        private Integer flags;
        private String publicKey;

        private BuilderImpl() {
        }

        private BuilderImpl(DnssecSigningAttributes model) {
            this.algorithm(model.algorithm);
            this.flags(model.flags);
            this.publicKey(model.publicKey);
        }

        public final Integer getAlgorithm() {
            return this.algorithm;
        }

        public final void setAlgorithm(Integer algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public final Builder algorithm(Integer algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public final Integer getFlags() {
            return this.flags;
        }

        public final void setFlags(Integer flags) {
            this.flags = flags;
        }

        @Override
        public final Builder flags(Integer flags) {
            this.flags = flags;
            return this;
        }

        public final String getPublicKey() {
            return this.publicKey;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        @Override
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public DnssecSigningAttributes build() {
            return new DnssecSigningAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DnssecSigningAttributes> {
        public Builder algorithm(Integer var1);

        public Builder flags(Integer var1);

        public Builder publicKey(String var1);
    }
}

