/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53domains.model.OperationSummary;
import software.amazon.awssdk.services.route53domains.model.OperationSummaryListCopier;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOperationsResponse
extends Route53DomainsResponse
implements ToCopyableBuilder<Builder, ListOperationsResponse> {
    private static final SdkField<List<OperationSummary>> OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Operations").getter(ListOperationsResponse.getter(ListOperationsResponse::operations)).setter(ListOperationsResponse.setter(Builder::operations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OperationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageMarker").getter(ListOperationsResponse.getter(ListOperationsResponse::nextPageMarker)).setter(ListOperationsResponse.setter(Builder::nextPageMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATIONS_FIELD, NEXT_PAGE_MARKER_FIELD));
    private final List<OperationSummary> operations;
    private final String nextPageMarker;

    private ListOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.operations = builder.operations;
        this.nextPageMarker = builder.nextPageMarker;
    }

    public final boolean hasOperations() {
        return this.operations != null && !(this.operations instanceof SdkAutoConstructList);
    }

    public final List<OperationSummary> operations() {
        return this.operations;
    }

    public final String nextPageMarker() {
        return this.nextPageMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperations() ? this.operations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageMarker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOperationsResponse)) {
            return false;
        }
        ListOperationsResponse other = (ListOperationsResponse)((Object)obj);
        return this.hasOperations() == other.hasOperations() && Objects.equals(this.operations(), other.operations()) && Objects.equals(this.nextPageMarker(), other.nextPageMarker());
    }

    public final String toString() {
        return ToString.builder((String)"ListOperationsResponse").add("Operations", this.hasOperations() ? this.operations() : null).add("NextPageMarker", (Object)this.nextPageMarker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Operations": {
                return Optional.ofNullable(clazz.cast(this.operations()));
            }
            case "NextPageMarker": {
                return Optional.ofNullable(clazz.cast(this.nextPageMarker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOperationsResponse, T> g) {
        return obj -> g.apply((ListOperationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsResponse.BuilderImpl
    implements Builder {
        private List<OperationSummary> operations = DefaultSdkAutoConstructList.getInstance();
        private String nextPageMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOperationsResponse model) {
            super(model);
            this.operations(model.operations);
            this.nextPageMarker(model.nextPageMarker);
        }

        public final List<OperationSummary.Builder> getOperations() {
            List<OperationSummary.Builder> result = OperationSummaryListCopier.copyToBuilder(this.operations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOperations(Collection<OperationSummary.BuilderImpl> operations) {
            this.operations = OperationSummaryListCopier.copyFromBuilder(operations);
        }

        @Override
        public final Builder operations(Collection<OperationSummary> operations) {
            this.operations = OperationSummaryListCopier.copy(operations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(OperationSummary ... operations) {
            this.operations(Arrays.asList(operations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operations(Consumer<OperationSummary.Builder> ... operations) {
            this.operations(Stream.of(operations).map(c -> (OperationSummary)((OperationSummary.Builder)OperationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageMarker() {
            return this.nextPageMarker;
        }

        public final void setNextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
        }

        @Override
        public final Builder nextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
            return this;
        }

        @Override
        public ListOperationsResponse build() {
            return new ListOperationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53DomainsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOperationsResponse> {
        public Builder operations(Collection<OperationSummary> var1);

        public Builder operations(OperationSummary ... var1);

        public Builder operations(Consumer<OperationSummary.Builder> ... var1);

        public Builder nextPageMarker(String var1);
    }
}

