/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Transferable {
    TRANSFERABLE("TRANSFERABLE"),
    UNTRANSFERABLE("UNTRANSFERABLE"),
    DONT_KNOW("DONT_KNOW"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Transferable> VALUE_MAP;
    private final String value;

    private Transferable(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Transferable fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Transferable> knownValues() {
        EnumSet<Transferable> knownValues = EnumSet.allOf(Transferable.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Transferable.class, Transferable::toString);
    }
}

