/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53domains.model.ContactDetail;
import software.amazon.awssdk.services.route53domains.model.DomainStatusListCopier;
import software.amazon.awssdk.services.route53domains.model.Nameserver;
import software.amazon.awssdk.services.route53domains.model.NameserverListCopier;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDomainDetailResponse
extends Route53DomainsResponse
implements ToCopyableBuilder<Builder, GetDomainDetailResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(GetDomainDetailResponse.getter(GetDomainDetailResponse::domainName)).setter(GetDomainDetailResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<List<Nameserver>> NAMESERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Nameservers").getter(GetDomainDetailResponse.getter(GetDomainDetailResponse::nameservers)).setter(GetDomainDetailResponse.setter(Builder::nameservers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Nameservers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Nameserver::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> AUTO_RENEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoRenew").getter(GetDomainDetailResponse.getter(GetDomainDetailResponse::autoRenew)).setter(GetDomainDetailResponse.setter(Builder::autoRenew)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRenew").build()}).build();
    private static final SdkField<ContactDetail> ADMIN_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdminContact").getter(GetDomainDetailResponse.getter(GetDomainDetailResponse::adminContact)).setter(GetDomainDetailResponse.setter(Builder::adminContact)).constructor(ContactDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminContact").build()}).build();
    private static final SdkField<ContactDetail> REGISTRANT_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RegistrantContact").getter(GetDomainDetailResponse.getter(GetDomainDetailResponse::registrantContact)).setter(GetDomainDetailResponse.setter(Builder::registrantContact)).constructor(ContactDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrantContact").build()}).build();
    private static final SdkField<ContactDetail> TECH_CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TechContact").getter(GetDomainDetailResponse.getter(GetDomainDetailResponse::techContact)).setter(GetDomainDetailResponse.setter(Builder::techContact)).constructor(ContactDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TechContact").build()}).build();
    private static final SdkField<Boolean> ADMIN_PRIVACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AdminPrivacy").getter(GetDomainDetailResponse.getter(GetDomainDetailResponse::adminPrivacy)).setter(GetDomainDetailResponse.setter(Builder::adminPrivacy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminPrivacy").build()}).build();
    private static final SdkField<Boolean> REGISTRANT_PRIVACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RegistrantPrivacy").getter(GetDomainDetailResponse.getter(GetDomainDetailResponse::registrantPrivacy)).setter(GetDomainDetailResponse.setter(Builder::registrantPrivacy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrantPrivacy").build()}).build();
    private static final SdkField<Boolean> TECH_PRIVACY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TechPrivacy").getter(GetDomainDetailResponse.getter(GetDomainDetailResponse::techPrivacy)).setter(GetDomainDetailResponse.setter(Builder::techPrivacy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TechPrivacy").build()}).build();
    private static final SdkField<String> REGISTRAR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrarName").getter(GetDomainDetailResponse.getter(GetDomainDetailResponse::registrarName)).setter(GetDomainDetailResponse.setter(Builder::registrarName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrarName").build()}).build();
    private static final SdkField<String> WHO_IS_SERVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WhoIsServer").getter(GetDomainDetailResponse.getter(GetDomainDetailResponse::whoIsServer)).setter(GetDomainDetailResponse.setter(Builder::whoIsServer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhoIsServer").build()}).build();
    private static final SdkField<String> REGISTRAR_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistrarUrl").getter(GetDomainDetailResponse.getter(GetDomainDetailResponse::registrarUrl)).setter(GetDomainDetailResponse.setter(Builder::registrarUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrarUrl").build()}).build();
    private static final SdkField<String> ABUSE_CONTACT_EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AbuseContactEmail").getter(GetDomainDetailResponse.getter(GetDomainDetailResponse::abuseContactEmail)).setter(GetDomainDetailResponse.setter(Builder::abuseContactEmail)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbuseContactEmail").build()}).build();
    private static final SdkField<String> ABUSE_CONTACT_PHONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AbuseContactPhone").getter(GetDomainDetailResponse.getter(GetDomainDetailResponse::abuseContactPhone)).setter(GetDomainDetailResponse.setter(Builder::abuseContactPhone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AbuseContactPhone").build()}).build();
    private static final SdkField<String> REGISTRY_DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RegistryDomainId").getter(GetDomainDetailResponse.getter(GetDomainDetailResponse::registryDomainId)).setter(GetDomainDetailResponse.setter(Builder::registryDomainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryDomainId").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(GetDomainDetailResponse.getter(GetDomainDetailResponse::creationDate)).setter(GetDomainDetailResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedDate").getter(GetDomainDetailResponse.getter(GetDomainDetailResponse::updatedDate)).setter(GetDomainDetailResponse.setter(Builder::updatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedDate").build()}).build();
    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpirationDate").getter(GetDomainDetailResponse.getter(GetDomainDetailResponse::expirationDate)).setter(GetDomainDetailResponse.setter(Builder::expirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build()}).build();
    private static final SdkField<String> RESELLER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reseller").getter(GetDomainDetailResponse.getter(GetDomainDetailResponse::reseller)).setter(GetDomainDetailResponse.setter(Builder::reseller)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reseller").build()}).build();
    private static final SdkField<String> DNS_SEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsSec").getter(GetDomainDetailResponse.getter(GetDomainDetailResponse::dnsSec)).setter(GetDomainDetailResponse.setter(Builder::dnsSec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsSec").build()}).build();
    private static final SdkField<List<String>> STATUS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StatusList").getter(GetDomainDetailResponse.getter(GetDomainDetailResponse::statusList)).setter(GetDomainDetailResponse.setter(Builder::statusList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, NAMESERVERS_FIELD, AUTO_RENEW_FIELD, ADMIN_CONTACT_FIELD, REGISTRANT_CONTACT_FIELD, TECH_CONTACT_FIELD, ADMIN_PRIVACY_FIELD, REGISTRANT_PRIVACY_FIELD, TECH_PRIVACY_FIELD, REGISTRAR_NAME_FIELD, WHO_IS_SERVER_FIELD, REGISTRAR_URL_FIELD, ABUSE_CONTACT_EMAIL_FIELD, ABUSE_CONTACT_PHONE_FIELD, REGISTRY_DOMAIN_ID_FIELD, CREATION_DATE_FIELD, UPDATED_DATE_FIELD, EXPIRATION_DATE_FIELD, RESELLER_FIELD, DNS_SEC_FIELD, STATUS_LIST_FIELD));
    private final String domainName;
    private final List<Nameserver> nameservers;
    private final Boolean autoRenew;
    private final ContactDetail adminContact;
    private final ContactDetail registrantContact;
    private final ContactDetail techContact;
    private final Boolean adminPrivacy;
    private final Boolean registrantPrivacy;
    private final Boolean techPrivacy;
    private final String registrarName;
    private final String whoIsServer;
    private final String registrarUrl;
    private final String abuseContactEmail;
    private final String abuseContactPhone;
    private final String registryDomainId;
    private final Instant creationDate;
    private final Instant updatedDate;
    private final Instant expirationDate;
    private final String reseller;
    private final String dnsSec;
    private final List<String> statusList;

    private GetDomainDetailResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.nameservers = builder.nameservers;
        this.autoRenew = builder.autoRenew;
        this.adminContact = builder.adminContact;
        this.registrantContact = builder.registrantContact;
        this.techContact = builder.techContact;
        this.adminPrivacy = builder.adminPrivacy;
        this.registrantPrivacy = builder.registrantPrivacy;
        this.techPrivacy = builder.techPrivacy;
        this.registrarName = builder.registrarName;
        this.whoIsServer = builder.whoIsServer;
        this.registrarUrl = builder.registrarUrl;
        this.abuseContactEmail = builder.abuseContactEmail;
        this.abuseContactPhone = builder.abuseContactPhone;
        this.registryDomainId = builder.registryDomainId;
        this.creationDate = builder.creationDate;
        this.updatedDate = builder.updatedDate;
        this.expirationDate = builder.expirationDate;
        this.reseller = builder.reseller;
        this.dnsSec = builder.dnsSec;
        this.statusList = builder.statusList;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final boolean hasNameservers() {
        return this.nameservers != null && !(this.nameservers instanceof SdkAutoConstructList);
    }

    public final List<Nameserver> nameservers() {
        return this.nameservers;
    }

    public final Boolean autoRenew() {
        return this.autoRenew;
    }

    public final ContactDetail adminContact() {
        return this.adminContact;
    }

    public final ContactDetail registrantContact() {
        return this.registrantContact;
    }

    public final ContactDetail techContact() {
        return this.techContact;
    }

    public final Boolean adminPrivacy() {
        return this.adminPrivacy;
    }

    public final Boolean registrantPrivacy() {
        return this.registrantPrivacy;
    }

    public final Boolean techPrivacy() {
        return this.techPrivacy;
    }

    public final String registrarName() {
        return this.registrarName;
    }

    public final String whoIsServer() {
        return this.whoIsServer;
    }

    public final String registrarUrl() {
        return this.registrarUrl;
    }

    public final String abuseContactEmail() {
        return this.abuseContactEmail;
    }

    public final String abuseContactPhone() {
        return this.abuseContactPhone;
    }

    public final String registryDomainId() {
        return this.registryDomainId;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant updatedDate() {
        return this.updatedDate;
    }

    public final Instant expirationDate() {
        return this.expirationDate;
    }

    public final String reseller() {
        return this.reseller;
    }

    public final String dnsSec() {
        return this.dnsSec;
    }

    public final boolean hasStatusList() {
        return this.statusList != null && !(this.statusList instanceof SdkAutoConstructList);
    }

    public final List<String> statusList() {
        return this.statusList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNameservers() ? this.nameservers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRenew());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrantContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.techContact());
        hashCode = 31 * hashCode + Objects.hashCode(this.adminPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrantPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(this.techPrivacy());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrarName());
        hashCode = 31 * hashCode + Objects.hashCode(this.whoIsServer());
        hashCode = 31 * hashCode + Objects.hashCode(this.registrarUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.abuseContactEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.abuseContactPhone());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.reseller());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsSec());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusList() ? this.statusList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDomainDetailResponse)) {
            return false;
        }
        GetDomainDetailResponse other = (GetDomainDetailResponse)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && this.hasNameservers() == other.hasNameservers() && Objects.equals(this.nameservers(), other.nameservers()) && Objects.equals(this.autoRenew(), other.autoRenew()) && Objects.equals(this.adminContact(), other.adminContact()) && Objects.equals(this.registrantContact(), other.registrantContact()) && Objects.equals(this.techContact(), other.techContact()) && Objects.equals(this.adminPrivacy(), other.adminPrivacy()) && Objects.equals(this.registrantPrivacy(), other.registrantPrivacy()) && Objects.equals(this.techPrivacy(), other.techPrivacy()) && Objects.equals(this.registrarName(), other.registrarName()) && Objects.equals(this.whoIsServer(), other.whoIsServer()) && Objects.equals(this.registrarUrl(), other.registrarUrl()) && Objects.equals(this.abuseContactEmail(), other.abuseContactEmail()) && Objects.equals(this.abuseContactPhone(), other.abuseContactPhone()) && Objects.equals(this.registryDomainId(), other.registryDomainId()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.updatedDate(), other.updatedDate()) && Objects.equals(this.expirationDate(), other.expirationDate()) && Objects.equals(this.reseller(), other.reseller()) && Objects.equals(this.dnsSec(), other.dnsSec()) && this.hasStatusList() == other.hasStatusList() && Objects.equals(this.statusList(), other.statusList());
    }

    public final String toString() {
        return ToString.builder((String)"GetDomainDetailResponse").add("DomainName", (Object)this.domainName()).add("Nameservers", this.hasNameservers() ? this.nameservers() : null).add("AutoRenew", (Object)this.autoRenew()).add("AdminContact", (Object)(this.adminContact() == null ? null : "*** Sensitive Data Redacted ***")).add("RegistrantContact", (Object)(this.registrantContact() == null ? null : "*** Sensitive Data Redacted ***")).add("TechContact", (Object)(this.techContact() == null ? null : "*** Sensitive Data Redacted ***")).add("AdminPrivacy", (Object)this.adminPrivacy()).add("RegistrantPrivacy", (Object)this.registrantPrivacy()).add("TechPrivacy", (Object)this.techPrivacy()).add("RegistrarName", (Object)this.registrarName()).add("WhoIsServer", (Object)this.whoIsServer()).add("RegistrarUrl", (Object)this.registrarUrl()).add("AbuseContactEmail", (Object)this.abuseContactEmail()).add("AbuseContactPhone", (Object)this.abuseContactPhone()).add("RegistryDomainId", (Object)this.registryDomainId()).add("CreationDate", (Object)this.creationDate()).add("UpdatedDate", (Object)this.updatedDate()).add("ExpirationDate", (Object)this.expirationDate()).add("Reseller", (Object)this.reseller()).add("DnsSec", (Object)this.dnsSec()).add("StatusList", this.hasStatusList() ? this.statusList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "Nameservers": {
                return Optional.ofNullable(clazz.cast(this.nameservers()));
            }
            case "AutoRenew": {
                return Optional.ofNullable(clazz.cast(this.autoRenew()));
            }
            case "AdminContact": {
                return Optional.ofNullable(clazz.cast(this.adminContact()));
            }
            case "RegistrantContact": {
                return Optional.ofNullable(clazz.cast(this.registrantContact()));
            }
            case "TechContact": {
                return Optional.ofNullable(clazz.cast(this.techContact()));
            }
            case "AdminPrivacy": {
                return Optional.ofNullable(clazz.cast(this.adminPrivacy()));
            }
            case "RegistrantPrivacy": {
                return Optional.ofNullable(clazz.cast(this.registrantPrivacy()));
            }
            case "TechPrivacy": {
                return Optional.ofNullable(clazz.cast(this.techPrivacy()));
            }
            case "RegistrarName": {
                return Optional.ofNullable(clazz.cast(this.registrarName()));
            }
            case "WhoIsServer": {
                return Optional.ofNullable(clazz.cast(this.whoIsServer()));
            }
            case "RegistrarUrl": {
                return Optional.ofNullable(clazz.cast(this.registrarUrl()));
            }
            case "AbuseContactEmail": {
                return Optional.ofNullable(clazz.cast(this.abuseContactEmail()));
            }
            case "AbuseContactPhone": {
                return Optional.ofNullable(clazz.cast(this.abuseContactPhone()));
            }
            case "RegistryDomainId": {
                return Optional.ofNullable(clazz.cast(this.registryDomainId()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "UpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.updatedDate()));
            }
            case "ExpirationDate": {
                return Optional.ofNullable(clazz.cast(this.expirationDate()));
            }
            case "Reseller": {
                return Optional.ofNullable(clazz.cast(this.reseller()));
            }
            case "DnsSec": {
                return Optional.ofNullable(clazz.cast(this.dnsSec()));
            }
            case "StatusList": {
                return Optional.ofNullable(clazz.cast(this.statusList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDomainDetailResponse, T> g) {
        return obj -> g.apply((GetDomainDetailResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsResponse.BuilderImpl
    implements Builder {
        private String domainName;
        private List<Nameserver> nameservers = DefaultSdkAutoConstructList.getInstance();
        private Boolean autoRenew;
        private ContactDetail adminContact;
        private ContactDetail registrantContact;
        private ContactDetail techContact;
        private Boolean adminPrivacy;
        private Boolean registrantPrivacy;
        private Boolean techPrivacy;
        private String registrarName;
        private String whoIsServer;
        private String registrarUrl;
        private String abuseContactEmail;
        private String abuseContactPhone;
        private String registryDomainId;
        private Instant creationDate;
        private Instant updatedDate;
        private Instant expirationDate;
        private String reseller;
        private String dnsSec;
        private List<String> statusList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDomainDetailResponse model) {
            super(model);
            this.domainName(model.domainName);
            this.nameservers(model.nameservers);
            this.autoRenew(model.autoRenew);
            this.adminContact(model.adminContact);
            this.registrantContact(model.registrantContact);
            this.techContact(model.techContact);
            this.adminPrivacy(model.adminPrivacy);
            this.registrantPrivacy(model.registrantPrivacy);
            this.techPrivacy(model.techPrivacy);
            this.registrarName(model.registrarName);
            this.whoIsServer(model.whoIsServer);
            this.registrarUrl(model.registrarUrl);
            this.abuseContactEmail(model.abuseContactEmail);
            this.abuseContactPhone(model.abuseContactPhone);
            this.registryDomainId(model.registryDomainId);
            this.creationDate(model.creationDate);
            this.updatedDate(model.updatedDate);
            this.expirationDate(model.expirationDate);
            this.reseller(model.reseller);
            this.dnsSec(model.dnsSec);
            this.statusList(model.statusList);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final List<Nameserver.Builder> getNameservers() {
            List<Nameserver.Builder> result = NameserverListCopier.copyToBuilder(this.nameservers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder nameservers(Collection<Nameserver> nameservers) {
            this.nameservers = NameserverListCopier.copy(nameservers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameservers(Nameserver ... nameservers) {
            this.nameservers(Arrays.asList(nameservers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameservers(Consumer<Nameserver.Builder> ... nameservers) {
            this.nameservers(Stream.of(nameservers).map(c -> (Nameserver)((Nameserver.Builder)Nameserver.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNameservers(Collection<Nameserver.BuilderImpl> nameservers) {
            this.nameservers = NameserverListCopier.copyFromBuilder(nameservers);
        }

        public final Boolean getAutoRenew() {
            return this.autoRenew;
        }

        @Override
        public final Builder autoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
            return this;
        }

        public final void setAutoRenew(Boolean autoRenew) {
            this.autoRenew = autoRenew;
        }

        public final ContactDetail.Builder getAdminContact() {
            return this.adminContact != null ? this.adminContact.toBuilder() : null;
        }

        @Override
        public final Builder adminContact(ContactDetail adminContact) {
            this.adminContact = adminContact;
            return this;
        }

        public final void setAdminContact(ContactDetail.BuilderImpl adminContact) {
            this.adminContact = adminContact != null ? adminContact.build() : null;
        }

        public final ContactDetail.Builder getRegistrantContact() {
            return this.registrantContact != null ? this.registrantContact.toBuilder() : null;
        }

        @Override
        public final Builder registrantContact(ContactDetail registrantContact) {
            this.registrantContact = registrantContact;
            return this;
        }

        public final void setRegistrantContact(ContactDetail.BuilderImpl registrantContact) {
            this.registrantContact = registrantContact != null ? registrantContact.build() : null;
        }

        public final ContactDetail.Builder getTechContact() {
            return this.techContact != null ? this.techContact.toBuilder() : null;
        }

        @Override
        public final Builder techContact(ContactDetail techContact) {
            this.techContact = techContact;
            return this;
        }

        public final void setTechContact(ContactDetail.BuilderImpl techContact) {
            this.techContact = techContact != null ? techContact.build() : null;
        }

        public final Boolean getAdminPrivacy() {
            return this.adminPrivacy;
        }

        @Override
        public final Builder adminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
            return this;
        }

        public final void setAdminPrivacy(Boolean adminPrivacy) {
            this.adminPrivacy = adminPrivacy;
        }

        public final Boolean getRegistrantPrivacy() {
            return this.registrantPrivacy;
        }

        @Override
        public final Builder registrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
            return this;
        }

        public final void setRegistrantPrivacy(Boolean registrantPrivacy) {
            this.registrantPrivacy = registrantPrivacy;
        }

        public final Boolean getTechPrivacy() {
            return this.techPrivacy;
        }

        @Override
        public final Builder techPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
            return this;
        }

        public final void setTechPrivacy(Boolean techPrivacy) {
            this.techPrivacy = techPrivacy;
        }

        public final String getRegistrarName() {
            return this.registrarName;
        }

        @Override
        public final Builder registrarName(String registrarName) {
            this.registrarName = registrarName;
            return this;
        }

        public final void setRegistrarName(String registrarName) {
            this.registrarName = registrarName;
        }

        public final String getWhoIsServer() {
            return this.whoIsServer;
        }

        @Override
        public final Builder whoIsServer(String whoIsServer) {
            this.whoIsServer = whoIsServer;
            return this;
        }

        public final void setWhoIsServer(String whoIsServer) {
            this.whoIsServer = whoIsServer;
        }

        public final String getRegistrarUrl() {
            return this.registrarUrl;
        }

        @Override
        public final Builder registrarUrl(String registrarUrl) {
            this.registrarUrl = registrarUrl;
            return this;
        }

        public final void setRegistrarUrl(String registrarUrl) {
            this.registrarUrl = registrarUrl;
        }

        public final String getAbuseContactEmail() {
            return this.abuseContactEmail;
        }

        @Override
        public final Builder abuseContactEmail(String abuseContactEmail) {
            this.abuseContactEmail = abuseContactEmail;
            return this;
        }

        public final void setAbuseContactEmail(String abuseContactEmail) {
            this.abuseContactEmail = abuseContactEmail;
        }

        public final String getAbuseContactPhone() {
            return this.abuseContactPhone;
        }

        @Override
        public final Builder abuseContactPhone(String abuseContactPhone) {
            this.abuseContactPhone = abuseContactPhone;
            return this;
        }

        public final void setAbuseContactPhone(String abuseContactPhone) {
            this.abuseContactPhone = abuseContactPhone;
        }

        public final String getRegistryDomainId() {
            return this.registryDomainId;
        }

        @Override
        public final Builder registryDomainId(String registryDomainId) {
            this.registryDomainId = registryDomainId;
            return this;
        }

        public final void setRegistryDomainId(String registryDomainId) {
            this.registryDomainId = registryDomainId;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getUpdatedDate() {
            return this.updatedDate;
        }

        @Override
        public final Builder updatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
            return this;
        }

        public final void setUpdatedDate(Instant updatedDate) {
            this.updatedDate = updatedDate;
        }

        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        public final String getReseller() {
            return this.reseller;
        }

        @Override
        public final Builder reseller(String reseller) {
            this.reseller = reseller;
            return this;
        }

        public final void setReseller(String reseller) {
            this.reseller = reseller;
        }

        public final String getDnsSec() {
            return this.dnsSec;
        }

        @Override
        public final Builder dnsSec(String dnsSec) {
            this.dnsSec = dnsSec;
            return this;
        }

        public final void setDnsSec(String dnsSec) {
            this.dnsSec = dnsSec;
        }

        public final Collection<String> getStatusList() {
            if (this.statusList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statusList;
        }

        @Override
        public final Builder statusList(Collection<String> statusList) {
            this.statusList = DomainStatusListCopier.copy(statusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusList(String ... statusList) {
            this.statusList(Arrays.asList(statusList));
            return this;
        }

        public final void setStatusList(Collection<String> statusList) {
            this.statusList = DomainStatusListCopier.copy(statusList);
        }

        @Override
        public GetDomainDetailResponse build() {
            return new GetDomainDetailResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53DomainsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDomainDetailResponse> {
        public Builder domainName(String var1);

        public Builder nameservers(Collection<Nameserver> var1);

        public Builder nameservers(Nameserver ... var1);

        public Builder nameservers(Consumer<Nameserver.Builder> ... var1);

        public Builder autoRenew(Boolean var1);

        public Builder adminContact(ContactDetail var1);

        default public Builder adminContact(Consumer<ContactDetail.Builder> adminContact) {
            return this.adminContact((ContactDetail)((ContactDetail.Builder)ContactDetail.builder().applyMutation(adminContact)).build());
        }

        public Builder registrantContact(ContactDetail var1);

        default public Builder registrantContact(Consumer<ContactDetail.Builder> registrantContact) {
            return this.registrantContact((ContactDetail)((ContactDetail.Builder)ContactDetail.builder().applyMutation(registrantContact)).build());
        }

        public Builder techContact(ContactDetail var1);

        default public Builder techContact(Consumer<ContactDetail.Builder> techContact) {
            return this.techContact((ContactDetail)((ContactDetail.Builder)ContactDetail.builder().applyMutation(techContact)).build());
        }

        public Builder adminPrivacy(Boolean var1);

        public Builder registrantPrivacy(Boolean var1);

        public Builder techPrivacy(Boolean var1);

        public Builder registrarName(String var1);

        public Builder whoIsServer(String var1);

        public Builder registrarUrl(String var1);

        public Builder abuseContactEmail(String var1);

        public Builder abuseContactPhone(String var1);

        public Builder registryDomainId(String var1);

        public Builder creationDate(Instant var1);

        public Builder updatedDate(Instant var1);

        public Builder expirationDate(Instant var1);

        public Builder reseller(String var1);

        public Builder dnsSec(String var1);

        public Builder statusList(Collection<String> var1);

        public Builder statusList(String ... var1);
    }
}

