/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PriceWithCurrency
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PriceWithCurrency> {
    private static final SdkField<Double> PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Price").getter(PriceWithCurrency.getter(PriceWithCurrency::price)).setter(PriceWithCurrency.setter(Builder::price)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Price").build()}).build();
    private static final SdkField<String> CURRENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Currency").getter(PriceWithCurrency.getter(PriceWithCurrency::currency)).setter(PriceWithCurrency.setter(Builder::currency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Currency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRICE_FIELD, CURRENCY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double price;
    private final String currency;

    private PriceWithCurrency(BuilderImpl builder) {
        this.price = builder.price;
        this.currency = builder.currency;
    }

    public final Double price() {
        return this.price;
    }

    public final String currency() {
        return this.currency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.price());
        hashCode = 31 * hashCode + Objects.hashCode(this.currency());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PriceWithCurrency)) {
            return false;
        }
        PriceWithCurrency other = (PriceWithCurrency)obj;
        return Objects.equals(this.price(), other.price()) && Objects.equals(this.currency(), other.currency());
    }

    public final String toString() {
        return ToString.builder((String)"PriceWithCurrency").add("Price", (Object)this.price()).add("Currency", (Object)this.currency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Price": {
                return Optional.ofNullable(clazz.cast(this.price()));
            }
            case "Currency": {
                return Optional.ofNullable(clazz.cast(this.currency()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PriceWithCurrency, T> g) {
        return obj -> g.apply((PriceWithCurrency)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double price;
        private String currency;

        private BuilderImpl() {
        }

        private BuilderImpl(PriceWithCurrency model) {
            this.price(model.price);
            this.currency(model.currency);
        }

        public final Double getPrice() {
            return this.price;
        }

        public final void setPrice(Double price) {
            this.price = price;
        }

        @Override
        @Transient
        public final Builder price(Double price) {
            this.price = price;
            return this;
        }

        public final String getCurrency() {
            return this.currency;
        }

        public final void setCurrency(String currency) {
            this.currency = currency;
        }

        @Override
        @Transient
        public final Builder currency(String currency) {
            this.currency = currency;
            return this;
        }

        public PriceWithCurrency build() {
            return new PriceWithCurrency(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PriceWithCurrency> {
        public Builder price(Double var1);

        public Builder currency(String var1);
    }
}

