/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53domains.model.DomainSummary;
import software.amazon.awssdk.services.route53domains.model.DomainSummaryListCopier;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDomainsResponse
extends Route53DomainsResponse
implements ToCopyableBuilder<Builder, ListDomainsResponse> {
    private static final SdkField<List<DomainSummary>> DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Domains").getter(ListDomainsResponse.getter(ListDomainsResponse::domains)).setter(ListDomainsResponse.setter(Builder::domains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageMarker").getter(ListDomainsResponse.getter(ListDomainsResponse::nextPageMarker)).setter(ListDomainsResponse.setter(Builder::nextPageMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageMarker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAINS_FIELD, NEXT_PAGE_MARKER_FIELD));
    private final List<DomainSummary> domains;
    private final String nextPageMarker;

    private ListDomainsResponse(BuilderImpl builder) {
        super(builder);
        this.domains = builder.domains;
        this.nextPageMarker = builder.nextPageMarker;
    }

    public boolean hasDomains() {
        return this.domains != null && !(this.domains instanceof SdkAutoConstructList);
    }

    public List<DomainSummary> domains() {
        return this.domains;
    }

    public String nextPageMarker() {
        return this.nextPageMarker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domains());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageMarker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainsResponse)) {
            return false;
        }
        ListDomainsResponse other = (ListDomainsResponse)((Object)obj);
        return Objects.equals(this.domains(), other.domains()) && Objects.equals(this.nextPageMarker(), other.nextPageMarker());
    }

    public String toString() {
        return ToString.builder((String)"ListDomainsResponse").add("Domains", this.domains()).add("NextPageMarker", (Object)this.nextPageMarker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Domains": {
                return Optional.ofNullable(clazz.cast(this.domains()));
            }
            case "NextPageMarker": {
                return Optional.ofNullable(clazz.cast(this.nextPageMarker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainsResponse, T> g) {
        return obj -> g.apply((ListDomainsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsResponse.BuilderImpl
    implements Builder {
        private List<DomainSummary> domains = DefaultSdkAutoConstructList.getInstance();
        private String nextPageMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainsResponse model) {
            super(model);
            this.domains(model.domains);
            this.nextPageMarker(model.nextPageMarker);
        }

        public final Collection<DomainSummary.Builder> getDomains() {
            return this.domains != null ? (Collection)this.domains.stream().map(DomainSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domains(Collection<DomainSummary> domains) {
            this.domains = DomainSummaryListCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(DomainSummary ... domains) {
            this.domains(Arrays.asList(domains));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(Consumer<DomainSummary.Builder> ... domains) {
            this.domains(Stream.of(domains).map(c -> (DomainSummary)((DomainSummary.Builder)DomainSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomains(Collection<DomainSummary.BuilderImpl> domains) {
            this.domains = DomainSummaryListCopier.copyFromBuilder(domains);
        }

        public final String getNextPageMarker() {
            return this.nextPageMarker;
        }

        @Override
        public final Builder nextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
            return this;
        }

        public final void setNextPageMarker(String nextPageMarker) {
            this.nextPageMarker = nextPageMarker;
        }

        @Override
        public ListDomainsResponse build() {
            return new ListDomainsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53DomainsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDomainsResponse> {
        public Builder domains(Collection<DomainSummary> var1);

        public Builder domains(DomainSummary ... var1);

        public Builder domains(Consumer<DomainSummary.Builder> ... var1);

        public Builder nextPageMarker(String var1);
    }
}

