/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53domains.model.OperationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BillingRecord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BillingRecord> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(BillingRecord.getter(BillingRecord::domainName)).setter(BillingRecord.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operation").getter(BillingRecord.getter(BillingRecord::operationAsString)).setter(BillingRecord.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()}).build();
    private static final SdkField<String> INVOICE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InvoiceId").getter(BillingRecord.getter(BillingRecord::invoiceId)).setter(BillingRecord.setter(Builder::invoiceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvoiceId").build()}).build();
    private static final SdkField<Instant> BILL_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("BillDate").getter(BillingRecord.getter(BillingRecord::billDate)).setter(BillingRecord.setter(Builder::billDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillDate").build()}).build();
    private static final SdkField<Double> PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("Price").getter(BillingRecord.getter(BillingRecord::price)).setter(BillingRecord.setter(Builder::price)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Price").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, OPERATION_FIELD, INVOICE_ID_FIELD, BILL_DATE_FIELD, PRICE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainName;
    private final String operation;
    private final String invoiceId;
    private final Instant billDate;
    private final Double price;

    private BillingRecord(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.operation = builder.operation;
        this.invoiceId = builder.invoiceId;
        this.billDate = builder.billDate;
        this.price = builder.price;
    }

    public String domainName() {
        return this.domainName;
    }

    public OperationType operation() {
        return OperationType.fromValue(this.operation);
    }

    public String operationAsString() {
        return this.operation;
    }

    public String invoiceId() {
        return this.invoiceId;
    }

    public Instant billDate() {
        return this.billDate;
    }

    public Double price() {
        return this.price;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.invoiceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.billDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.price());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingRecord)) {
            return false;
        }
        BillingRecord other = (BillingRecord)obj;
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.operationAsString(), other.operationAsString()) && Objects.equals(this.invoiceId(), other.invoiceId()) && Objects.equals(this.billDate(), other.billDate()) && Objects.equals(this.price(), other.price());
    }

    public String toString() {
        return ToString.builder((String)"BillingRecord").add("DomainName", (Object)this.domainName()).add("Operation", (Object)this.operationAsString()).add("InvoiceId", (Object)this.invoiceId()).add("BillDate", (Object)this.billDate()).add("Price", (Object)this.price()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "Operation": {
                return Optional.ofNullable(clazz.cast(this.operationAsString()));
            }
            case "InvoiceId": {
                return Optional.ofNullable(clazz.cast(this.invoiceId()));
            }
            case "BillDate": {
                return Optional.ofNullable(clazz.cast(this.billDate()));
            }
            case "Price": {
                return Optional.ofNullable(clazz.cast(this.price()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BillingRecord, T> g) {
        return obj -> g.apply((BillingRecord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String operation;
        private String invoiceId;
        private Instant billDate;
        private Double price;

        private BuilderImpl() {
        }

        private BuilderImpl(BillingRecord model) {
            this.domainName(model.domainName);
            this.operation(model.operation);
            this.invoiceId(model.invoiceId);
            this.billDate(model.billDate);
            this.price(model.price);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getOperation() {
            return this.operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(OperationType operation) {
            this.operation(operation == null ? null : operation.toString());
            return this;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        public final String getInvoiceId() {
            return this.invoiceId;
        }

        @Override
        public final Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        public final void setInvoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
        }

        public final Instant getBillDate() {
            return this.billDate;
        }

        @Override
        public final Builder billDate(Instant billDate) {
            this.billDate = billDate;
            return this;
        }

        public final void setBillDate(Instant billDate) {
            this.billDate = billDate;
        }

        public final Double getPrice() {
            return this.price;
        }

        @Override
        public final Builder price(Double price) {
            this.price = price;
            return this;
        }

        public final void setPrice(Double price) {
            this.price = price;
        }

        public BillingRecord build() {
            return new BillingRecord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BillingRecord> {
        public Builder domainName(String var1);

        public Builder operation(String var1);

        public Builder operation(OperationType var1);

        public Builder invoiceId(String var1);

        public Builder billDate(Instant var1);

        public Builder price(Double var1);
    }
}

