/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53domains.model.GlueIpListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Nameserver
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Nameserver> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Nameserver.getter(Nameserver::name)).setter(Nameserver.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> GLUE_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GlueIps").getter(Nameserver.getter(Nameserver::glueIps)).setter(Nameserver.setter(Builder::glueIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlueIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, GLUE_IPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> glueIps;

    private Nameserver(BuilderImpl builder) {
        this.name = builder.name;
        this.glueIps = builder.glueIps;
    }

    public String name() {
        return this.name;
    }

    public boolean hasGlueIps() {
        return this.glueIps != null && !(this.glueIps instanceof SdkAutoConstructList);
    }

    public List<String> glueIps() {
        return this.glueIps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.glueIps());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Nameserver)) {
            return false;
        }
        Nameserver other = (Nameserver)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.glueIps(), other.glueIps());
    }

    public String toString() {
        return ToString.builder((String)"Nameserver").add("Name", (Object)this.name()).add("GlueIps", this.glueIps()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "GlueIps": {
                return Optional.ofNullable(clazz.cast(this.glueIps()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Nameserver, T> g) {
        return obj -> g.apply((Nameserver)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> glueIps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Nameserver model) {
            this.name(model.name);
            this.glueIps(model.glueIps);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getGlueIps() {
            return this.glueIps;
        }

        @Override
        public final Builder glueIps(Collection<String> glueIps) {
            this.glueIps = GlueIpListCopier.copy(glueIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glueIps(String ... glueIps) {
            this.glueIps(Arrays.asList(glueIps));
            return this;
        }

        public final void setGlueIps(Collection<String> glueIps) {
            this.glueIps = GlueIpListCopier.copy(glueIps);
        }

        public Nameserver build() {
            return new Nameserver(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Nameserver> {
        public Builder name(String var1);

        public Builder glueIps(Collection<String> var1);

        public Builder glueIps(String ... var1);
    }
}

