/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53domains.Route53DomainsAsyncClient;
import software.amazon.awssdk.services.route53domains.model.DomainSummary;
import software.amazon.awssdk.services.route53domains.model.ListDomainsRequest;
import software.amazon.awssdk.services.route53domains.model.ListDomainsResponse;

public class ListDomainsPublisher
implements SdkPublisher<ListDomainsResponse> {
    private final Route53DomainsAsyncClient client;
    private final ListDomainsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDomainsPublisher(Route53DomainsAsyncClient client, ListDomainsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDomainsPublisher(Route53DomainsAsyncClient client, ListDomainsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDomainsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDomainsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DomainSummary> domains() {
        Function<ListDomainsResponse, Iterator> getIterator = response -> {
            if (response != null && response.domains() != null) {
                return response.domains().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDomainsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDomainsResponseFetcher
    implements AsyncPageFetcher<ListDomainsResponse> {
        private ListDomainsResponseFetcher() {
        }

        public boolean hasNextPage(ListDomainsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageMarker());
        }

        public CompletableFuture<ListDomainsResponse> nextPage(ListDomainsResponse previousPage) {
            if (previousPage == null) {
                return ListDomainsPublisher.this.client.listDomains(ListDomainsPublisher.this.firstRequest);
            }
            return ListDomainsPublisher.this.client.listDomains((ListDomainsRequest)((Object)ListDomainsPublisher.this.firstRequest.toBuilder().marker(previousPage.nextPageMarker()).build()));
        }
    }
}

