/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53domains.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53domains.model.Route53DomainsRequest;
import software.amazon.awssdk.services.route53domains.model.Tag;
import software.amazon.awssdk.services.route53domains.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTagsForDomainRequest
extends Route53DomainsRequest
implements ToCopyableBuilder<Builder, UpdateTagsForDomainRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateTagsForDomainRequest.getter(UpdateTagsForDomainRequest::domainName)).setter(UpdateTagsForDomainRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_TO_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateTagsForDomainRequest.getter(UpdateTagsForDomainRequest::tagsToUpdate)).setter(UpdateTagsForDomainRequest.setter(Builder::tagsToUpdate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagsToUpdate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, TAGS_TO_UPDATE_FIELD));
    private final String domainName;
    private final List<Tag> tagsToUpdate;

    private UpdateTagsForDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.tagsToUpdate = builder.tagsToUpdate;
    }

    public String domainName() {
        return this.domainName;
    }

    public boolean hasTagsToUpdate() {
        return this.tagsToUpdate != null && !(this.tagsToUpdate instanceof SdkAutoConstructList);
    }

    public List<Tag> tagsToUpdate() {
        return this.tagsToUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagsToUpdate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTagsForDomainRequest)) {
            return false;
        }
        UpdateTagsForDomainRequest other = (UpdateTagsForDomainRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.tagsToUpdate(), other.tagsToUpdate());
    }

    public String toString() {
        return ToString.builder((String)"UpdateTagsForDomainRequest").add("DomainName", (Object)this.domainName()).add("TagsToUpdate", this.tagsToUpdate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "TagsToUpdate": {
                return Optional.ofNullable(clazz.cast(this.tagsToUpdate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTagsForDomainRequest, T> g) {
        return obj -> g.apply((UpdateTagsForDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53DomainsRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private List<Tag> tagsToUpdate = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTagsForDomainRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.tagsToUpdate(model.tagsToUpdate);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<Tag.Builder> getTagsToUpdate() {
            return this.tagsToUpdate != null ? (Collection)this.tagsToUpdate.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagsToUpdate(Collection<Tag> tagsToUpdate) {
            this.tagsToUpdate = TagListCopier.copy(tagsToUpdate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToUpdate(Tag ... tagsToUpdate) {
            this.tagsToUpdate(Arrays.asList(tagsToUpdate));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToUpdate(Consumer<Tag.Builder> ... tagsToUpdate) {
            this.tagsToUpdate(Stream.of(tagsToUpdate).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagsToUpdate(Collection<Tag.BuilderImpl> tagsToUpdate) {
            this.tagsToUpdate = TagListCopier.copyFromBuilder(tagsToUpdate);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTagsForDomainRequest build() {
            return new UpdateTagsForDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53DomainsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTagsForDomainRequest> {
        public Builder domainName(String var1);

        public Builder tagsToUpdate(Collection<Tag> var1);

        public Builder tagsToUpdate(Tag ... var1);

        public Builder tagsToUpdate(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

