/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestDnsAnswerRequest
extends Route53Request
implements ToCopyableBuilder<Builder, TestDnsAnswerRequest> {
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TestDnsAnswerRequest.getter(TestDnsAnswerRequest::hostedZoneId)).setter(TestDnsAnswerRequest.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("hostedzoneid").unmarshallLocationName("hostedzoneid").build()}).build();
    private static final SdkField<String> RECORD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TestDnsAnswerRequest.getter(TestDnsAnswerRequest::recordName)).setter(TestDnsAnswerRequest.setter(Builder::recordName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("recordname").unmarshallLocationName("recordname").build()}).build();
    private static final SdkField<String> RECORD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TestDnsAnswerRequest.getter(TestDnsAnswerRequest::recordTypeAsString)).setter(TestDnsAnswerRequest.setter(Builder::recordType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("recordtype").unmarshallLocationName("recordtype").build()}).build();
    private static final SdkField<String> RESOLVER_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TestDnsAnswerRequest.getter(TestDnsAnswerRequest::resolverIP)).setter(TestDnsAnswerRequest.setter(Builder::resolverIP)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resolverip").unmarshallLocationName("resolverip").build()}).build();
    private static final SdkField<String> EDNS0_CLIENT_SUBNET_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TestDnsAnswerRequest.getter(TestDnsAnswerRequest::edns0ClientSubnetIP)).setter(TestDnsAnswerRequest.setter(Builder::edns0ClientSubnetIP)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("edns0clientsubnetip").unmarshallLocationName("edns0clientsubnetip").build()}).build();
    private static final SdkField<String> EDNS0_CLIENT_SUBNET_MASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TestDnsAnswerRequest.getter(TestDnsAnswerRequest::edns0ClientSubnetMask)).setter(TestDnsAnswerRequest.setter(Builder::edns0ClientSubnetMask)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("edns0clientsubnetmask").unmarshallLocationName("edns0clientsubnetmask").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_ID_FIELD, RECORD_NAME_FIELD, RECORD_TYPE_FIELD, RESOLVER_IP_FIELD, EDNS0_CLIENT_SUBNET_IP_FIELD, EDNS0_CLIENT_SUBNET_MASK_FIELD));
    private final String hostedZoneId;
    private final String recordName;
    private final String recordType;
    private final String resolverIP;
    private final String edns0ClientSubnetIP;
    private final String edns0ClientSubnetMask;

    private TestDnsAnswerRequest(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.recordName = builder.recordName;
        this.recordType = builder.recordType;
        this.resolverIP = builder.resolverIP;
        this.edns0ClientSubnetIP = builder.edns0ClientSubnetIP;
        this.edns0ClientSubnetMask = builder.edns0ClientSubnetMask;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public String recordName() {
        return this.recordName;
    }

    public RRType recordType() {
        return RRType.fromValue(this.recordType);
    }

    public String recordTypeAsString() {
        return this.recordType;
    }

    public String resolverIP() {
        return this.resolverIP;
    }

    public String edns0ClientSubnetIP() {
        return this.edns0ClientSubnetIP;
    }

    public String edns0ClientSubnetMask() {
        return this.edns0ClientSubnetMask;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolverIP());
        hashCode = 31 * hashCode + Objects.hashCode(this.edns0ClientSubnetIP());
        hashCode = 31 * hashCode + Objects.hashCode(this.edns0ClientSubnetMask());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestDnsAnswerRequest)) {
            return false;
        }
        TestDnsAnswerRequest other = (TestDnsAnswerRequest)((Object)obj);
        return Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.recordName(), other.recordName()) && Objects.equals(this.recordTypeAsString(), other.recordTypeAsString()) && Objects.equals(this.resolverIP(), other.resolverIP()) && Objects.equals(this.edns0ClientSubnetIP(), other.edns0ClientSubnetIP()) && Objects.equals(this.edns0ClientSubnetMask(), other.edns0ClientSubnetMask());
    }

    public String toString() {
        return ToString.builder((String)"TestDnsAnswerRequest").add("HostedZoneId", (Object)this.hostedZoneId()).add("RecordName", (Object)this.recordName()).add("RecordType", (Object)this.recordTypeAsString()).add("ResolverIP", (Object)this.resolverIP()).add("EDNS0ClientSubnetIP", (Object)this.edns0ClientSubnetIP()).add("EDNS0ClientSubnetMask", (Object)this.edns0ClientSubnetMask()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "RecordName": {
                return Optional.ofNullable(clazz.cast(this.recordName()));
            }
            case "RecordType": {
                return Optional.ofNullable(clazz.cast(this.recordTypeAsString()));
            }
            case "ResolverIP": {
                return Optional.ofNullable(clazz.cast(this.resolverIP()));
            }
            case "EDNS0ClientSubnetIP": {
                return Optional.ofNullable(clazz.cast(this.edns0ClientSubnetIP()));
            }
            case "EDNS0ClientSubnetMask": {
                return Optional.ofNullable(clazz.cast(this.edns0ClientSubnetMask()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestDnsAnswerRequest, T> g) {
        return obj -> g.apply((TestDnsAnswerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String hostedZoneId;
        private String recordName;
        private String recordType;
        private String resolverIP;
        private String edns0ClientSubnetIP;
        private String edns0ClientSubnetMask;

        private BuilderImpl() {
        }

        private BuilderImpl(TestDnsAnswerRequest model) {
            super(model);
            this.hostedZoneId(model.hostedZoneId);
            this.recordName(model.recordName);
            this.recordType(model.recordType);
            this.resolverIP(model.resolverIP);
            this.edns0ClientSubnetIP(model.edns0ClientSubnetIP);
            this.edns0ClientSubnetMask(model.edns0ClientSubnetMask);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getRecordName() {
            return this.recordName;
        }

        @Override
        public final Builder recordName(String recordName) {
            this.recordName = recordName;
            return this;
        }

        public final void setRecordName(String recordName) {
            this.recordName = recordName;
        }

        public final String getRecordTypeAsString() {
            return this.recordType;
        }

        @Override
        public final Builder recordType(String recordType) {
            this.recordType = recordType;
            return this;
        }

        @Override
        public final Builder recordType(RRType recordType) {
            this.recordType(recordType.toString());
            return this;
        }

        public final void setRecordType(String recordType) {
            this.recordType = recordType;
        }

        public final String getResolverIP() {
            return this.resolverIP;
        }

        @Override
        public final Builder resolverIP(String resolverIP) {
            this.resolverIP = resolverIP;
            return this;
        }

        public final void setResolverIP(String resolverIP) {
            this.resolverIP = resolverIP;
        }

        public final String getEdns0ClientSubnetIP() {
            return this.edns0ClientSubnetIP;
        }

        @Override
        public final Builder edns0ClientSubnetIP(String edns0ClientSubnetIP) {
            this.edns0ClientSubnetIP = edns0ClientSubnetIP;
            return this;
        }

        public final void setEdns0ClientSubnetIP(String edns0ClientSubnetIP) {
            this.edns0ClientSubnetIP = edns0ClientSubnetIP;
        }

        public final String getEdns0ClientSubnetMask() {
            return this.edns0ClientSubnetMask;
        }

        @Override
        public final Builder edns0ClientSubnetMask(String edns0ClientSubnetMask) {
            this.edns0ClientSubnetMask = edns0ClientSubnetMask;
            return this;
        }

        public final void setEdns0ClientSubnetMask(String edns0ClientSubnetMask) {
            this.edns0ClientSubnetMask = edns0ClientSubnetMask;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestDnsAnswerRequest build() {
            return new TestDnsAnswerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestDnsAnswerRequest> {
        public Builder hostedZoneId(String var1);

        public Builder recordName(String var1);

        public Builder recordType(String var1);

        public Builder recordType(RRType var1);

        public Builder resolverIP(String var1);

        public Builder edns0ClientSubnetIP(String var1);

        public Builder edns0ClientSubnetMask(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

