/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.services.route53.model.TrafficPolicyInstance;
import software.amazon.awssdk.services.route53.model.TrafficPolicyInstancesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrafficPolicyInstancesResponse
extends Route53Response
implements ToCopyableBuilder<Builder, ListTrafficPolicyInstancesResponse> {
    private static final SdkField<List<TrafficPolicyInstance>> TRAFFIC_POLICY_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListTrafficPolicyInstancesResponse.getter(ListTrafficPolicyInstancesResponse::trafficPolicyInstances)).setter(ListTrafficPolicyInstancesResponse.setter(Builder::trafficPolicyInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyInstances").unmarshallLocationName("TrafficPolicyInstances").build(), ListTrait.builder().memberLocationName("TrafficPolicyInstance").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrafficPolicyInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyInstance").unmarshallLocationName("TrafficPolicyInstance").build()}).build()).build()}).build();
    private static final SdkField<String> HOSTED_ZONE_ID_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListTrafficPolicyInstancesResponse.getter(ListTrafficPolicyInstancesResponse::hostedZoneIdMarker)).setter(ListTrafficPolicyInstancesResponse.setter(Builder::hostedZoneIdMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneIdMarker").unmarshallLocationName("HostedZoneIdMarker").build()}).build();
    private static final SdkField<String> TRAFFIC_POLICY_INSTANCE_NAME_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListTrafficPolicyInstancesResponse.getter(ListTrafficPolicyInstancesResponse::trafficPolicyInstanceNameMarker)).setter(ListTrafficPolicyInstancesResponse.setter(Builder::trafficPolicyInstanceNameMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyInstanceNameMarker").unmarshallLocationName("TrafficPolicyInstanceNameMarker").build()}).build();
    private static final SdkField<String> TRAFFIC_POLICY_INSTANCE_TYPE_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListTrafficPolicyInstancesResponse.getter(ListTrafficPolicyInstancesResponse::trafficPolicyInstanceTypeMarkerAsString)).setter(ListTrafficPolicyInstancesResponse.setter(Builder::trafficPolicyInstanceTypeMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyInstanceTypeMarker").unmarshallLocationName("TrafficPolicyInstanceTypeMarker").build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ListTrafficPolicyInstancesResponse.getter(ListTrafficPolicyInstancesResponse::isTruncated)).setter(ListTrafficPolicyInstancesResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").unmarshallLocationName("IsTruncated").build()}).build();
    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListTrafficPolicyInstancesResponse.getter(ListTrafficPolicyInstancesResponse::maxItems)).setter(ListTrafficPolicyInstancesResponse.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").unmarshallLocationName("MaxItems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_POLICY_INSTANCES_FIELD, HOSTED_ZONE_ID_MARKER_FIELD, TRAFFIC_POLICY_INSTANCE_NAME_MARKER_FIELD, TRAFFIC_POLICY_INSTANCE_TYPE_MARKER_FIELD, IS_TRUNCATED_FIELD, MAX_ITEMS_FIELD));
    private final List<TrafficPolicyInstance> trafficPolicyInstances;
    private final String hostedZoneIdMarker;
    private final String trafficPolicyInstanceNameMarker;
    private final String trafficPolicyInstanceTypeMarker;
    private final Boolean isTruncated;
    private final String maxItems;

    private ListTrafficPolicyInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.trafficPolicyInstances = builder.trafficPolicyInstances;
        this.hostedZoneIdMarker = builder.hostedZoneIdMarker;
        this.trafficPolicyInstanceNameMarker = builder.trafficPolicyInstanceNameMarker;
        this.trafficPolicyInstanceTypeMarker = builder.trafficPolicyInstanceTypeMarker;
        this.isTruncated = builder.isTruncated;
        this.maxItems = builder.maxItems;
    }

    public List<TrafficPolicyInstance> trafficPolicyInstances() {
        return this.trafficPolicyInstances;
    }

    public String hostedZoneIdMarker() {
        return this.hostedZoneIdMarker;
    }

    public String trafficPolicyInstanceNameMarker() {
        return this.trafficPolicyInstanceNameMarker;
    }

    public RRType trafficPolicyInstanceTypeMarker() {
        return RRType.fromValue(this.trafficPolicyInstanceTypeMarker);
    }

    public String trafficPolicyInstanceTypeMarkerAsString() {
        return this.trafficPolicyInstanceTypeMarker;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneIdMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyInstanceNameMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyInstanceTypeMarkerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPolicyInstancesResponse)) {
            return false;
        }
        ListTrafficPolicyInstancesResponse other = (ListTrafficPolicyInstancesResponse)((Object)obj);
        return Objects.equals(this.trafficPolicyInstances(), other.trafficPolicyInstances()) && Objects.equals(this.hostedZoneIdMarker(), other.hostedZoneIdMarker()) && Objects.equals(this.trafficPolicyInstanceNameMarker(), other.trafficPolicyInstanceNameMarker()) && Objects.equals(this.trafficPolicyInstanceTypeMarkerAsString(), other.trafficPolicyInstanceTypeMarkerAsString()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        return ToString.builder((String)"ListTrafficPolicyInstancesResponse").add("TrafficPolicyInstances", this.trafficPolicyInstances()).add("HostedZoneIdMarker", (Object)this.hostedZoneIdMarker()).add("TrafficPolicyInstanceNameMarker", (Object)this.trafficPolicyInstanceNameMarker()).add("TrafficPolicyInstanceTypeMarker", (Object)this.trafficPolicyInstanceTypeMarkerAsString()).add("IsTruncated", (Object)this.isTruncated()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficPolicyInstances": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyInstances()));
            }
            case "HostedZoneIdMarker": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneIdMarker()));
            }
            case "TrafficPolicyInstanceNameMarker": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyInstanceNameMarker()));
            }
            case "TrafficPolicyInstanceTypeMarker": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyInstanceTypeMarkerAsString()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrafficPolicyInstancesResponse, T> g) {
        return obj -> g.apply((ListTrafficPolicyInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private List<TrafficPolicyInstance> trafficPolicyInstances = DefaultSdkAutoConstructList.getInstance();
        private String hostedZoneIdMarker;
        private String trafficPolicyInstanceNameMarker;
        private String trafficPolicyInstanceTypeMarker;
        private Boolean isTruncated;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPolicyInstancesResponse model) {
            super(model);
            this.trafficPolicyInstances(model.trafficPolicyInstances);
            this.hostedZoneIdMarker(model.hostedZoneIdMarker);
            this.trafficPolicyInstanceNameMarker(model.trafficPolicyInstanceNameMarker);
            this.trafficPolicyInstanceTypeMarker(model.trafficPolicyInstanceTypeMarker);
            this.isTruncated(model.isTruncated);
            this.maxItems(model.maxItems);
        }

        public final Collection<TrafficPolicyInstance.Builder> getTrafficPolicyInstances() {
            return this.trafficPolicyInstances != null ? (Collection)this.trafficPolicyInstances.stream().map(TrafficPolicyInstance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder trafficPolicyInstances(Collection<TrafficPolicyInstance> trafficPolicyInstances) {
            this.trafficPolicyInstances = TrafficPolicyInstancesCopier.copy(trafficPolicyInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficPolicyInstances(TrafficPolicyInstance ... trafficPolicyInstances) {
            this.trafficPolicyInstances(Arrays.asList(trafficPolicyInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficPolicyInstances(Consumer<TrafficPolicyInstance.Builder> ... trafficPolicyInstances) {
            this.trafficPolicyInstances(Stream.of(trafficPolicyInstances).map(c -> (TrafficPolicyInstance)((TrafficPolicyInstance.Builder)TrafficPolicyInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTrafficPolicyInstances(Collection<TrafficPolicyInstance.BuilderImpl> trafficPolicyInstances) {
            this.trafficPolicyInstances = TrafficPolicyInstancesCopier.copyFromBuilder(trafficPolicyInstances);
        }

        public final String getHostedZoneIdMarker() {
            return this.hostedZoneIdMarker;
        }

        @Override
        public final Builder hostedZoneIdMarker(String hostedZoneIdMarker) {
            this.hostedZoneIdMarker = hostedZoneIdMarker;
            return this;
        }

        public final void setHostedZoneIdMarker(String hostedZoneIdMarker) {
            this.hostedZoneIdMarker = hostedZoneIdMarker;
        }

        public final String getTrafficPolicyInstanceNameMarker() {
            return this.trafficPolicyInstanceNameMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
            return this;
        }

        public final void setTrafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
        }

        public final String getTrafficPolicyInstanceTypeMarkerAsString() {
            return this.trafficPolicyInstanceTypeMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
            return this;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(RRType trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker(trafficPolicyInstanceTypeMarker.toString());
            return this;
        }

        public final void setTrafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListTrafficPolicyInstancesResponse build() {
            return new ListTrafficPolicyInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrafficPolicyInstancesResponse> {
        public Builder trafficPolicyInstances(Collection<TrafficPolicyInstance> var1);

        public Builder trafficPolicyInstances(TrafficPolicyInstance ... var1);

        public Builder trafficPolicyInstances(Consumer<TrafficPolicyInstance.Builder> ... var1);

        public Builder hostedZoneIdMarker(String var1);

        public Builder trafficPolicyInstanceNameMarker(String var1);

        public Builder trafficPolicyInstanceTypeMarker(String var1);

        public Builder trafficPolicyInstanceTypeMarker(RRType var1);

        public Builder isTruncated(Boolean var1);

        public Builder maxItems(String var1);
    }
}

