/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.services.route53.model.TrafficPolicyInstance;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrafficPolicyInstanceResponse
extends Route53Response
implements ToCopyableBuilder<Builder, CreateTrafficPolicyInstanceResponse> {
    private static final SdkField<TrafficPolicyInstance> TRAFFIC_POLICY_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTrafficPolicyInstanceResponse.getter(CreateTrafficPolicyInstanceResponse::trafficPolicyInstance)).setter(CreateTrafficPolicyInstanceResponse.setter(Builder::trafficPolicyInstance)).constructor(TrafficPolicyInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyInstance").unmarshallLocationName("TrafficPolicyInstance").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTrafficPolicyInstanceResponse.getter(CreateTrafficPolicyInstanceResponse::location)).setter(CreateTrafficPolicyInstanceResponse.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location").unmarshallLocationName("Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_POLICY_INSTANCE_FIELD, LOCATION_FIELD));
    private final TrafficPolicyInstance trafficPolicyInstance;
    private final String location;

    private CreateTrafficPolicyInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.trafficPolicyInstance = builder.trafficPolicyInstance;
        this.location = builder.location;
    }

    public TrafficPolicyInstance trafficPolicyInstance() {
        return this.trafficPolicyInstance;
    }

    public String location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrafficPolicyInstanceResponse)) {
            return false;
        }
        CreateTrafficPolicyInstanceResponse other = (CreateTrafficPolicyInstanceResponse)((Object)obj);
        return Objects.equals(this.trafficPolicyInstance(), other.trafficPolicyInstance()) && Objects.equals(this.location(), other.location());
    }

    public String toString() {
        return ToString.builder((String)"CreateTrafficPolicyInstanceResponse").add("TrafficPolicyInstance", (Object)this.trafficPolicyInstance()).add("Location", (Object)this.location()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficPolicyInstance": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyInstance()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrafficPolicyInstanceResponse, T> g) {
        return obj -> g.apply((CreateTrafficPolicyInstanceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private TrafficPolicyInstance trafficPolicyInstance;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrafficPolicyInstanceResponse model) {
            super(model);
            this.trafficPolicyInstance(model.trafficPolicyInstance);
            this.location(model.location);
        }

        public final TrafficPolicyInstance.Builder getTrafficPolicyInstance() {
            return this.trafficPolicyInstance != null ? this.trafficPolicyInstance.toBuilder() : null;
        }

        @Override
        public final Builder trafficPolicyInstance(TrafficPolicyInstance trafficPolicyInstance) {
            this.trafficPolicyInstance = trafficPolicyInstance;
            return this;
        }

        public final void setTrafficPolicyInstance(TrafficPolicyInstance.BuilderImpl trafficPolicyInstance) {
            this.trafficPolicyInstance = trafficPolicyInstance != null ? trafficPolicyInstance.build() : null;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public CreateTrafficPolicyInstanceResponse build() {
            return new CreateTrafficPolicyInstanceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrafficPolicyInstanceResponse> {
        public Builder trafficPolicyInstance(TrafficPolicyInstance var1);

        default public Builder trafficPolicyInstance(Consumer<TrafficPolicyInstance.Builder> trafficPolicyInstance) {
            return this.trafficPolicyInstance((TrafficPolicyInstance)((TrafficPolicyInstance.Builder)TrafficPolicyInstance.builder().applyMutation(trafficPolicyInstance)).build());
        }

        public Builder location(String var1);
    }
}

