/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum HealthCheckType {
    HTTP("HTTP"),
    HTTPS("HTTPS"),
    HTTP_STR_MATCH("HTTP_STR_MATCH"),
    HTTPS_STR_MATCH("HTTPS_STR_MATCH"),
    TCP("TCP"),
    CALCULATED("CALCULATED"),
    CLOUDWATCH_METRIC("CLOUDWATCH_METRIC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HealthCheckType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HealthCheckType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HealthCheckType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HealthCheckType> knownValues() {
        return Stream.of(HealthCheckType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

