/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53.Route53AsyncClient;
import software.amazon.awssdk.services.route53.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53.model.CollectionSummary;
import software.amazon.awssdk.services.route53.model.ListCidrCollectionsRequest;
import software.amazon.awssdk.services.route53.model.ListCidrCollectionsResponse;

public class ListCidrCollectionsPublisher
implements SdkPublisher<ListCidrCollectionsResponse> {
    private final Route53AsyncClient client;
    private final ListCidrCollectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCidrCollectionsPublisher(Route53AsyncClient client, ListCidrCollectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCidrCollectionsPublisher(Route53AsyncClient client, ListCidrCollectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCidrCollectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCidrCollectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CollectionSummary> cidrCollections() {
        return this.flatMapIterable(response -> response.cidrCollections());
    }

    private class ListCidrCollectionsResponseFetcher
    implements AsyncPageFetcher<ListCidrCollectionsResponse> {
        private ListCidrCollectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCidrCollectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCidrCollectionsResponse> nextPage(ListCidrCollectionsResponse previousPage) {
            if (previousPage == null) {
                return ListCidrCollectionsPublisher.this.client.listCidrCollections(ListCidrCollectionsPublisher.this.firstRequest);
            }
            return ListCidrCollectionsPublisher.this.client.listCidrCollections((ListCidrCollectionsRequest)((Object)ListCidrCollectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

