/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.HostedZoneOwner;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HostedZoneSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HostedZoneSummary> {
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostedZoneId").getter(HostedZoneSummary.getter(HostedZoneSummary::hostedZoneId)).setter(HostedZoneSummary.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId").unmarshallLocationName("HostedZoneId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(HostedZoneSummary.getter(HostedZoneSummary::name)).setter(HostedZoneSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").unmarshallLocationName("Name").build()}).build();
    private static final SdkField<HostedZoneOwner> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Owner").getter(HostedZoneSummary.getter(HostedZoneSummary::owner)).setter(HostedZoneSummary.setter(Builder::owner)).constructor(HostedZoneOwner::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").unmarshallLocationName("Owner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_ID_FIELD, NAME_FIELD, OWNER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HostedZoneSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String hostedZoneId;
    private final String name;
    private final HostedZoneOwner owner;

    private HostedZoneSummary(BuilderImpl builder) {
        this.hostedZoneId = builder.hostedZoneId;
        this.name = builder.name;
        this.owner = builder.owner;
    }

    public final String hostedZoneId() {
        return this.hostedZoneId;
    }

    public final String name() {
        return this.name;
    }

    public final HostedZoneOwner owner() {
        return this.owner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostedZoneSummary)) {
            return false;
        }
        HostedZoneSummary other = (HostedZoneSummary)obj;
        return Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owner(), other.owner());
    }

    public final String toString() {
        return ToString.builder((String)"HostedZoneSummary").add("HostedZoneId", (Object)this.hostedZoneId()).add("Name", (Object)this.name()).add("Owner", (Object)this.owner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HostedZoneId", HOSTED_ZONE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Owner", OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HostedZoneSummary, T> g) {
        return obj -> g.apply((HostedZoneSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hostedZoneId;
        private String name;
        private HostedZoneOwner owner;

        private BuilderImpl() {
        }

        private BuilderImpl(HostedZoneSummary model) {
            this.hostedZoneId(model.hostedZoneId);
            this.name(model.name);
            this.owner(model.owner);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final HostedZoneOwner.Builder getOwner() {
            return this.owner != null ? this.owner.toBuilder() : null;
        }

        public final void setOwner(HostedZoneOwner.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        @Override
        public final Builder owner(HostedZoneOwner owner) {
            this.owner = owner;
            return this;
        }

        public HostedZoneSummary build() {
            return new HostedZoneSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HostedZoneSummary> {
        public Builder hostedZoneId(String var1);

        public Builder name(String var1);

        public Builder owner(HostedZoneOwner var1);

        default public Builder owner(Consumer<HostedZoneOwner.Builder> owner) {
            return this.owner((HostedZoneOwner)((HostedZoneOwner.Builder)HostedZoneOwner.builder().applyMutation(owner)).build());
        }
    }
}

