/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryLoggingConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryLoggingConfig> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueryLoggingConfig.getter(QueryLoggingConfig::id)).setter(QueryLoggingConfig.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueryLoggingConfig.getter(QueryLoggingConfig::hostedZoneId)).setter(QueryLoggingConfig.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZoneId").unmarshallLocationName("HostedZoneId").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_LOGS_LOG_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(QueryLoggingConfig.getter(QueryLoggingConfig::cloudWatchLogsLogGroupArn)).setter(QueryLoggingConfig.setter(Builder::cloudWatchLogsLogGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsLogGroupArn").unmarshallLocationName("CloudWatchLogsLogGroupArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, HOSTED_ZONE_ID_FIELD, CLOUD_WATCH_LOGS_LOG_GROUP_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String hostedZoneId;
    private final String cloudWatchLogsLogGroupArn;

    private QueryLoggingConfig(BuilderImpl builder) {
        this.id = builder.id;
        this.hostedZoneId = builder.hostedZoneId;
        this.cloudWatchLogsLogGroupArn = builder.cloudWatchLogsLogGroupArn;
    }

    public String id() {
        return this.id;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public String cloudWatchLogsLogGroupArn() {
        return this.cloudWatchLogsLogGroupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogsLogGroupArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryLoggingConfig)) {
            return false;
        }
        QueryLoggingConfig other = (QueryLoggingConfig)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.cloudWatchLogsLogGroupArn(), other.cloudWatchLogsLogGroupArn());
    }

    public String toString() {
        return ToString.builder((String)"QueryLoggingConfig").add("Id", (Object)this.id()).add("HostedZoneId", (Object)this.hostedZoneId()).add("CloudWatchLogsLogGroupArn", (Object)this.cloudWatchLogsLogGroupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "CloudWatchLogsLogGroupArn": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogsLogGroupArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryLoggingConfig, T> g) {
        return obj -> g.apply((QueryLoggingConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String hostedZoneId;
        private String cloudWatchLogsLogGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryLoggingConfig model) {
            this.id(model.id);
            this.hostedZoneId(model.hostedZoneId);
            this.cloudWatchLogsLogGroupArn(model.cloudWatchLogsLogGroupArn);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getCloudWatchLogsLogGroupArn() {
            return this.cloudWatchLogsLogGroupArn;
        }

        @Override
        public final Builder cloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
            return this;
        }

        public final void setCloudWatchLogsLogGroupArn(String cloudWatchLogsLogGroupArn) {
            this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
        }

        public QueryLoggingConfig build() {
            return new QueryLoggingConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryLoggingConfig> {
        public Builder id(String var1);

        public Builder hostedZoneId(String var1);

        public Builder cloudWatchLogsLogGroupArn(String var1);
    }
}

