/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.CidrBlockSummariesCopier;
import software.amazon.awssdk.services.route53.model.CidrBlockSummary;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCidrBlocksResponse
extends Route53Response
implements ToCopyableBuilder<Builder, ListCidrBlocksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCidrBlocksResponse.getter(ListCidrBlocksResponse::nextToken)).setter(ListCidrBlocksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<List<CidrBlockSummary>> CIDR_BLOCKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CidrBlocks").getter(ListCidrBlocksResponse.getter(ListCidrBlocksResponse::cidrBlocks)).setter(ListCidrBlocksResponse.setter(Builder::cidrBlocks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrBlocks").unmarshallLocationName("CidrBlocks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CidrBlockSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CIDR_BLOCKS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCidrBlocksResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<CidrBlockSummary> cidrBlocks;

    private ListCidrBlocksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.cidrBlocks = builder.cidrBlocks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCidrBlocks() {
        return this.cidrBlocks != null && !(this.cidrBlocks instanceof SdkAutoConstructList);
    }

    public final List<CidrBlockSummary> cidrBlocks() {
        return this.cidrBlocks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrBlocks() ? this.cidrBlocks() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCidrBlocksResponse)) {
            return false;
        }
        ListCidrBlocksResponse other = (ListCidrBlocksResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCidrBlocks() == other.hasCidrBlocks() && Objects.equals(this.cidrBlocks(), other.cidrBlocks());
    }

    public final String toString() {
        return ToString.builder((String)"ListCidrBlocksResponse").add("NextToken", (Object)this.nextToken()).add("CidrBlocks", this.hasCidrBlocks() ? this.cidrBlocks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "CidrBlocks": {
                return Optional.ofNullable(clazz.cast(this.cidrBlocks()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("CidrBlocks", CIDR_BLOCKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCidrBlocksResponse, T> g) {
        return obj -> g.apply((ListCidrBlocksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CidrBlockSummary> cidrBlocks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCidrBlocksResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.cidrBlocks(model.cidrBlocks);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CidrBlockSummary.Builder> getCidrBlocks() {
            List<CidrBlockSummary.Builder> result = CidrBlockSummariesCopier.copyToBuilder(this.cidrBlocks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCidrBlocks(Collection<CidrBlockSummary.BuilderImpl> cidrBlocks) {
            this.cidrBlocks = CidrBlockSummariesCopier.copyFromBuilder(cidrBlocks);
        }

        @Override
        public final Builder cidrBlocks(Collection<CidrBlockSummary> cidrBlocks) {
            this.cidrBlocks = CidrBlockSummariesCopier.copy(cidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlocks(CidrBlockSummary ... cidrBlocks) {
            this.cidrBlocks(Arrays.asList(cidrBlocks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrBlocks(Consumer<CidrBlockSummary.Builder> ... cidrBlocks) {
            this.cidrBlocks(Stream.of(cidrBlocks).map(c -> (CidrBlockSummary)((CidrBlockSummary.Builder)CidrBlockSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCidrBlocksResponse build() {
            return new ListCidrBlocksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCidrBlocksResponse> {
        public Builder nextToken(String var1);

        public Builder cidrBlocks(Collection<CidrBlockSummary> var1);

        public Builder cidrBlocks(CidrBlockSummary ... var1);

        public Builder cidrBlocks(Consumer<CidrBlockSummary.Builder> ... var1);
    }
}

