/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains the response information for the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrafficPolicyInstancesByHostedZoneResponse extends Route53Response implements
        ToCopyableBuilder<ListTrafficPolicyInstancesByHostedZoneResponse.Builder, ListTrafficPolicyInstancesByHostedZoneResponse> {
    private static final SdkField<List<TrafficPolicyInstance>> TRAFFIC_POLICY_INSTANCES_FIELD = SdkField
            .<List<TrafficPolicyInstance>> builder(MarshallingType.LIST)
            .memberName("TrafficPolicyInstances")
            .getter(getter(ListTrafficPolicyInstancesByHostedZoneResponse::trafficPolicyInstances))
            .setter(setter(Builder::trafficPolicyInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyInstances")
                    .unmarshallLocationName("TrafficPolicyInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("TrafficPolicyInstance")
                            .memberFieldInfo(
                                    SdkField.<TrafficPolicyInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrafficPolicyInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("TrafficPolicyInstance")
                                                    .unmarshallLocationName("TrafficPolicyInstance").build()).build()).build())
            .build();

    private static final SdkField<String> TRAFFIC_POLICY_INSTANCE_NAME_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficPolicyInstanceNameMarker")
            .getter(getter(ListTrafficPolicyInstancesByHostedZoneResponse::trafficPolicyInstanceNameMarker))
            .setter(setter(Builder::trafficPolicyInstanceNameMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyInstanceNameMarker")
                    .unmarshallLocationName("TrafficPolicyInstanceNameMarker").build()).build();

    private static final SdkField<String> TRAFFIC_POLICY_INSTANCE_TYPE_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TrafficPolicyInstanceTypeMarker")
            .getter(getter(ListTrafficPolicyInstancesByHostedZoneResponse::trafficPolicyInstanceTypeMarkerAsString))
            .setter(setter(Builder::trafficPolicyInstanceTypeMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficPolicyInstanceTypeMarker")
                    .unmarshallLocationName("TrafficPolicyInstanceTypeMarker").build()).build();

    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsTruncated")
            .getter(getter(ListTrafficPolicyInstancesByHostedZoneResponse::isTruncated))
            .setter(setter(Builder::isTruncated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated")
                    .unmarshallLocationName("IsTruncated").build()).build();

    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MaxItems")
            .getter(getter(ListTrafficPolicyInstancesByHostedZoneResponse::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRAFFIC_POLICY_INSTANCES_FIELD, TRAFFIC_POLICY_INSTANCE_NAME_MARKER_FIELD, TRAFFIC_POLICY_INSTANCE_TYPE_MARKER_FIELD,
            IS_TRUNCATED_FIELD, MAX_ITEMS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<TrafficPolicyInstance> trafficPolicyInstances;

    private final String trafficPolicyInstanceNameMarker;

    private final String trafficPolicyInstanceTypeMarker;

    private final Boolean isTruncated;

    private final String maxItems;

    private ListTrafficPolicyInstancesByHostedZoneResponse(BuilderImpl builder) {
        super(builder);
        this.trafficPolicyInstances = builder.trafficPolicyInstances;
        this.trafficPolicyInstanceNameMarker = builder.trafficPolicyInstanceNameMarker;
        this.trafficPolicyInstanceTypeMarker = builder.trafficPolicyInstanceTypeMarker;
        this.isTruncated = builder.isTruncated;
        this.maxItems = builder.maxItems;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrafficPolicyInstances property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTrafficPolicyInstances() {
        return trafficPolicyInstances != null && !(trafficPolicyInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that matches
     * the elements in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrafficPolicyInstances} method.
     * </p>
     * 
     * @return A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that
     *         matches the elements in the request.
     */
    public final List<TrafficPolicyInstance> trafficPolicyInstances() {
        return trafficPolicyInstances;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of the
     * first traffic policy instance in the next group of traffic policy instances.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the
     *         name of the first traffic policy instance in the next group of traffic policy instances.
     */
    public final String trafficPolicyInstanceNameMarker() {
        return trafficPolicyInstanceNameMarker;
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is true, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the resource
     * record sets that are associated with the first traffic policy instance in the next group of traffic policy
     * instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trafficPolicyInstanceTypeMarker} will return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trafficPolicyInstanceTypeMarkerAsString}.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is true, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the
     *         resource record sets that are associated with the first traffic policy instance in the next group of
     *         traffic policy instances.
     * @see RRType
     */
    public final RRType trafficPolicyInstanceTypeMarker() {
        return RRType.fromValue(trafficPolicyInstanceTypeMarker);
    }

    /**
     * <p>
     * If <code>IsTruncated</code> is true, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the resource
     * record sets that are associated with the first traffic policy instance in the next group of traffic policy
     * instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trafficPolicyInstanceTypeMarker} will return {@link RRType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #trafficPolicyInstanceTypeMarkerAsString}.
     * </p>
     * 
     * @return If <code>IsTruncated</code> is true, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the
     *         resource record sets that are associated with the first traffic policy instance in the next group of
     *         traffic policy instances.
     * @see RRType
     */
    public final String trafficPolicyInstanceTypeMarkerAsString() {
        return trafficPolicyInstanceTypeMarker;
    }

    /**
     * <p>
     * A flag that indicates whether there are more traffic policy instances to be listed. If the response was
     * truncated, you can get the next group of traffic policy instances by submitting another
     * <code>ListTrafficPolicyInstancesByHostedZone</code> request and specifying the values of
     * <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
     * <code>TrafficPolicyInstanceTypeMarker</code> in the corresponding request parameters.
     * </p>
     * 
     * @return A flag that indicates whether there are more traffic policy instances to be listed. If the response was
     *         truncated, you can get the next group of traffic policy instances by submitting another
     *         <code>ListTrafficPolicyInstancesByHostedZone</code> request and specifying the values of
     *         <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
     *         <code>TrafficPolicyInstanceTypeMarker</code> in the corresponding request parameters.
     */
    public final Boolean isTruncated() {
        return isTruncated;
    }

    /**
     * <p>
     * The value that you specified for the <code>MaxItems</code> parameter in the
     * <code>ListTrafficPolicyInstancesByHostedZone</code> request that produced the current response.
     * </p>
     * 
     * @return The value that you specified for the <code>MaxItems</code> parameter in the
     *         <code>ListTrafficPolicyInstancesByHostedZone</code> request that produced the current response.
     */
    public final String maxItems() {
        return maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTrafficPolicyInstances() ? trafficPolicyInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyInstanceNameMarker());
        hashCode = 31 * hashCode + Objects.hashCode(trafficPolicyInstanceTypeMarkerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPolicyInstancesByHostedZoneResponse)) {
            return false;
        }
        ListTrafficPolicyInstancesByHostedZoneResponse other = (ListTrafficPolicyInstancesByHostedZoneResponse) obj;
        return hasTrafficPolicyInstances() == other.hasTrafficPolicyInstances()
                && Objects.equals(trafficPolicyInstances(), other.trafficPolicyInstances())
                && Objects.equals(trafficPolicyInstanceNameMarker(), other.trafficPolicyInstanceNameMarker())
                && Objects.equals(trafficPolicyInstanceTypeMarkerAsString(), other.trafficPolicyInstanceTypeMarkerAsString())
                && Objects.equals(isTruncated(), other.isTruncated()) && Objects.equals(maxItems(), other.maxItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTrafficPolicyInstancesByHostedZoneResponse")
                .add("TrafficPolicyInstances", hasTrafficPolicyInstances() ? trafficPolicyInstances() : null)
                .add("TrafficPolicyInstanceNameMarker", trafficPolicyInstanceNameMarker())
                .add("TrafficPolicyInstanceTypeMarker", trafficPolicyInstanceTypeMarkerAsString())
                .add("IsTruncated", isTruncated()).add("MaxItems", maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrafficPolicyInstances":
            return Optional.ofNullable(clazz.cast(trafficPolicyInstances()));
        case "TrafficPolicyInstanceNameMarker":
            return Optional.ofNullable(clazz.cast(trafficPolicyInstanceNameMarker()));
        case "TrafficPolicyInstanceTypeMarker":
            return Optional.ofNullable(clazz.cast(trafficPolicyInstanceTypeMarkerAsString()));
        case "IsTruncated":
            return Optional.ofNullable(clazz.cast(isTruncated()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrafficPolicyInstances", TRAFFIC_POLICY_INSTANCES_FIELD);
        map.put("TrafficPolicyInstanceNameMarker", TRAFFIC_POLICY_INSTANCE_NAME_MARKER_FIELD);
        map.put("TrafficPolicyInstanceTypeMarker", TRAFFIC_POLICY_INSTANCE_TYPE_MARKER_FIELD);
        map.put("IsTruncated", IS_TRUNCATED_FIELD);
        map.put("MaxItems", MAX_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTrafficPolicyInstancesByHostedZoneResponse, T> g) {
        return obj -> g.apply((ListTrafficPolicyInstancesByHostedZoneResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Route53Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTrafficPolicyInstancesByHostedZoneResponse> {
        /**
         * <p>
         * A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that
         * matches the elements in the request.
         * </p>
         * 
         * @param trafficPolicyInstances
         *        A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance
         *        that matches the elements in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyInstances(Collection<TrafficPolicyInstance> trafficPolicyInstances);

        /**
         * <p>
         * A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that
         * matches the elements in the request.
         * </p>
         * 
         * @param trafficPolicyInstances
         *        A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance
         *        that matches the elements in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyInstances(TrafficPolicyInstance... trafficPolicyInstances);

        /**
         * <p>
         * A list that contains one <code>TrafficPolicyInstance</code> element for each traffic policy instance that
         * matches the elements in the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.route53.model.TrafficPolicyInstance.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.route53.model.TrafficPolicyInstance#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.route53.model.TrafficPolicyInstance.Builder#build()} is called
         * immediately and its result is passed to {@link #trafficPolicyInstances(List<TrafficPolicyInstance>)}.
         * 
         * @param trafficPolicyInstances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.route53.model.TrafficPolicyInstance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trafficPolicyInstances(java.util.Collection<TrafficPolicyInstance>)
         */
        Builder trafficPolicyInstances(Consumer<TrafficPolicyInstance.Builder>... trafficPolicyInstances);

        /**
         * <p>
         * If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the name of
         * the first traffic policy instance in the next group of traffic policy instances.
         * </p>
         * 
         * @param trafficPolicyInstanceNameMarker
         *        If <code>IsTruncated</code> is <code>true</code>, <code>TrafficPolicyInstanceNameMarker</code> is the
         *        name of the first traffic policy instance in the next group of traffic policy instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker);

        /**
         * <p>
         * If <code>IsTruncated</code> is true, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the
         * resource record sets that are associated with the first traffic policy instance in the next group of traffic
         * policy instances.
         * </p>
         * 
         * @param trafficPolicyInstanceTypeMarker
         *        If <code>IsTruncated</code> is true, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of
         *        the resource record sets that are associated with the first traffic policy instance in the next group
         *        of traffic policy instances.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder trafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker);

        /**
         * <p>
         * If <code>IsTruncated</code> is true, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of the
         * resource record sets that are associated with the first traffic policy instance in the next group of traffic
         * policy instances.
         * </p>
         * 
         * @param trafficPolicyInstanceTypeMarker
         *        If <code>IsTruncated</code> is true, <code>TrafficPolicyInstanceTypeMarker</code> is the DNS type of
         *        the resource record sets that are associated with the first traffic policy instance in the next group
         *        of traffic policy instances.
         * @see RRType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RRType
         */
        Builder trafficPolicyInstanceTypeMarker(RRType trafficPolicyInstanceTypeMarker);

        /**
         * <p>
         * A flag that indicates whether there are more traffic policy instances to be listed. If the response was
         * truncated, you can get the next group of traffic policy instances by submitting another
         * <code>ListTrafficPolicyInstancesByHostedZone</code> request and specifying the values of
         * <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
         * <code>TrafficPolicyInstanceTypeMarker</code> in the corresponding request parameters.
         * </p>
         * 
         * @param isTruncated
         *        A flag that indicates whether there are more traffic policy instances to be listed. If the response
         *        was truncated, you can get the next group of traffic policy instances by submitting another
         *        <code>ListTrafficPolicyInstancesByHostedZone</code> request and specifying the values of
         *        <code>HostedZoneIdMarker</code>, <code>TrafficPolicyInstanceNameMarker</code>, and
         *        <code>TrafficPolicyInstanceTypeMarker</code> in the corresponding request parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isTruncated(Boolean isTruncated);

        /**
         * <p>
         * The value that you specified for the <code>MaxItems</code> parameter in the
         * <code>ListTrafficPolicyInstancesByHostedZone</code> request that produced the current response.
         * </p>
         * 
         * @param maxItems
         *        The value that you specified for the <code>MaxItems</code> parameter in the
         *        <code>ListTrafficPolicyInstancesByHostedZone</code> request that produced the current response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(String maxItems);
    }

    static final class BuilderImpl extends Route53Response.BuilderImpl implements Builder {
        private List<TrafficPolicyInstance> trafficPolicyInstances = DefaultSdkAutoConstructList.getInstance();

        private String trafficPolicyInstanceNameMarker;

        private String trafficPolicyInstanceTypeMarker;

        private Boolean isTruncated;

        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPolicyInstancesByHostedZoneResponse model) {
            super(model);
            trafficPolicyInstances(model.trafficPolicyInstances);
            trafficPolicyInstanceNameMarker(model.trafficPolicyInstanceNameMarker);
            trafficPolicyInstanceTypeMarker(model.trafficPolicyInstanceTypeMarker);
            isTruncated(model.isTruncated);
            maxItems(model.maxItems);
        }

        public final List<TrafficPolicyInstance.Builder> getTrafficPolicyInstances() {
            List<TrafficPolicyInstance.Builder> result = TrafficPolicyInstancesCopier.copyToBuilder(this.trafficPolicyInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrafficPolicyInstances(Collection<TrafficPolicyInstance.BuilderImpl> trafficPolicyInstances) {
            this.trafficPolicyInstances = TrafficPolicyInstancesCopier.copyFromBuilder(trafficPolicyInstances);
        }

        @Override
        public final Builder trafficPolicyInstances(Collection<TrafficPolicyInstance> trafficPolicyInstances) {
            this.trafficPolicyInstances = TrafficPolicyInstancesCopier.copy(trafficPolicyInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficPolicyInstances(TrafficPolicyInstance... trafficPolicyInstances) {
            trafficPolicyInstances(Arrays.asList(trafficPolicyInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trafficPolicyInstances(Consumer<TrafficPolicyInstance.Builder>... trafficPolicyInstances) {
            trafficPolicyInstances(Stream.of(trafficPolicyInstances)
                    .map(c -> TrafficPolicyInstance.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getTrafficPolicyInstanceNameMarker() {
            return trafficPolicyInstanceNameMarker;
        }

        public final void setTrafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
            return this;
        }

        public final String getTrafficPolicyInstanceTypeMarker() {
            return trafficPolicyInstanceTypeMarker;
        }

        public final void setTrafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
            return this;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(RRType trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker(trafficPolicyInstanceTypeMarker == null ? null : trafficPolicyInstanceTypeMarker
                    .toString());
            return this;
        }

        public final Boolean getIsTruncated() {
            return isTruncated;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final String getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public ListTrafficPolicyInstancesByHostedZoneResponse build() {
            return new ListTrafficPolicyInstancesByHostedZoneResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
