/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A key-signing key (KSK) is a complex type that represents a public/private key pair. The private key is used to
 * generate a digital signature for the zone signing key (ZSK). The public key is stored in the DNS and is used to
 * authenticate the ZSK. A KSK is always associated with a hosted zone; it cannot exist by itself.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeySigningKey implements SdkPojo, Serializable, ToCopyableBuilder<KeySigningKey.Builder, KeySigningKey> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(KeySigningKey::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> KMS_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("KmsArn")
            .getter(getter(KeySigningKey::kmsArn))
            .setter(setter(Builder::kmsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsArn")
                    .unmarshallLocationName("KmsArn").build()).build();

    private static final SdkField<Integer> FLAG_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Flag")
            .getter(getter(KeySigningKey::flag))
            .setter(setter(Builder::flag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Flag")
                    .unmarshallLocationName("Flag").build()).build();

    private static final SdkField<String> SIGNING_ALGORITHM_MNEMONIC_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SigningAlgorithmMnemonic")
            .getter(getter(KeySigningKey::signingAlgorithmMnemonic))
            .setter(setter(Builder::signingAlgorithmMnemonic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAlgorithmMnemonic")
                    .unmarshallLocationName("SigningAlgorithmMnemonic").build()).build();

    private static final SdkField<Integer> SIGNING_ALGORITHM_TYPE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SigningAlgorithmType")
            .getter(getter(KeySigningKey::signingAlgorithmType))
            .setter(setter(Builder::signingAlgorithmType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningAlgorithmType")
                    .unmarshallLocationName("SigningAlgorithmType").build()).build();

    private static final SdkField<String> DIGEST_ALGORITHM_MNEMONIC_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DigestAlgorithmMnemonic")
            .getter(getter(KeySigningKey::digestAlgorithmMnemonic))
            .setter(setter(Builder::digestAlgorithmMnemonic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DigestAlgorithmMnemonic")
                    .unmarshallLocationName("DigestAlgorithmMnemonic").build()).build();

    private static final SdkField<Integer> DIGEST_ALGORITHM_TYPE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DigestAlgorithmType")
            .getter(getter(KeySigningKey::digestAlgorithmType))
            .setter(setter(Builder::digestAlgorithmType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DigestAlgorithmType")
                    .unmarshallLocationName("DigestAlgorithmType").build()).build();

    private static final SdkField<Integer> KEY_TAG_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("KeyTag")
            .getter(getter(KeySigningKey::keyTag))
            .setter(setter(Builder::keyTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyTag")
                    .unmarshallLocationName("KeyTag").build()).build();

    private static final SdkField<String> DIGEST_VALUE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DigestValue")
            .getter(getter(KeySigningKey::digestValue))
            .setter(setter(Builder::digestValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DigestValue")
                    .unmarshallLocationName("DigestValue").build()).build();

    private static final SdkField<String> PUBLIC_KEY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PublicKey")
            .getter(getter(KeySigningKey::publicKey))
            .setter(setter(Builder::publicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKey")
                    .unmarshallLocationName("PublicKey").build()).build();

    private static final SdkField<String> DS_RECORD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DSRecord")
            .getter(getter(KeySigningKey::dsRecord))
            .setter(setter(Builder::dsRecord))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DSRecord")
                    .unmarshallLocationName("DSRecord").build()).build();

    private static final SdkField<String> DNSKEY_RECORD_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DNSKEYRecord")
            .getter(getter(KeySigningKey::dnskeyRecord))
            .setter(setter(Builder::dnskeyRecord))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DNSKEYRecord")
                    .unmarshallLocationName("DNSKEYRecord").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Status")
            .getter(getter(KeySigningKey::status))
            .setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status")
                    .unmarshallLocationName("Status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("StatusMessage")
            .getter(getter(KeySigningKey::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage")
                    .unmarshallLocationName("StatusMessage").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate")
            .getter(getter(KeySigningKey::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate")
                    .unmarshallLocationName("CreatedDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate")
            .getter(getter(KeySigningKey::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate")
                    .unmarshallLocationName("LastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, KMS_ARN_FIELD,
            FLAG_FIELD, SIGNING_ALGORITHM_MNEMONIC_FIELD, SIGNING_ALGORITHM_TYPE_FIELD, DIGEST_ALGORITHM_MNEMONIC_FIELD,
            DIGEST_ALGORITHM_TYPE_FIELD, KEY_TAG_FIELD, DIGEST_VALUE_FIELD, PUBLIC_KEY_FIELD, DS_RECORD_FIELD,
            DNSKEY_RECORD_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATED_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String kmsArn;

    private final Integer flag;

    private final String signingAlgorithmMnemonic;

    private final Integer signingAlgorithmType;

    private final String digestAlgorithmMnemonic;

    private final Integer digestAlgorithmType;

    private final Integer keyTag;

    private final String digestValue;

    private final String publicKey;

    private final String dsRecord;

    private final String dnskeyRecord;

    private final String status;

    private final String statusMessage;

    private final Instant createdDate;

    private final Instant lastModifiedDate;

    private KeySigningKey(BuilderImpl builder) {
        this.name = builder.name;
        this.kmsArn = builder.kmsArn;
        this.flag = builder.flag;
        this.signingAlgorithmMnemonic = builder.signingAlgorithmMnemonic;
        this.signingAlgorithmType = builder.signingAlgorithmType;
        this.digestAlgorithmMnemonic = builder.digestAlgorithmMnemonic;
        this.digestAlgorithmType = builder.digestAlgorithmType;
        this.keyTag = builder.keyTag;
        this.digestValue = builder.digestValue;
        this.publicKey = builder.publicKey;
        this.dsRecord = builder.dsRecord;
        this.dnskeyRecord = builder.dnskeyRecord;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.createdDate = builder.createdDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters, and
     * underscores (_). <code>Name</code> must be unique for each key-signing key in the same hosted zone.
     * </p>
     * 
     * @return A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters, and
     *         underscores (_). <code>Name</code> must be unique for each key-signing key in the same hosted zone.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon resource name (ARN) used to identify the customer managed key in Key Management Service (KMS). The
     * <code>KmsArn</code> must be unique for each key-signing key (KSK) in a single hosted zone.
     * </p>
     * <p>
     * You must configure the customer managed key as follows:
     * </p>
     * <dl>
     * <dt>Status</dt>
     * <dd>
     * <p>
     * Enabled
     * </p>
     * </dd>
     * <dt>Key spec</dt>
     * <dd>
     * <p>
     * ECC_NIST_P256
     * </p>
     * </dd>
     * <dt>Key usage</dt>
     * <dd>
     * <p>
     * Sign and verify
     * </p>
     * </dd>
     * <dt>Key policy</dt>
     * <dd>
     * <p>
     * The key policy must give permission for the following actions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DescribeKey
     * </p>
     * </li>
     * <li>
     * <p>
     * GetPublicKey
     * </p>
     * </li>
     * <li>
     * <p>
     * Sign
     * </p>
     * </li>
     * </ul>
     * <p>
     * The key policy must also include the Amazon Route 53 service in the principal for your account. Specify the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"Service": "dnssec-route53.amazonaws.com"</code>
     * </p>
     * </li>
     * </ul>
     * </dd>
     * </dl>
     * <p>
     * For more information about working with the customer managed key in KMS, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">Key Management Service concepts</a>.
     * </p>
     * 
     * @return The Amazon resource name (ARN) used to identify the customer managed key in Key Management Service (KMS).
     *         The <code>KmsArn</code> must be unique for each key-signing key (KSK) in a single hosted zone.</p>
     *         <p>
     *         You must configure the customer managed key as follows:
     *         </p>
     *         <dl>
     *         <dt>Status</dt>
     *         <dd>
     *         <p>
     *         Enabled
     *         </p>
     *         </dd>
     *         <dt>Key spec</dt>
     *         <dd>
     *         <p>
     *         ECC_NIST_P256
     *         </p>
     *         </dd>
     *         <dt>Key usage</dt>
     *         <dd>
     *         <p>
     *         Sign and verify
     *         </p>
     *         </dd>
     *         <dt>Key policy</dt>
     *         <dd>
     *         <p>
     *         The key policy must give permission for the following actions:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         DescribeKey
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         GetPublicKey
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Sign
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The key policy must also include the Amazon Route 53 service in the principal for your account. Specify
     *         the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>"Service": "dnssec-route53.amazonaws.com"</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </dd>
     *         </dl>
     *         <p>
     *         For more information about working with the customer managed key in KMS, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">Key Management Service
     *         concepts</a>.
     */
    public final String kmsArn() {
        return kmsArn;
    }

    /**
     * <p>
     * An integer that specifies how the key is used. For key-signing key (KSK), this value is always 257.
     * </p>
     * 
     * @return An integer that specifies how the key is used. For key-signing key (KSK), this value is always 257.
     */
    public final Integer flag() {
        return flag;
    }

    /**
     * <p>
     * A string used to represent the signing algorithm. This value must follow the guidelines provided by <a
     * href="https://tools.ietf.org/html/rfc8624#section-3.1">RFC-8624 Section 3.1</a>.
     * </p>
     * 
     * @return A string used to represent the signing algorithm. This value must follow the guidelines provided by <a
     *         href="https://tools.ietf.org/html/rfc8624#section-3.1">RFC-8624 Section 3.1</a>.
     */
    public final String signingAlgorithmMnemonic() {
        return signingAlgorithmMnemonic;
    }

    /**
     * <p>
     * An integer used to represent the signing algorithm. This value must follow the guidelines provided by <a
     * href="https://tools.ietf.org/html/rfc8624#section-3.1">RFC-8624 Section 3.1</a>.
     * </p>
     * 
     * @return An integer used to represent the signing algorithm. This value must follow the guidelines provided by <a
     *         href="https://tools.ietf.org/html/rfc8624#section-3.1">RFC-8624 Section 3.1</a>.
     */
    public final Integer signingAlgorithmType() {
        return signingAlgorithmType;
    }

    /**
     * <p>
     * A string used to represent the delegation signer digest algorithm. This value must follow the guidelines provided
     * by <a href="https://tools.ietf.org/html/rfc8624#section-3.3">RFC-8624 Section 3.3</a>.
     * </p>
     * 
     * @return A string used to represent the delegation signer digest algorithm. This value must follow the guidelines
     *         provided by <a href="https://tools.ietf.org/html/rfc8624#section-3.3">RFC-8624 Section 3.3</a>.
     */
    public final String digestAlgorithmMnemonic() {
        return digestAlgorithmMnemonic;
    }

    /**
     * <p>
     * An integer used to represent the delegation signer digest algorithm. This value must follow the guidelines
     * provided by <a href="https://tools.ietf.org/html/rfc8624#section-3.3">RFC-8624 Section 3.3</a>.
     * </p>
     * 
     * @return An integer used to represent the delegation signer digest algorithm. This value must follow the
     *         guidelines provided by <a href="https://tools.ietf.org/html/rfc8624#section-3.3">RFC-8624 Section
     *         3.3</a>.
     */
    public final Integer digestAlgorithmType() {
        return digestAlgorithmType;
    }

    /**
     * <p>
     * An integer used to identify the DNSSEC record for the domain name. The process used to calculate the value is
     * described in <a href="https://tools.ietf.org/rfc/rfc4034.txt">RFC-4034 Appendix B</a>.
     * </p>
     * 
     * @return An integer used to identify the DNSSEC record for the domain name. The process used to calculate the
     *         value is described in <a href="https://tools.ietf.org/rfc/rfc4034.txt">RFC-4034 Appendix B</a>.
     */
    public final Integer keyTag() {
        return keyTag;
    }

    /**
     * <p>
     * A cryptographic digest of a DNSKEY resource record (RR). DNSKEY records are used to publish the public key that
     * resolvers can use to verify DNSSEC signatures that are used to secure certain kinds of information provided by
     * the DNS system.
     * </p>
     * 
     * @return A cryptographic digest of a DNSKEY resource record (RR). DNSKEY records are used to publish the public
     *         key that resolvers can use to verify DNSSEC signatures that are used to secure certain kinds of
     *         information provided by the DNS system.
     */
    public final String digestValue() {
        return digestValue;
    }

    /**
     * <p>
     * The public key, represented as a Base64 encoding, as required by <a
     * href="https://tools.ietf.org/rfc/rfc4034.txt"> RFC-4034 Page 5</a>.
     * </p>
     * 
     * @return The public key, represented as a Base64 encoding, as required by <a
     *         href="https://tools.ietf.org/rfc/rfc4034.txt"> RFC-4034 Page 5</a>.
     */
    public final String publicKey() {
        return publicKey;
    }

    /**
     * <p>
     * A string that represents a delegation signer (DS) record.
     * </p>
     * 
     * @return A string that represents a delegation signer (DS) record.
     */
    public final String dsRecord() {
        return dsRecord;
    }

    /**
     * <p>
     * A string that represents a DNSKEY record.
     * </p>
     * 
     * @return A string that represents a DNSKEY record.
     */
    public final String dnskeyRecord() {
        return dnskeyRecord;
    }

    /**
     * <p>
     * A string that represents the current key-signing key (KSK) status.
     * </p>
     * <p>
     * Status can have one of the following values:
     * </p>
     * <dl>
     * <dt>ACTIVE</dt>
     * <dd>
     * <p>
     * The KSK is being used for signing.
     * </p>
     * </dd>
     * <dt>INACTIVE</dt>
     * <dd>
     * <p>
     * The KSK is not being used for signing.
     * </p>
     * </dd>
     * <dt>DELETING</dt>
     * <dd>
     * <p>
     * The KSK is in the process of being deleted.
     * </p>
     * </dd>
     * <dt>ACTION_NEEDED</dt>
     * <dd>
     * <p>
     * There is a problem with the KSK that requires you to take action to resolve. For example, the customer managed
     * key might have been deleted, or the permissions for the customer managed key might have been changed.
     * </p>
     * </dd>
     * <dt>INTERNAL_FAILURE</dt>
     * <dd>
     * <p>
     * There was an error during a request. Before you can continue to work with DNSSEC signing, including actions that
     * involve this KSK, you must correct the problem. For example, you may need to activate or deactivate the KSK.
     * </p>
     * </dd>
     * </dl>
     * 
     * @return A string that represents the current key-signing key (KSK) status.</p>
     *         <p>
     *         Status can have one of the following values:
     *         </p>
     *         <dl>
     *         <dt>ACTIVE</dt>
     *         <dd>
     *         <p>
     *         The KSK is being used for signing.
     *         </p>
     *         </dd>
     *         <dt>INACTIVE</dt>
     *         <dd>
     *         <p>
     *         The KSK is not being used for signing.
     *         </p>
     *         </dd>
     *         <dt>DELETING</dt>
     *         <dd>
     *         <p>
     *         The KSK is in the process of being deleted.
     *         </p>
     *         </dd>
     *         <dt>ACTION_NEEDED</dt>
     *         <dd>
     *         <p>
     *         There is a problem with the KSK that requires you to take action to resolve. For example, the customer
     *         managed key might have been deleted, or the permissions for the customer managed key might have been
     *         changed.
     *         </p>
     *         </dd>
     *         <dt>INTERNAL_FAILURE</dt>
     *         <dd>
     *         <p>
     *         There was an error during a request. Before you can continue to work with DNSSEC signing, including
     *         actions that involve this KSK, you must correct the problem. For example, you may need to activate or
     *         deactivate the KSK.
     *         </p>
     *         </dd>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The status message provided for the following key-signing key (KSK) statuses: <code>ACTION_NEEDED</code> or
     * <code>INTERNAL_FAILURE</code>. The status message includes information about what the problem might be and steps
     * that you can take to correct the issue.
     * </p>
     * 
     * @return The status message provided for the following key-signing key (KSK) statuses: <code>ACTION_NEEDED</code>
     *         or <code>INTERNAL_FAILURE</code>. The status message includes information about what the problem might be
     *         and steps that you can take to correct the issue.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The date when the key-signing key (KSK) was created.
     * </p>
     * 
     * @return The date when the key-signing key (KSK) was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The last time that the key-signing key (KSK) was changed.
     * </p>
     * 
     * @return The last time that the key-signing key (KSK) was changed.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(kmsArn());
        hashCode = 31 * hashCode + Objects.hashCode(flag());
        hashCode = 31 * hashCode + Objects.hashCode(signingAlgorithmMnemonic());
        hashCode = 31 * hashCode + Objects.hashCode(signingAlgorithmType());
        hashCode = 31 * hashCode + Objects.hashCode(digestAlgorithmMnemonic());
        hashCode = 31 * hashCode + Objects.hashCode(digestAlgorithmType());
        hashCode = 31 * hashCode + Objects.hashCode(keyTag());
        hashCode = 31 * hashCode + Objects.hashCode(digestValue());
        hashCode = 31 * hashCode + Objects.hashCode(publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(dsRecord());
        hashCode = 31 * hashCode + Objects.hashCode(dnskeyRecord());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeySigningKey)) {
            return false;
        }
        KeySigningKey other = (KeySigningKey) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(kmsArn(), other.kmsArn())
                && Objects.equals(flag(), other.flag())
                && Objects.equals(signingAlgorithmMnemonic(), other.signingAlgorithmMnemonic())
                && Objects.equals(signingAlgorithmType(), other.signingAlgorithmType())
                && Objects.equals(digestAlgorithmMnemonic(), other.digestAlgorithmMnemonic())
                && Objects.equals(digestAlgorithmType(), other.digestAlgorithmType()) && Objects.equals(keyTag(), other.keyTag())
                && Objects.equals(digestValue(), other.digestValue()) && Objects.equals(publicKey(), other.publicKey())
                && Objects.equals(dsRecord(), other.dsRecord()) && Objects.equals(dnskeyRecord(), other.dnskeyRecord())
                && Objects.equals(status(), other.status()) && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeySigningKey").add("Name", name()).add("KmsArn", kmsArn()).add("Flag", flag())
                .add("SigningAlgorithmMnemonic", signingAlgorithmMnemonic()).add("SigningAlgorithmType", signingAlgorithmType())
                .add("DigestAlgorithmMnemonic", digestAlgorithmMnemonic()).add("DigestAlgorithmType", digestAlgorithmType())
                .add("KeyTag", keyTag()).add("DigestValue", digestValue()).add("PublicKey", publicKey())
                .add("DSRecord", dsRecord()).add("DNSKEYRecord", dnskeyRecord()).add("Status", status())
                .add("StatusMessage", statusMessage()).add("CreatedDate", createdDate())
                .add("LastModifiedDate", lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "KmsArn":
            return Optional.ofNullable(clazz.cast(kmsArn()));
        case "Flag":
            return Optional.ofNullable(clazz.cast(flag()));
        case "SigningAlgorithmMnemonic":
            return Optional.ofNullable(clazz.cast(signingAlgorithmMnemonic()));
        case "SigningAlgorithmType":
            return Optional.ofNullable(clazz.cast(signingAlgorithmType()));
        case "DigestAlgorithmMnemonic":
            return Optional.ofNullable(clazz.cast(digestAlgorithmMnemonic()));
        case "DigestAlgorithmType":
            return Optional.ofNullable(clazz.cast(digestAlgorithmType()));
        case "KeyTag":
            return Optional.ofNullable(clazz.cast(keyTag()));
        case "DigestValue":
            return Optional.ofNullable(clazz.cast(digestValue()));
        case "PublicKey":
            return Optional.ofNullable(clazz.cast(publicKey()));
        case "DSRecord":
            return Optional.ofNullable(clazz.cast(dsRecord()));
        case "DNSKEYRecord":
            return Optional.ofNullable(clazz.cast(dnskeyRecord()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StatusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("KmsArn", KMS_ARN_FIELD);
        map.put("Flag", FLAG_FIELD);
        map.put("SigningAlgorithmMnemonic", SIGNING_ALGORITHM_MNEMONIC_FIELD);
        map.put("SigningAlgorithmType", SIGNING_ALGORITHM_TYPE_FIELD);
        map.put("DigestAlgorithmMnemonic", DIGEST_ALGORITHM_MNEMONIC_FIELD);
        map.put("DigestAlgorithmType", DIGEST_ALGORITHM_TYPE_FIELD);
        map.put("KeyTag", KEY_TAG_FIELD);
        map.put("DigestValue", DIGEST_VALUE_FIELD);
        map.put("PublicKey", PUBLIC_KEY_FIELD);
        map.put("DSRecord", DS_RECORD_FIELD);
        map.put("DNSKEYRecord", DNSKEY_RECORD_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeySigningKey, T> g) {
        return obj -> g.apply((KeySigningKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeySigningKey> {
        /**
         * <p>
         * A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters, and
         * underscores (_). <code>Name</code> must be unique for each key-signing key in the same hosted zone.
         * </p>
         * 
         * @param name
         *        A string used to identify a key-signing key (KSK). <code>Name</code> can include numbers, letters, and
         *        underscores (_). <code>Name</code> must be unique for each key-signing key in the same hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon resource name (ARN) used to identify the customer managed key in Key Management Service (KMS). The
         * <code>KmsArn</code> must be unique for each key-signing key (KSK) in a single hosted zone.
         * </p>
         * <p>
         * You must configure the customer managed key as follows:
         * </p>
         * <dl>
         * <dt>Status</dt>
         * <dd>
         * <p>
         * Enabled
         * </p>
         * </dd>
         * <dt>Key spec</dt>
         * <dd>
         * <p>
         * ECC_NIST_P256
         * </p>
         * </dd>
         * <dt>Key usage</dt>
         * <dd>
         * <p>
         * Sign and verify
         * </p>
         * </dd>
         * <dt>Key policy</dt>
         * <dd>
         * <p>
         * The key policy must give permission for the following actions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * DescribeKey
         * </p>
         * </li>
         * <li>
         * <p>
         * GetPublicKey
         * </p>
         * </li>
         * <li>
         * <p>
         * Sign
         * </p>
         * </li>
         * </ul>
         * <p>
         * The key policy must also include the Amazon Route 53 service in the principal for your account. Specify the
         * following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>"Service": "dnssec-route53.amazonaws.com"</code>
         * </p>
         * </li>
         * </ul>
         * </dd>
         * </dl>
         * <p>
         * For more information about working with the customer managed key in KMS, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">Key Management Service
         * concepts</a>.
         * </p>
         * 
         * @param kmsArn
         *        The Amazon resource name (ARN) used to identify the customer managed key in Key Management Service
         *        (KMS). The <code>KmsArn</code> must be unique for each key-signing key (KSK) in a single hosted
         *        zone.</p>
         *        <p>
         *        You must configure the customer managed key as follows:
         *        </p>
         *        <dl>
         *        <dt>Status</dt>
         *        <dd>
         *        <p>
         *        Enabled
         *        </p>
         *        </dd>
         *        <dt>Key spec</dt>
         *        <dd>
         *        <p>
         *        ECC_NIST_P256
         *        </p>
         *        </dd>
         *        <dt>Key usage</dt>
         *        <dd>
         *        <p>
         *        Sign and verify
         *        </p>
         *        </dd>
         *        <dt>Key policy</dt>
         *        <dd>
         *        <p>
         *        The key policy must give permission for the following actions:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        DescribeKey
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        GetPublicKey
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Sign
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The key policy must also include the Amazon Route 53 service in the principal for your account.
         *        Specify the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>"Service": "dnssec-route53.amazonaws.com"</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </dd>
         *        </dl>
         *        <p>
         *        For more information about working with the customer managed key in KMS, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html">Key Management Service
         *        concepts</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsArn(String kmsArn);

        /**
         * <p>
         * An integer that specifies how the key is used. For key-signing key (KSK), this value is always 257.
         * </p>
         * 
         * @param flag
         *        An integer that specifies how the key is used. For key-signing key (KSK), this value is always 257.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flag(Integer flag);

        /**
         * <p>
         * A string used to represent the signing algorithm. This value must follow the guidelines provided by <a
         * href="https://tools.ietf.org/html/rfc8624#section-3.1">RFC-8624 Section 3.1</a>.
         * </p>
         * 
         * @param signingAlgorithmMnemonic
         *        A string used to represent the signing algorithm. This value must follow the guidelines provided by <a
         *        href="https://tools.ietf.org/html/rfc8624#section-3.1">RFC-8624 Section 3.1</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingAlgorithmMnemonic(String signingAlgorithmMnemonic);

        /**
         * <p>
         * An integer used to represent the signing algorithm. This value must follow the guidelines provided by <a
         * href="https://tools.ietf.org/html/rfc8624#section-3.1">RFC-8624 Section 3.1</a>.
         * </p>
         * 
         * @param signingAlgorithmType
         *        An integer used to represent the signing algorithm. This value must follow the guidelines provided by
         *        <a href="https://tools.ietf.org/html/rfc8624#section-3.1">RFC-8624 Section 3.1</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingAlgorithmType(Integer signingAlgorithmType);

        /**
         * <p>
         * A string used to represent the delegation signer digest algorithm. This value must follow the guidelines
         * provided by <a href="https://tools.ietf.org/html/rfc8624#section-3.3">RFC-8624 Section 3.3</a>.
         * </p>
         * 
         * @param digestAlgorithmMnemonic
         *        A string used to represent the delegation signer digest algorithm. This value must follow the
         *        guidelines provided by <a href="https://tools.ietf.org/html/rfc8624#section-3.3">RFC-8624 Section
         *        3.3</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder digestAlgorithmMnemonic(String digestAlgorithmMnemonic);

        /**
         * <p>
         * An integer used to represent the delegation signer digest algorithm. This value must follow the guidelines
         * provided by <a href="https://tools.ietf.org/html/rfc8624#section-3.3">RFC-8624 Section 3.3</a>.
         * </p>
         * 
         * @param digestAlgorithmType
         *        An integer used to represent the delegation signer digest algorithm. This value must follow the
         *        guidelines provided by <a href="https://tools.ietf.org/html/rfc8624#section-3.3">RFC-8624 Section
         *        3.3</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder digestAlgorithmType(Integer digestAlgorithmType);

        /**
         * <p>
         * An integer used to identify the DNSSEC record for the domain name. The process used to calculate the value is
         * described in <a href="https://tools.ietf.org/rfc/rfc4034.txt">RFC-4034 Appendix B</a>.
         * </p>
         * 
         * @param keyTag
         *        An integer used to identify the DNSSEC record for the domain name. The process used to calculate the
         *        value is described in <a href="https://tools.ietf.org/rfc/rfc4034.txt">RFC-4034 Appendix B</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyTag(Integer keyTag);

        /**
         * <p>
         * A cryptographic digest of a DNSKEY resource record (RR). DNSKEY records are used to publish the public key
         * that resolvers can use to verify DNSSEC signatures that are used to secure certain kinds of information
         * provided by the DNS system.
         * </p>
         * 
         * @param digestValue
         *        A cryptographic digest of a DNSKEY resource record (RR). DNSKEY records are used to publish the public
         *        key that resolvers can use to verify DNSSEC signatures that are used to secure certain kinds of
         *        information provided by the DNS system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder digestValue(String digestValue);

        /**
         * <p>
         * The public key, represented as a Base64 encoding, as required by <a
         * href="https://tools.ietf.org/rfc/rfc4034.txt"> RFC-4034 Page 5</a>.
         * </p>
         * 
         * @param publicKey
         *        The public key, represented as a Base64 encoding, as required by <a
         *        href="https://tools.ietf.org/rfc/rfc4034.txt"> RFC-4034 Page 5</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKey(String publicKey);

        /**
         * <p>
         * A string that represents a delegation signer (DS) record.
         * </p>
         * 
         * @param dsRecord
         *        A string that represents a delegation signer (DS) record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dsRecord(String dsRecord);

        /**
         * <p>
         * A string that represents a DNSKEY record.
         * </p>
         * 
         * @param dnskeyRecord
         *        A string that represents a DNSKEY record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnskeyRecord(String dnskeyRecord);

        /**
         * <p>
         * A string that represents the current key-signing key (KSK) status.
         * </p>
         * <p>
         * Status can have one of the following values:
         * </p>
         * <dl>
         * <dt>ACTIVE</dt>
         * <dd>
         * <p>
         * The KSK is being used for signing.
         * </p>
         * </dd>
         * <dt>INACTIVE</dt>
         * <dd>
         * <p>
         * The KSK is not being used for signing.
         * </p>
         * </dd>
         * <dt>DELETING</dt>
         * <dd>
         * <p>
         * The KSK is in the process of being deleted.
         * </p>
         * </dd>
         * <dt>ACTION_NEEDED</dt>
         * <dd>
         * <p>
         * There is a problem with the KSK that requires you to take action to resolve. For example, the customer
         * managed key might have been deleted, or the permissions for the customer managed key might have been changed.
         * </p>
         * </dd>
         * <dt>INTERNAL_FAILURE</dt>
         * <dd>
         * <p>
         * There was an error during a request. Before you can continue to work with DNSSEC signing, including actions
         * that involve this KSK, you must correct the problem. For example, you may need to activate or deactivate the
         * KSK.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        A string that represents the current key-signing key (KSK) status.</p>
         *        <p>
         *        Status can have one of the following values:
         *        </p>
         *        <dl>
         *        <dt>ACTIVE</dt>
         *        <dd>
         *        <p>
         *        The KSK is being used for signing.
         *        </p>
         *        </dd>
         *        <dt>INACTIVE</dt>
         *        <dd>
         *        <p>
         *        The KSK is not being used for signing.
         *        </p>
         *        </dd>
         *        <dt>DELETING</dt>
         *        <dd>
         *        <p>
         *        The KSK is in the process of being deleted.
         *        </p>
         *        </dd>
         *        <dt>ACTION_NEEDED</dt>
         *        <dd>
         *        <p>
         *        There is a problem with the KSK that requires you to take action to resolve. For example, the customer
         *        managed key might have been deleted, or the permissions for the customer managed key might have been
         *        changed.
         *        </p>
         *        </dd>
         *        <dt>INTERNAL_FAILURE</dt>
         *        <dd>
         *        <p>
         *        There was an error during a request. Before you can continue to work with DNSSEC signing, including
         *        actions that involve this KSK, you must correct the problem. For example, you may need to activate or
         *        deactivate the KSK.
         *        </p>
         *        </dd>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The status message provided for the following key-signing key (KSK) statuses: <code>ACTION_NEEDED</code> or
         * <code>INTERNAL_FAILURE</code>. The status message includes information about what the problem might be and
         * steps that you can take to correct the issue.
         * </p>
         * 
         * @param statusMessage
         *        The status message provided for the following key-signing key (KSK) statuses:
         *        <code>ACTION_NEEDED</code> or <code>INTERNAL_FAILURE</code>. The status message includes information
         *        about what the problem might be and steps that you can take to correct the issue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The date when the key-signing key (KSK) was created.
         * </p>
         * 
         * @param createdDate
         *        The date when the key-signing key (KSK) was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The last time that the key-signing key (KSK) was changed.
         * </p>
         * 
         * @param lastModifiedDate
         *        The last time that the key-signing key (KSK) was changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String kmsArn;

        private Integer flag;

        private String signingAlgorithmMnemonic;

        private Integer signingAlgorithmType;

        private String digestAlgorithmMnemonic;

        private Integer digestAlgorithmType;

        private Integer keyTag;

        private String digestValue;

        private String publicKey;

        private String dsRecord;

        private String dnskeyRecord;

        private String status;

        private String statusMessage;

        private Instant createdDate;

        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(KeySigningKey model) {
            name(model.name);
            kmsArn(model.kmsArn);
            flag(model.flag);
            signingAlgorithmMnemonic(model.signingAlgorithmMnemonic);
            signingAlgorithmType(model.signingAlgorithmType);
            digestAlgorithmMnemonic(model.digestAlgorithmMnemonic);
            digestAlgorithmType(model.digestAlgorithmType);
            keyTag(model.keyTag);
            digestValue(model.digestValue);
            publicKey(model.publicKey);
            dsRecord(model.dsRecord);
            dnskeyRecord(model.dnskeyRecord);
            status(model.status);
            statusMessage(model.statusMessage);
            createdDate(model.createdDate);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getKmsArn() {
            return kmsArn;
        }

        public final void setKmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
        }

        @Override
        public final Builder kmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
            return this;
        }

        public final Integer getFlag() {
            return flag;
        }

        public final void setFlag(Integer flag) {
            this.flag = flag;
        }

        @Override
        public final Builder flag(Integer flag) {
            this.flag = flag;
            return this;
        }

        public final String getSigningAlgorithmMnemonic() {
            return signingAlgorithmMnemonic;
        }

        public final void setSigningAlgorithmMnemonic(String signingAlgorithmMnemonic) {
            this.signingAlgorithmMnemonic = signingAlgorithmMnemonic;
        }

        @Override
        public final Builder signingAlgorithmMnemonic(String signingAlgorithmMnemonic) {
            this.signingAlgorithmMnemonic = signingAlgorithmMnemonic;
            return this;
        }

        public final Integer getSigningAlgorithmType() {
            return signingAlgorithmType;
        }

        public final void setSigningAlgorithmType(Integer signingAlgorithmType) {
            this.signingAlgorithmType = signingAlgorithmType;
        }

        @Override
        public final Builder signingAlgorithmType(Integer signingAlgorithmType) {
            this.signingAlgorithmType = signingAlgorithmType;
            return this;
        }

        public final String getDigestAlgorithmMnemonic() {
            return digestAlgorithmMnemonic;
        }

        public final void setDigestAlgorithmMnemonic(String digestAlgorithmMnemonic) {
            this.digestAlgorithmMnemonic = digestAlgorithmMnemonic;
        }

        @Override
        public final Builder digestAlgorithmMnemonic(String digestAlgorithmMnemonic) {
            this.digestAlgorithmMnemonic = digestAlgorithmMnemonic;
            return this;
        }

        public final Integer getDigestAlgorithmType() {
            return digestAlgorithmType;
        }

        public final void setDigestAlgorithmType(Integer digestAlgorithmType) {
            this.digestAlgorithmType = digestAlgorithmType;
        }

        @Override
        public final Builder digestAlgorithmType(Integer digestAlgorithmType) {
            this.digestAlgorithmType = digestAlgorithmType;
            return this;
        }

        public final Integer getKeyTag() {
            return keyTag;
        }

        public final void setKeyTag(Integer keyTag) {
            this.keyTag = keyTag;
        }

        @Override
        public final Builder keyTag(Integer keyTag) {
            this.keyTag = keyTag;
            return this;
        }

        public final String getDigestValue() {
            return digestValue;
        }

        public final void setDigestValue(String digestValue) {
            this.digestValue = digestValue;
        }

        @Override
        public final Builder digestValue(String digestValue) {
            this.digestValue = digestValue;
            return this;
        }

        public final String getPublicKey() {
            return publicKey;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        @Override
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public final String getDsRecord() {
            return dsRecord;
        }

        public final void setDsRecord(String dsRecord) {
            this.dsRecord = dsRecord;
        }

        @Override
        public final Builder dsRecord(String dsRecord) {
            this.dsRecord = dsRecord;
            return this;
        }

        public final String getDnskeyRecord() {
            return dnskeyRecord;
        }

        public final void setDnskeyRecord(String dnskeyRecord) {
            this.dnskeyRecord = dnskeyRecord;
        }

        @Override
        public final Builder dnskeyRecord(String dnskeyRecord) {
            this.dnskeyRecord = dnskeyRecord;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public KeySigningKey build() {
            return new KeySigningKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
