/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.route53.model.RecordDataCopier;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestDnsAnswerResponse
extends Route53Response
implements ToCopyableBuilder<Builder, TestDnsAnswerResponse> {
    private static final SdkField<String> NAMESERVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Nameserver").getter(TestDnsAnswerResponse.getter(TestDnsAnswerResponse::nameserver)).setter(TestDnsAnswerResponse.setter(Builder::nameserver)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Nameserver").unmarshallLocationName("Nameserver").build()}).build();
    private static final SdkField<String> RECORD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordName").getter(TestDnsAnswerResponse.getter(TestDnsAnswerResponse::recordName)).setter(TestDnsAnswerResponse.setter(Builder::recordName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordName").unmarshallLocationName("RecordName").build()}).build();
    private static final SdkField<String> RECORD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordType").getter(TestDnsAnswerResponse.getter(TestDnsAnswerResponse::recordTypeAsString)).setter(TestDnsAnswerResponse.setter(Builder::recordType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordType").unmarshallLocationName("RecordType").build()}).build();
    private static final SdkField<List<String>> RECORD_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecordData").getter(TestDnsAnswerResponse.getter(TestDnsAnswerResponse::recordData)).setter(TestDnsAnswerResponse.setter(Builder::recordData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordData").unmarshallLocationName("RecordData").build(), ListTrait.builder().memberLocationName("RecordDataEntry").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordDataEntry").unmarshallLocationName("RecordDataEntry").build()}).build()).build()}).build();
    private static final SdkField<String> RESPONSE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResponseCode").getter(TestDnsAnswerResponse.getter(TestDnsAnswerResponse::responseCode)).setter(TestDnsAnswerResponse.setter(Builder::responseCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseCode").unmarshallLocationName("ResponseCode").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(TestDnsAnswerResponse.getter(TestDnsAnswerResponse::protocol)).setter(TestDnsAnswerResponse.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").unmarshallLocationName("Protocol").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESERVER_FIELD, RECORD_NAME_FIELD, RECORD_TYPE_FIELD, RECORD_DATA_FIELD, RESPONSE_CODE_FIELD, PROTOCOL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TestDnsAnswerResponse.memberNameToFieldInitializer();
    private final String nameserver;
    private final String recordName;
    private final String recordType;
    private final List<String> recordData;
    private final String responseCode;
    private final String protocol;

    private TestDnsAnswerResponse(BuilderImpl builder) {
        super(builder);
        this.nameserver = builder.nameserver;
        this.recordName = builder.recordName;
        this.recordType = builder.recordType;
        this.recordData = builder.recordData;
        this.responseCode = builder.responseCode;
        this.protocol = builder.protocol;
    }

    public final String nameserver() {
        return this.nameserver;
    }

    public final String recordName() {
        return this.recordName;
    }

    public final RRType recordType() {
        return RRType.fromValue(this.recordType);
    }

    public final String recordTypeAsString() {
        return this.recordType;
    }

    public final boolean hasRecordData() {
        return this.recordData != null && !(this.recordData instanceof SdkAutoConstructList);
    }

    public final List<String> recordData() {
        return this.recordData;
    }

    public final String responseCode() {
        return this.responseCode;
    }

    public final String protocol() {
        return this.protocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nameserver());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecordData() ? this.recordData() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.responseCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocol());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestDnsAnswerResponse)) {
            return false;
        }
        TestDnsAnswerResponse other = (TestDnsAnswerResponse)((Object)obj);
        return Objects.equals(this.nameserver(), other.nameserver()) && Objects.equals(this.recordName(), other.recordName()) && Objects.equals(this.recordTypeAsString(), other.recordTypeAsString()) && this.hasRecordData() == other.hasRecordData() && Objects.equals(this.recordData(), other.recordData()) && Objects.equals(this.responseCode(), other.responseCode()) && Objects.equals(this.protocol(), other.protocol());
    }

    public final String toString() {
        return ToString.builder((String)"TestDnsAnswerResponse").add("Nameserver", (Object)this.nameserver()).add("RecordName", (Object)this.recordName()).add("RecordType", (Object)this.recordTypeAsString()).add("RecordData", this.hasRecordData() ? this.recordData() : null).add("ResponseCode", (Object)this.responseCode()).add("Protocol", (Object)this.protocol()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Nameserver": {
                return Optional.ofNullable(clazz.cast(this.nameserver()));
            }
            case "RecordName": {
                return Optional.ofNullable(clazz.cast(this.recordName()));
            }
            case "RecordType": {
                return Optional.ofNullable(clazz.cast(this.recordTypeAsString()));
            }
            case "RecordData": {
                return Optional.ofNullable(clazz.cast(this.recordData()));
            }
            case "ResponseCode": {
                return Optional.ofNullable(clazz.cast(this.responseCode()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocol()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Nameserver", NAMESERVER_FIELD);
        map.put("RecordName", RECORD_NAME_FIELD);
        map.put("RecordType", RECORD_TYPE_FIELD);
        map.put("RecordData", RECORD_DATA_FIELD);
        map.put("ResponseCode", RESPONSE_CODE_FIELD);
        map.put("Protocol", PROTOCOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestDnsAnswerResponse, T> g) {
        return obj -> g.apply((TestDnsAnswerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private String nameserver;
        private String recordName;
        private String recordType;
        private List<String> recordData = DefaultSdkAutoConstructList.getInstance();
        private String responseCode;
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(TestDnsAnswerResponse model) {
            super(model);
            this.nameserver(model.nameserver);
            this.recordName(model.recordName);
            this.recordType(model.recordType);
            this.recordData(model.recordData);
            this.responseCode(model.responseCode);
            this.protocol(model.protocol);
        }

        public final String getNameserver() {
            return this.nameserver;
        }

        public final void setNameserver(String nameserver) {
            this.nameserver = nameserver;
        }

        @Override
        public final Builder nameserver(String nameserver) {
            this.nameserver = nameserver;
            return this;
        }

        public final String getRecordName() {
            return this.recordName;
        }

        public final void setRecordName(String recordName) {
            this.recordName = recordName;
        }

        @Override
        public final Builder recordName(String recordName) {
            this.recordName = recordName;
            return this;
        }

        public final String getRecordType() {
            return this.recordType;
        }

        public final void setRecordType(String recordType) {
            this.recordType = recordType;
        }

        @Override
        public final Builder recordType(String recordType) {
            this.recordType = recordType;
            return this;
        }

        @Override
        public final Builder recordType(RRType recordType) {
            this.recordType(recordType == null ? null : recordType.toString());
            return this;
        }

        public final Collection<String> getRecordData() {
            if (this.recordData instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recordData;
        }

        public final void setRecordData(Collection<String> recordData) {
            this.recordData = RecordDataCopier.copy(recordData);
        }

        @Override
        public final Builder recordData(Collection<String> recordData) {
            this.recordData = RecordDataCopier.copy(recordData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordData(String ... recordData) {
            this.recordData(Arrays.asList(recordData));
            return this;
        }

        public final String getResponseCode() {
            return this.responseCode;
        }

        public final void setResponseCode(String responseCode) {
            this.responseCode = responseCode;
        }

        @Override
        public final Builder responseCode(String responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public TestDnsAnswerResponse build() {
            return new TestDnsAnswerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestDnsAnswerResponse> {
        public Builder nameserver(String var1);

        public Builder recordName(String var1);

        public Builder recordType(String var1);

        public Builder recordType(RRType var1);

        public Builder recordData(Collection<String> var1);

        public Builder recordData(String ... var1);

        public Builder responseCode(String var1);

        public Builder protocol(String var1);
    }
}

