/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HealthCheckRegion {
    US_EAST_1("us-east-1"),
    US_WEST_1("us-west-1"),
    US_WEST_2("us-west-2"),
    EU_WEST_1("eu-west-1"),
    AP_SOUTHEAST_1("ap-southeast-1"),
    AP_SOUTHEAST_2("ap-southeast-2"),
    AP_NORTHEAST_1("ap-northeast-1"),
    SA_EAST_1("sa-east-1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HealthCheckRegion> VALUE_MAP;
    private final String value;

    private HealthCheckRegion(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HealthCheckRegion fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HealthCheckRegion> knownValues() {
        EnumSet<HealthCheckRegion> knownValues = EnumSet.allOf(HealthCheckRegion.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HealthCheckRegion.class, HealthCheckRegion::toString);
    }
}

