/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.AccountLimit;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAccountLimitResponse
extends Route53Response
implements ToCopyableBuilder<Builder, GetAccountLimitResponse> {
    private static final SdkField<AccountLimit> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Limit").getter(GetAccountLimitResponse.getter(GetAccountLimitResponse::limit)).setter(GetAccountLimitResponse.setter(Builder::limit)).constructor(AccountLimit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").unmarshallLocationName("Limit").build()}).build();
    private static final SdkField<Long> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Count").getter(GetAccountLimitResponse.getter(GetAccountLimitResponse::count)).setter(GetAccountLimitResponse.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").unmarshallLocationName("Count").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD, COUNT_FIELD));
    private final AccountLimit limit;
    private final Long count;

    private GetAccountLimitResponse(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.count = builder.count;
    }

    public final AccountLimit limit() {
        return this.limit;
    }

    public final Long count() {
        return this.count;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccountLimitResponse)) {
            return false;
        }
        GetAccountLimitResponse other = (GetAccountLimitResponse)((Object)obj);
        return Objects.equals(this.limit(), other.limit()) && Objects.equals(this.count(), other.count());
    }

    public final String toString() {
        return ToString.builder((String)"GetAccountLimitResponse").add("Limit", (Object)this.limit()).add("Count", (Object)this.count()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccountLimitResponse, T> g) {
        return obj -> g.apply((GetAccountLimitResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private AccountLimit limit;
        private Long count;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccountLimitResponse model) {
            super(model);
            this.limit(model.limit);
            this.count(model.count);
        }

        public final AccountLimit.Builder getLimit() {
            return this.limit != null ? this.limit.toBuilder() : null;
        }

        public final void setLimit(AccountLimit.BuilderImpl limit) {
            this.limit = limit != null ? limit.build() : null;
        }

        @Override
        @Transient
        public final Builder limit(AccountLimit limit) {
            this.limit = limit;
            return this;
        }

        public final Long getCount() {
            return this.count;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        @Transient
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        @Override
        public GetAccountLimitResponse build() {
            return new GetAccountLimitResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAccountLimitResponse> {
        public Builder limit(AccountLimit var1);

        default public Builder limit(Consumer<AccountLimit.Builder> limit) {
            return this.limit((AccountLimit)((AccountLimit.Builder)AccountLimit.builder().applyMutation(limit)).build());
        }

        public Builder count(Long var1);
    }
}

