/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GeoLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GeoLocation> {
    private static final SdkField<String> CONTINENT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContinentCode").getter(GeoLocation.getter(GeoLocation::continentCode)).setter(GeoLocation.setter(Builder::continentCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinentCode").unmarshallLocationName("ContinentCode").build()}).build();
    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CountryCode").getter(GeoLocation.getter(GeoLocation::countryCode)).setter(GeoLocation.setter(Builder::countryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode").unmarshallLocationName("CountryCode").build()}).build();
    private static final SdkField<String> SUBDIVISION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubdivisionCode").getter(GeoLocation.getter(GeoLocation::subdivisionCode)).setter(GeoLocation.setter(Builder::subdivisionCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubdivisionCode").unmarshallLocationName("SubdivisionCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTINENT_CODE_FIELD, COUNTRY_CODE_FIELD, SUBDIVISION_CODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String continentCode;
    private final String countryCode;
    private final String subdivisionCode;

    private GeoLocation(BuilderImpl builder) {
        this.continentCode = builder.continentCode;
        this.countryCode = builder.countryCode;
        this.subdivisionCode = builder.subdivisionCode;
    }

    public final String continentCode() {
        return this.continentCode;
    }

    public final String countryCode() {
        return this.countryCode;
    }

    public final String subdivisionCode() {
        return this.subdivisionCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.continentCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.countryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.subdivisionCode());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeoLocation)) {
            return false;
        }
        GeoLocation other = (GeoLocation)obj;
        return Objects.equals(this.continentCode(), other.continentCode()) && Objects.equals(this.countryCode(), other.countryCode()) && Objects.equals(this.subdivisionCode(), other.subdivisionCode());
    }

    public final String toString() {
        return ToString.builder((String)"GeoLocation").add("ContinentCode", (Object)this.continentCode()).add("CountryCode", (Object)this.countryCode()).add("SubdivisionCode", (Object)this.subdivisionCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContinentCode": {
                return Optional.ofNullable(clazz.cast(this.continentCode()));
            }
            case "CountryCode": {
                return Optional.ofNullable(clazz.cast(this.countryCode()));
            }
            case "SubdivisionCode": {
                return Optional.ofNullable(clazz.cast(this.subdivisionCode()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeoLocation, T> g) {
        return obj -> g.apply((GeoLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String continentCode;
        private String countryCode;
        private String subdivisionCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GeoLocation model) {
            this.continentCode(model.continentCode);
            this.countryCode(model.countryCode);
            this.subdivisionCode(model.subdivisionCode);
        }

        public final String getContinentCode() {
            return this.continentCode;
        }

        public final void setContinentCode(String continentCode) {
            this.continentCode = continentCode;
        }

        @Override
        public final Builder continentCode(String continentCode) {
            this.continentCode = continentCode;
            return this;
        }

        public final String getCountryCode() {
            return this.countryCode;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        public final String getSubdivisionCode() {
            return this.subdivisionCode;
        }

        public final void setSubdivisionCode(String subdivisionCode) {
            this.subdivisionCode = subdivisionCode;
        }

        @Override
        public final Builder subdivisionCode(String subdivisionCode) {
            this.subdivisionCode = subdivisionCode;
            return this;
        }

        public GeoLocation build() {
            return new GeoLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GeoLocation> {
        public Builder continentCode(String var1);

        public Builder countryCode(String var1);

        public Builder subdivisionCode(String var1);
    }
}

