/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Statistic {
    AVERAGE("Average"),
    SUM("Sum"),
    SAMPLE_COUNT("SampleCount"),
    MAXIMUM("Maximum"),
    MINIMUM("Minimum"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Statistic(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Statistic fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Statistic.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Statistic> knownValues() {
        return Stream.of(Statistic.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

