/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.HealthCheck;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateHealthCheckResponse
extends Route53Response
implements ToCopyableBuilder<Builder, CreateHealthCheckResponse> {
    private static final SdkField<HealthCheck> HEALTH_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HealthCheck").getter(CreateHealthCheckResponse.getter(CreateHealthCheckResponse::healthCheck)).setter(CreateHealthCheckResponse.setter(Builder::healthCheck)).constructor(HealthCheck::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheck").unmarshallLocationName("HealthCheck").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(CreateHealthCheckResponse.getter(CreateHealthCheckResponse::location)).setter(CreateHealthCheckResponse.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Location").unmarshallLocationName("Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_CHECK_FIELD, LOCATION_FIELD));
    private final HealthCheck healthCheck;
    private final String location;

    private CreateHealthCheckResponse(BuilderImpl builder) {
        super(builder);
        this.healthCheck = builder.healthCheck;
        this.location = builder.location;
    }

    public HealthCheck healthCheck() {
        return this.healthCheck;
    }

    public String location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHealthCheckResponse)) {
            return false;
        }
        CreateHealthCheckResponse other = (CreateHealthCheckResponse)((Object)obj);
        return Objects.equals(this.healthCheck(), other.healthCheck()) && Objects.equals(this.location(), other.location());
    }

    public String toString() {
        return ToString.builder((String)"CreateHealthCheckResponse").add("HealthCheck", (Object)this.healthCheck()).add("Location", (Object)this.location()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HealthCheck": {
                return Optional.ofNullable(clazz.cast(this.healthCheck()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateHealthCheckResponse, T> g) {
        return obj -> g.apply((CreateHealthCheckResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private HealthCheck healthCheck;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHealthCheckResponse model) {
            super(model);
            this.healthCheck(model.healthCheck);
            this.location(model.location);
        }

        public final HealthCheck.Builder getHealthCheck() {
            return this.healthCheck != null ? this.healthCheck.toBuilder() : null;
        }

        @Override
        public final Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final void setHealthCheck(HealthCheck.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public CreateHealthCheckResponse build() {
            return new CreateHealthCheckResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateHealthCheckResponse> {
        public Builder healthCheck(HealthCheck var1);

        default public Builder healthCheck(Consumer<HealthCheck.Builder> healthCheck) {
            return this.healthCheck((HealthCheck)((HealthCheck.Builder)HealthCheck.builder().applyMutation(healthCheck)).build());
        }

        public Builder location(String var1);
    }
}

