/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.services.route53.Route53Client;
import software.amazon.awssdk.services.route53.model.AssociateVpcWithHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.AssociateVpcWithHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ChangeTagsForResourceRequest;
import software.amazon.awssdk.services.route53.model.ChangeTagsForResourceResponse;
import software.amazon.awssdk.services.route53.model.ConcurrentModificationException;
import software.amazon.awssdk.services.route53.model.ConflictingDomainExistsException;
import software.amazon.awssdk.services.route53.model.ConflictingTypesException;
import software.amazon.awssdk.services.route53.model.CreateHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.CreateHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.CreateHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.CreateHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigRequest;
import software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigResponse;
import software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetRequest;
import software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyRequest;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyResponse;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionRequest;
import software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionResponse;
import software.amazon.awssdk.services.route53.model.CreateVpcAssociationAuthorizationRequest;
import software.amazon.awssdk.services.route53.model.CreateVpcAssociationAuthorizationResponse;
import software.amazon.awssdk.services.route53.model.DelegationSetAlreadyCreatedException;
import software.amazon.awssdk.services.route53.model.DelegationSetAlreadyReusableException;
import software.amazon.awssdk.services.route53.model.DelegationSetInUseException;
import software.amazon.awssdk.services.route53.model.DelegationSetNotAvailableException;
import software.amazon.awssdk.services.route53.model.DelegationSetNotReusableException;
import software.amazon.awssdk.services.route53.model.DeleteHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.DeleteHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.DeleteHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.DeleteHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.DeleteQueryLoggingConfigRequest;
import software.amazon.awssdk.services.route53.model.DeleteQueryLoggingConfigResponse;
import software.amazon.awssdk.services.route53.model.DeleteReusableDelegationSetRequest;
import software.amazon.awssdk.services.route53.model.DeleteReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyRequest;
import software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyResponse;
import software.amazon.awssdk.services.route53.model.DeleteVpcAssociationAuthorizationRequest;
import software.amazon.awssdk.services.route53.model.DeleteVpcAssociationAuthorizationResponse;
import software.amazon.awssdk.services.route53.model.DisassociateVpcFromHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.DisassociateVpcFromHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.GetAccountLimitRequest;
import software.amazon.awssdk.services.route53.model.GetAccountLimitResponse;
import software.amazon.awssdk.services.route53.model.GetChangeRequest;
import software.amazon.awssdk.services.route53.model.GetChangeResponse;
import software.amazon.awssdk.services.route53.model.GetCheckerIpRangesRequest;
import software.amazon.awssdk.services.route53.model.GetCheckerIpRangesResponse;
import software.amazon.awssdk.services.route53.model.GetGeoLocationRequest;
import software.amazon.awssdk.services.route53.model.GetGeoLocationResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckCountRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckCountResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.GetHealthCheckStatusRequest;
import software.amazon.awssdk.services.route53.model.GetHealthCheckStatusResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneCountRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneCountResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneLimitRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneLimitResponse;
import software.amazon.awssdk.services.route53.model.GetHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.GetHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.GetQueryLoggingConfigRequest;
import software.amazon.awssdk.services.route53.model.GetQueryLoggingConfigResponse;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitRequest;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitResponse;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetRequest;
import software.amazon.awssdk.services.route53.model.GetReusableDelegationSetResponse;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceCountRequest;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceCountResponse;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyRequest;
import software.amazon.awssdk.services.route53.model.GetTrafficPolicyResponse;
import software.amazon.awssdk.services.route53.model.HealthCheckAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.HealthCheckVersionMismatchException;
import software.amazon.awssdk.services.route53.model.HostedZoneAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.HostedZoneNotEmptyException;
import software.amazon.awssdk.services.route53.model.HostedZoneNotFoundException;
import software.amazon.awssdk.services.route53.model.HostedZoneNotPrivateException;
import software.amazon.awssdk.services.route53.model.IncompatibleVersionException;
import software.amazon.awssdk.services.route53.model.InsufficientCloudWatchLogsResourcePolicyException;
import software.amazon.awssdk.services.route53.model.InvalidArgumentException;
import software.amazon.awssdk.services.route53.model.InvalidChangeBatchException;
import software.amazon.awssdk.services.route53.model.InvalidDomainNameException;
import software.amazon.awssdk.services.route53.model.InvalidInputException;
import software.amazon.awssdk.services.route53.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.route53.model.InvalidTrafficPolicyDocumentException;
import software.amazon.awssdk.services.route53.model.InvalidVpcIdException;
import software.amazon.awssdk.services.route53.model.LastVpcAssociationException;
import software.amazon.awssdk.services.route53.model.LimitsExceededException;
import software.amazon.awssdk.services.route53.model.ListGeoLocationsRequest;
import software.amazon.awssdk.services.route53.model.ListGeoLocationsResponse;
import software.amazon.awssdk.services.route53.model.ListHealthChecksRequest;
import software.amazon.awssdk.services.route53.model.ListHealthChecksResponse;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByNameResponse;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByVpcRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesByVpcResponse;
import software.amazon.awssdk.services.route53.model.ListHostedZonesRequest;
import software.amazon.awssdk.services.route53.model.ListHostedZonesResponse;
import software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest;
import software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsResponse;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest;
import software.amazon.awssdk.services.route53.model.ListResourceRecordSetsResponse;
import software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsRequest;
import software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsResponse;
import software.amazon.awssdk.services.route53.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.route53.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.route53.model.ListTagsForResourcesRequest;
import software.amazon.awssdk.services.route53.model.ListTagsForResourcesResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPoliciesRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPoliciesResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByPolicyResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesResponse;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsRequest;
import software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsResponse;
import software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsRequest;
import software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsResponse;
import software.amazon.awssdk.services.route53.model.NoSuchChangeException;
import software.amazon.awssdk.services.route53.model.NoSuchCloudWatchLogsLogGroupException;
import software.amazon.awssdk.services.route53.model.NoSuchDelegationSetException;
import software.amazon.awssdk.services.route53.model.NoSuchGeoLocationException;
import software.amazon.awssdk.services.route53.model.NoSuchHealthCheckException;
import software.amazon.awssdk.services.route53.model.NoSuchHostedZoneException;
import software.amazon.awssdk.services.route53.model.NoSuchQueryLoggingConfigException;
import software.amazon.awssdk.services.route53.model.NoSuchTrafficPolicyException;
import software.amazon.awssdk.services.route53.model.NoSuchTrafficPolicyInstanceException;
import software.amazon.awssdk.services.route53.model.NotAuthorizedException;
import software.amazon.awssdk.services.route53.model.PriorRequestNotCompleteException;
import software.amazon.awssdk.services.route53.model.PublicZoneVpcAssociationException;
import software.amazon.awssdk.services.route53.model.QueryLoggingConfigAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.Route53Exception;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.services.route53.model.TestDnsAnswerRequest;
import software.amazon.awssdk.services.route53.model.TestDnsAnswerResponse;
import software.amazon.awssdk.services.route53.model.ThrottlingException;
import software.amazon.awssdk.services.route53.model.TooManyHealthChecksException;
import software.amazon.awssdk.services.route53.model.TooManyHostedZonesException;
import software.amazon.awssdk.services.route53.model.TooManyTrafficPoliciesException;
import software.amazon.awssdk.services.route53.model.TooManyTrafficPolicyInstancesException;
import software.amazon.awssdk.services.route53.model.TooManyTrafficPolicyVersionsForCurrentPolicyException;
import software.amazon.awssdk.services.route53.model.TooManyVpcAssociationAuthorizationsException;
import software.amazon.awssdk.services.route53.model.TrafficPolicyAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.TrafficPolicyInUseException;
import software.amazon.awssdk.services.route53.model.TrafficPolicyInstanceAlreadyExistsException;
import software.amazon.awssdk.services.route53.model.UpdateHealthCheckRequest;
import software.amazon.awssdk.services.route53.model.UpdateHealthCheckResponse;
import software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentRequest;
import software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentResponse;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyCommentRequest;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyCommentResponse;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceRequest;
import software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceResponse;
import software.amazon.awssdk.services.route53.model.VpcAssociationAuthorizationNotFoundException;
import software.amazon.awssdk.services.route53.model.VpcAssociationNotFoundException;
import software.amazon.awssdk.services.route53.paginators.ListHealthChecksIterable;
import software.amazon.awssdk.services.route53.paginators.ListHostedZonesIterable;
import software.amazon.awssdk.services.route53.paginators.ListQueryLoggingConfigsIterable;
import software.amazon.awssdk.services.route53.paginators.ListResourceRecordSetsIterable;
import software.amazon.awssdk.services.route53.transform.AssociateVpcWithHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ChangeResourceRecordSetsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ChangeTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateQueryLoggingConfigRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateReusableDelegationSetRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateTrafficPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateTrafficPolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.CreateVpcAssociationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteQueryLoggingConfigRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteReusableDelegationSetRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteTrafficPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DeleteVpcAssociationAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.DisassociateVpcFromHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetAccountLimitRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetChangeRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetCheckerIpRangesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetGeoLocationRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckCountRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckLastFailureReasonRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHealthCheckStatusRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHostedZoneCountRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHostedZoneLimitRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetQueryLoggingConfigRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetReusableDelegationSetLimitRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetReusableDelegationSetRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetTrafficPolicyInstanceCountRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetTrafficPolicyInstanceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.GetTrafficPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListGeoLocationsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListHealthChecksRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListHostedZonesByNameRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListHostedZonesByVpcRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListHostedZonesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListQueryLoggingConfigsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListResourceRecordSetsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListReusableDelegationSetsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTagsForResourcesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPoliciesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyInstancesByHostedZoneRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyInstancesByPolicyRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyInstancesRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListTrafficPolicyVersionsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.ListVpcAssociationAuthorizationsRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.TestDnsAnswerRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateHealthCheckRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateHostedZoneCommentRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateTrafficPolicyCommentRequestMarshaller;
import software.amazon.awssdk.services.route53.transform.UpdateTrafficPolicyInstanceRequestMarshaller;

@SdkInternalApi
final class DefaultRoute53Client
implements Route53Client {
    private final SyncClientHandler clientHandler;
    private final AwsXmlProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRoute53Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "route53";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateVpcWithHostedZoneResponse associateVPCWithHostedZone(AssociateVpcWithHostedZoneRequest associateVpcWithHostedZoneRequest) throws NoSuchHostedZoneException, NotAuthorizedException, InvalidVpcIdException, InvalidInputException, PublicZoneVpcAssociationException, ConflictingDomainExistsException, LimitsExceededException, PriorRequestNotCompleteException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(AssociateVpcWithHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateVPCWithHostedZone");
            AssociateVpcWithHostedZoneResponse associateVpcWithHostedZoneResponse = (AssociateVpcWithHostedZoneResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateVPCWithHostedZone").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)associateVpcWithHostedZoneRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new AssociateVpcWithHostedZoneRequestMarshaller(this.protocolFactory)));
            return associateVpcWithHostedZoneResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, associateVpcWithHostedZoneRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChangeResourceRecordSetsResponse changeResourceRecordSets(ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest) throws NoSuchHostedZoneException, NoSuchHealthCheckException, InvalidChangeBatchException, InvalidInputException, PriorRequestNotCompleteException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ChangeResourceRecordSetsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ChangeResourceRecordSets");
            ChangeResourceRecordSetsResponse changeResourceRecordSetsResponse = (ChangeResourceRecordSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ChangeResourceRecordSets").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)changeResourceRecordSetsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ChangeResourceRecordSetsRequestMarshaller(this.protocolFactory)));
            return changeResourceRecordSetsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, changeResourceRecordSetsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChangeTagsForResourceResponse changeTagsForResource(ChangeTagsForResourceRequest changeTagsForResourceRequest) throws InvalidInputException, NoSuchHealthCheckException, NoSuchHostedZoneException, PriorRequestNotCompleteException, ThrottlingException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ChangeTagsForResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ChangeTagsForResource");
            ChangeTagsForResourceResponse changeTagsForResourceResponse = (ChangeTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ChangeTagsForResource").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)changeTagsForResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ChangeTagsForResourceRequestMarshaller(this.protocolFactory)));
            return changeTagsForResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, changeTagsForResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateHealthCheckResponse createHealthCheck(CreateHealthCheckRequest createHealthCheckRequest) throws TooManyHealthChecksException, HealthCheckAlreadyExistsException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateHealthCheckResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHealthCheck");
            CreateHealthCheckResponse createHealthCheckResponse = (CreateHealthCheckResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHealthCheck").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createHealthCheckRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateHealthCheckRequestMarshaller(this.protocolFactory)));
            return createHealthCheckResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, createHealthCheckRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateHostedZoneResponse createHostedZone(CreateHostedZoneRequest createHostedZoneRequest) throws InvalidDomainNameException, HostedZoneAlreadyExistsException, TooManyHostedZonesException, InvalidVpcIdException, InvalidInputException, DelegationSetNotAvailableException, ConflictingDomainExistsException, NoSuchDelegationSetException, DelegationSetNotReusableException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateHostedZone");
            CreateHostedZoneResponse createHostedZoneResponse = (CreateHostedZoneResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateHostedZone").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createHostedZoneRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateHostedZoneRequestMarshaller(this.protocolFactory)));
            return createHostedZoneResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, createHostedZoneRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateQueryLoggingConfigResponse createQueryLoggingConfig(CreateQueryLoggingConfigRequest createQueryLoggingConfigRequest) throws ConcurrentModificationException, NoSuchHostedZoneException, NoSuchCloudWatchLogsLogGroupException, InvalidInputException, QueryLoggingConfigAlreadyExistsException, InsufficientCloudWatchLogsResourcePolicyException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateQueryLoggingConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateQueryLoggingConfig");
            CreateQueryLoggingConfigResponse createQueryLoggingConfigResponse = (CreateQueryLoggingConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateQueryLoggingConfig").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createQueryLoggingConfigRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateQueryLoggingConfigRequestMarshaller(this.protocolFactory)));
            return createQueryLoggingConfigResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, createQueryLoggingConfigRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateReusableDelegationSetResponse createReusableDelegationSet(CreateReusableDelegationSetRequest createReusableDelegationSetRequest) throws DelegationSetAlreadyCreatedException, LimitsExceededException, HostedZoneNotFoundException, InvalidArgumentException, InvalidInputException, DelegationSetNotAvailableException, DelegationSetAlreadyReusableException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateReusableDelegationSetResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReusableDelegationSet");
            CreateReusableDelegationSetResponse createReusableDelegationSetResponse = (CreateReusableDelegationSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReusableDelegationSet").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createReusableDelegationSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateReusableDelegationSetRequestMarshaller(this.protocolFactory)));
            return createReusableDelegationSetResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, createReusableDelegationSetRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTrafficPolicyResponse createTrafficPolicy(CreateTrafficPolicyRequest createTrafficPolicyRequest) throws InvalidInputException, TooManyTrafficPoliciesException, TrafficPolicyAlreadyExistsException, InvalidTrafficPolicyDocumentException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateTrafficPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTrafficPolicy");
            CreateTrafficPolicyResponse createTrafficPolicyResponse = (CreateTrafficPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTrafficPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createTrafficPolicyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateTrafficPolicyRequestMarshaller(this.protocolFactory)));
            return createTrafficPolicyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, createTrafficPolicyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTrafficPolicyInstanceResponse createTrafficPolicyInstance(CreateTrafficPolicyInstanceRequest createTrafficPolicyInstanceRequest) throws NoSuchHostedZoneException, InvalidInputException, TooManyTrafficPolicyInstancesException, NoSuchTrafficPolicyException, TrafficPolicyInstanceAlreadyExistsException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateTrafficPolicyInstanceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTrafficPolicyInstance");
            CreateTrafficPolicyInstanceResponse createTrafficPolicyInstanceResponse = (CreateTrafficPolicyInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTrafficPolicyInstance").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createTrafficPolicyInstanceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateTrafficPolicyInstanceRequestMarshaller(this.protocolFactory)));
            return createTrafficPolicyInstanceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, createTrafficPolicyInstanceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTrafficPolicyVersionResponse createTrafficPolicyVersion(CreateTrafficPolicyVersionRequest createTrafficPolicyVersionRequest) throws NoSuchTrafficPolicyException, InvalidInputException, TooManyTrafficPolicyVersionsForCurrentPolicyException, ConcurrentModificationException, InvalidTrafficPolicyDocumentException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateTrafficPolicyVersionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTrafficPolicyVersion");
            CreateTrafficPolicyVersionResponse createTrafficPolicyVersionResponse = (CreateTrafficPolicyVersionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTrafficPolicyVersion").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createTrafficPolicyVersionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateTrafficPolicyVersionRequestMarshaller(this.protocolFactory)));
            return createTrafficPolicyVersionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, createTrafficPolicyVersionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVpcAssociationAuthorizationResponse createVPCAssociationAuthorization(CreateVpcAssociationAuthorizationRequest createVpcAssociationAuthorizationRequest) throws ConcurrentModificationException, TooManyVpcAssociationAuthorizationsException, NoSuchHostedZoneException, InvalidVpcIdException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(CreateVpcAssociationAuthorizationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVPCAssociationAuthorization");
            CreateVpcAssociationAuthorizationResponse createVpcAssociationAuthorizationResponse = (CreateVpcAssociationAuthorizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVPCAssociationAuthorization").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)createVpcAssociationAuthorizationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateVpcAssociationAuthorizationRequestMarshaller(this.protocolFactory)));
            return createVpcAssociationAuthorizationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, createVpcAssociationAuthorizationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteHealthCheckResponse deleteHealthCheck(DeleteHealthCheckRequest deleteHealthCheckRequest) throws NoSuchHealthCheckException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteHealthCheckResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteHealthCheck");
            DeleteHealthCheckResponse deleteHealthCheckResponse = (DeleteHealthCheckResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteHealthCheck").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteHealthCheckRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteHealthCheckRequestMarshaller(this.protocolFactory)));
            return deleteHealthCheckResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, deleteHealthCheckRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteHostedZoneResponse deleteHostedZone(DeleteHostedZoneRequest deleteHostedZoneRequest) throws NoSuchHostedZoneException, HostedZoneNotEmptyException, PriorRequestNotCompleteException, InvalidInputException, InvalidDomainNameException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteHostedZone");
            DeleteHostedZoneResponse deleteHostedZoneResponse = (DeleteHostedZoneResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteHostedZone").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteHostedZoneRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteHostedZoneRequestMarshaller(this.protocolFactory)));
            return deleteHostedZoneResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, deleteHostedZoneRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteQueryLoggingConfigResponse deleteQueryLoggingConfig(DeleteQueryLoggingConfigRequest deleteQueryLoggingConfigRequest) throws ConcurrentModificationException, NoSuchQueryLoggingConfigException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteQueryLoggingConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteQueryLoggingConfig");
            DeleteQueryLoggingConfigResponse deleteQueryLoggingConfigResponse = (DeleteQueryLoggingConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteQueryLoggingConfig").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteQueryLoggingConfigRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteQueryLoggingConfigRequestMarshaller(this.protocolFactory)));
            return deleteQueryLoggingConfigResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, deleteQueryLoggingConfigRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReusableDelegationSetResponse deleteReusableDelegationSet(DeleteReusableDelegationSetRequest deleteReusableDelegationSetRequest) throws NoSuchDelegationSetException, DelegationSetInUseException, DelegationSetNotReusableException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteReusableDelegationSetResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReusableDelegationSet");
            DeleteReusableDelegationSetResponse deleteReusableDelegationSetResponse = (DeleteReusableDelegationSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReusableDelegationSet").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteReusableDelegationSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReusableDelegationSetRequestMarshaller(this.protocolFactory)));
            return deleteReusableDelegationSetResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, deleteReusableDelegationSetRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTrafficPolicyResponse deleteTrafficPolicy(DeleteTrafficPolicyRequest deleteTrafficPolicyRequest) throws NoSuchTrafficPolicyException, InvalidInputException, TrafficPolicyInUseException, ConcurrentModificationException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteTrafficPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTrafficPolicy");
            DeleteTrafficPolicyResponse deleteTrafficPolicyResponse = (DeleteTrafficPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTrafficPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteTrafficPolicyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTrafficPolicyRequestMarshaller(this.protocolFactory)));
            return deleteTrafficPolicyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, deleteTrafficPolicyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTrafficPolicyInstanceResponse deleteTrafficPolicyInstance(DeleteTrafficPolicyInstanceRequest deleteTrafficPolicyInstanceRequest) throws NoSuchTrafficPolicyInstanceException, InvalidInputException, PriorRequestNotCompleteException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteTrafficPolicyInstanceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTrafficPolicyInstance");
            DeleteTrafficPolicyInstanceResponse deleteTrafficPolicyInstanceResponse = (DeleteTrafficPolicyInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTrafficPolicyInstance").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteTrafficPolicyInstanceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTrafficPolicyInstanceRequestMarshaller(this.protocolFactory)));
            return deleteTrafficPolicyInstanceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, deleteTrafficPolicyInstanceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVpcAssociationAuthorizationResponse deleteVPCAssociationAuthorization(DeleteVpcAssociationAuthorizationRequest deleteVpcAssociationAuthorizationRequest) throws ConcurrentModificationException, VpcAssociationAuthorizationNotFoundException, NoSuchHostedZoneException, InvalidVpcIdException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DeleteVpcAssociationAuthorizationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVPCAssociationAuthorization");
            DeleteVpcAssociationAuthorizationResponse deleteVpcAssociationAuthorizationResponse = (DeleteVpcAssociationAuthorizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVPCAssociationAuthorization").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)deleteVpcAssociationAuthorizationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVpcAssociationAuthorizationRequestMarshaller(this.protocolFactory)));
            return deleteVpcAssociationAuthorizationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, deleteVpcAssociationAuthorizationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateVpcFromHostedZoneResponse disassociateVPCFromHostedZone(DisassociateVpcFromHostedZoneRequest disassociateVpcFromHostedZoneRequest) throws NoSuchHostedZoneException, InvalidVpcIdException, VpcAssociationNotFoundException, LastVpcAssociationException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(DisassociateVpcFromHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateVPCFromHostedZone");
            DisassociateVpcFromHostedZoneResponse disassociateVpcFromHostedZoneResponse = (DisassociateVpcFromHostedZoneResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateVPCFromHostedZone").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)disassociateVpcFromHostedZoneRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateVpcFromHostedZoneRequestMarshaller(this.protocolFactory)));
            return disassociateVpcFromHostedZoneResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, disassociateVpcFromHostedZoneRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAccountLimitResponse getAccountLimit(GetAccountLimitRequest getAccountLimitRequest) throws InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetAccountLimitResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAccountLimit");
            GetAccountLimitResponse getAccountLimitResponse = (GetAccountLimitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAccountLimit").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getAccountLimitRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetAccountLimitRequestMarshaller(this.protocolFactory)));
            return getAccountLimitResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, getAccountLimitRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetChangeResponse getChange(GetChangeRequest getChangeRequest) throws NoSuchChangeException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetChangeResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetChange");
            GetChangeResponse getChangeResponse = (GetChangeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetChange").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getChangeRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetChangeRequestMarshaller(this.protocolFactory)));
            return getChangeResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, getChangeRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCheckerIpRangesResponse getCheckerIpRanges(GetCheckerIpRangesRequest getCheckerIpRangesRequest) throws AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetCheckerIpRangesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCheckerIpRanges");
            GetCheckerIpRangesResponse getCheckerIpRangesResponse = (GetCheckerIpRangesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCheckerIpRanges").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getCheckerIpRangesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetCheckerIpRangesRequestMarshaller(this.protocolFactory)));
            return getCheckerIpRangesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, getCheckerIpRangesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGeoLocationResponse getGeoLocation(GetGeoLocationRequest getGeoLocationRequest) throws NoSuchGeoLocationException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetGeoLocationResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGeoLocation");
            GetGeoLocationResponse getGeoLocationResponse = (GetGeoLocationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGeoLocation").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getGeoLocationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetGeoLocationRequestMarshaller(this.protocolFactory)));
            return getGeoLocationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, getGeoLocationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetHealthCheckResponse getHealthCheck(GetHealthCheckRequest getHealthCheckRequest) throws NoSuchHealthCheckException, InvalidInputException, IncompatibleVersionException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetHealthCheckResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHealthCheck");
            GetHealthCheckResponse getHealthCheckResponse = (GetHealthCheckResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHealthCheck").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getHealthCheckRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetHealthCheckRequestMarshaller(this.protocolFactory)));
            return getHealthCheckResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, getHealthCheckRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetHealthCheckCountResponse getHealthCheckCount(GetHealthCheckCountRequest getHealthCheckCountRequest) throws AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetHealthCheckCountResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHealthCheckCount");
            GetHealthCheckCountResponse getHealthCheckCountResponse = (GetHealthCheckCountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHealthCheckCount").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getHealthCheckCountRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetHealthCheckCountRequestMarshaller(this.protocolFactory)));
            return getHealthCheckCountResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, getHealthCheckCountRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetHealthCheckLastFailureReasonResponse getHealthCheckLastFailureReason(GetHealthCheckLastFailureReasonRequest getHealthCheckLastFailureReasonRequest) throws NoSuchHealthCheckException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetHealthCheckLastFailureReasonResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHealthCheckLastFailureReason");
            GetHealthCheckLastFailureReasonResponse getHealthCheckLastFailureReasonResponse = (GetHealthCheckLastFailureReasonResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHealthCheckLastFailureReason").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getHealthCheckLastFailureReasonRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetHealthCheckLastFailureReasonRequestMarshaller(this.protocolFactory)));
            return getHealthCheckLastFailureReasonResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, getHealthCheckLastFailureReasonRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetHealthCheckStatusResponse getHealthCheckStatus(GetHealthCheckStatusRequest getHealthCheckStatusRequest) throws NoSuchHealthCheckException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetHealthCheckStatusResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHealthCheckStatus");
            GetHealthCheckStatusResponse getHealthCheckStatusResponse = (GetHealthCheckStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHealthCheckStatus").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getHealthCheckStatusRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetHealthCheckStatusRequestMarshaller(this.protocolFactory)));
            return getHealthCheckStatusResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, getHealthCheckStatusRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetHostedZoneResponse getHostedZone(GetHostedZoneRequest getHostedZoneRequest) throws NoSuchHostedZoneException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHostedZone");
            GetHostedZoneResponse getHostedZoneResponse = (GetHostedZoneResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHostedZone").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getHostedZoneRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetHostedZoneRequestMarshaller(this.protocolFactory)));
            return getHostedZoneResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, getHostedZoneRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetHostedZoneCountResponse getHostedZoneCount(GetHostedZoneCountRequest getHostedZoneCountRequest) throws InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetHostedZoneCountResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHostedZoneCount");
            GetHostedZoneCountResponse getHostedZoneCountResponse = (GetHostedZoneCountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHostedZoneCount").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getHostedZoneCountRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetHostedZoneCountRequestMarshaller(this.protocolFactory)));
            return getHostedZoneCountResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, getHostedZoneCountRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetHostedZoneLimitResponse getHostedZoneLimit(GetHostedZoneLimitRequest getHostedZoneLimitRequest) throws NoSuchHostedZoneException, InvalidInputException, HostedZoneNotPrivateException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetHostedZoneLimitResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHostedZoneLimit");
            GetHostedZoneLimitResponse getHostedZoneLimitResponse = (GetHostedZoneLimitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHostedZoneLimit").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getHostedZoneLimitRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetHostedZoneLimitRequestMarshaller(this.protocolFactory)));
            return getHostedZoneLimitResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, getHostedZoneLimitRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQueryLoggingConfigResponse getQueryLoggingConfig(GetQueryLoggingConfigRequest getQueryLoggingConfigRequest) throws NoSuchQueryLoggingConfigException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetQueryLoggingConfigResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQueryLoggingConfig");
            GetQueryLoggingConfigResponse getQueryLoggingConfigResponse = (GetQueryLoggingConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryLoggingConfig").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getQueryLoggingConfigRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetQueryLoggingConfigRequestMarshaller(this.protocolFactory)));
            return getQueryLoggingConfigResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, getQueryLoggingConfigRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReusableDelegationSetResponse getReusableDelegationSet(GetReusableDelegationSetRequest getReusableDelegationSetRequest) throws NoSuchDelegationSetException, DelegationSetNotReusableException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetReusableDelegationSetResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReusableDelegationSet");
            GetReusableDelegationSetResponse getReusableDelegationSetResponse = (GetReusableDelegationSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReusableDelegationSet").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getReusableDelegationSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetReusableDelegationSetRequestMarshaller(this.protocolFactory)));
            return getReusableDelegationSetResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, getReusableDelegationSetRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReusableDelegationSetLimitResponse getReusableDelegationSetLimit(GetReusableDelegationSetLimitRequest getReusableDelegationSetLimitRequest) throws InvalidInputException, NoSuchDelegationSetException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetReusableDelegationSetLimitResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReusableDelegationSetLimit");
            GetReusableDelegationSetLimitResponse getReusableDelegationSetLimitResponse = (GetReusableDelegationSetLimitResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReusableDelegationSetLimit").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getReusableDelegationSetLimitRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetReusableDelegationSetLimitRequestMarshaller(this.protocolFactory)));
            return getReusableDelegationSetLimitResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, getReusableDelegationSetLimitRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTrafficPolicyResponse getTrafficPolicy(GetTrafficPolicyRequest getTrafficPolicyRequest) throws NoSuchTrafficPolicyException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetTrafficPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTrafficPolicy");
            GetTrafficPolicyResponse getTrafficPolicyResponse = (GetTrafficPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTrafficPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getTrafficPolicyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetTrafficPolicyRequestMarshaller(this.protocolFactory)));
            return getTrafficPolicyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, getTrafficPolicyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTrafficPolicyInstanceResponse getTrafficPolicyInstance(GetTrafficPolicyInstanceRequest getTrafficPolicyInstanceRequest) throws NoSuchTrafficPolicyInstanceException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetTrafficPolicyInstanceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTrafficPolicyInstance");
            GetTrafficPolicyInstanceResponse getTrafficPolicyInstanceResponse = (GetTrafficPolicyInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTrafficPolicyInstance").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getTrafficPolicyInstanceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetTrafficPolicyInstanceRequestMarshaller(this.protocolFactory)));
            return getTrafficPolicyInstanceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, getTrafficPolicyInstanceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTrafficPolicyInstanceCountResponse getTrafficPolicyInstanceCount(GetTrafficPolicyInstanceCountRequest getTrafficPolicyInstanceCountRequest) throws AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(GetTrafficPolicyInstanceCountResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTrafficPolicyInstanceCount");
            GetTrafficPolicyInstanceCountResponse getTrafficPolicyInstanceCountResponse = (GetTrafficPolicyInstanceCountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTrafficPolicyInstanceCount").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)getTrafficPolicyInstanceCountRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetTrafficPolicyInstanceCountRequestMarshaller(this.protocolFactory)));
            return getTrafficPolicyInstanceCountResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, getTrafficPolicyInstanceCountRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGeoLocationsResponse listGeoLocations(ListGeoLocationsRequest listGeoLocationsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListGeoLocationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGeoLocations");
            ListGeoLocationsResponse listGeoLocationsResponse = (ListGeoLocationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGeoLocations").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listGeoLocationsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListGeoLocationsRequestMarshaller(this.protocolFactory)));
            return listGeoLocationsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, listGeoLocationsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListHealthChecksResponse listHealthChecks(ListHealthChecksRequest listHealthChecksRequest) throws InvalidInputException, IncompatibleVersionException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListHealthChecksResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListHealthChecks");
            ListHealthChecksResponse listHealthChecksResponse = (ListHealthChecksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHealthChecks").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listHealthChecksRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListHealthChecksRequestMarshaller(this.protocolFactory)));
            return listHealthChecksResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, listHealthChecksRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListHealthChecksIterable listHealthChecksPaginator(ListHealthChecksRequest listHealthChecksRequest) throws InvalidInputException, IncompatibleVersionException, AwsServiceException, SdkClientException, Route53Exception {
        return new ListHealthChecksIterable(this, this.applyPaginatorUserAgent(listHealthChecksRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListHostedZonesResponse listHostedZones(ListHostedZonesRequest listHostedZonesRequest) throws InvalidInputException, NoSuchDelegationSetException, DelegationSetNotReusableException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListHostedZonesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListHostedZones");
            ListHostedZonesResponse listHostedZonesResponse = (ListHostedZonesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHostedZones").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listHostedZonesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListHostedZonesRequestMarshaller(this.protocolFactory)));
            return listHostedZonesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, listHostedZonesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListHostedZonesIterable listHostedZonesPaginator(ListHostedZonesRequest listHostedZonesRequest) throws InvalidInputException, NoSuchDelegationSetException, DelegationSetNotReusableException, AwsServiceException, SdkClientException, Route53Exception {
        return new ListHostedZonesIterable(this, this.applyPaginatorUserAgent(listHostedZonesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListHostedZonesByNameResponse listHostedZonesByName(ListHostedZonesByNameRequest listHostedZonesByNameRequest) throws InvalidInputException, InvalidDomainNameException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListHostedZonesByNameResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListHostedZonesByName");
            ListHostedZonesByNameResponse listHostedZonesByNameResponse = (ListHostedZonesByNameResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHostedZonesByName").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listHostedZonesByNameRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListHostedZonesByNameRequestMarshaller(this.protocolFactory)));
            return listHostedZonesByNameResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, listHostedZonesByNameRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListHostedZonesByVpcResponse listHostedZonesByVPC(ListHostedZonesByVpcRequest listHostedZonesByVpcRequest) throws InvalidInputException, InvalidPaginationTokenException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListHostedZonesByVpcResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListHostedZonesByVPC");
            ListHostedZonesByVpcResponse listHostedZonesByVpcResponse = (ListHostedZonesByVpcResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHostedZonesByVPC").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listHostedZonesByVpcRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListHostedZonesByVpcRequestMarshaller(this.protocolFactory)));
            return listHostedZonesByVpcResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, listHostedZonesByVpcRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListQueryLoggingConfigsResponse listQueryLoggingConfigs(ListQueryLoggingConfigsRequest listQueryLoggingConfigsRequest) throws InvalidInputException, InvalidPaginationTokenException, NoSuchHostedZoneException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListQueryLoggingConfigsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListQueryLoggingConfigs");
            ListQueryLoggingConfigsResponse listQueryLoggingConfigsResponse = (ListQueryLoggingConfigsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListQueryLoggingConfigs").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listQueryLoggingConfigsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListQueryLoggingConfigsRequestMarshaller(this.protocolFactory)));
            return listQueryLoggingConfigsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, listQueryLoggingConfigsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListQueryLoggingConfigsIterable listQueryLoggingConfigsPaginator(ListQueryLoggingConfigsRequest listQueryLoggingConfigsRequest) throws InvalidInputException, InvalidPaginationTokenException, NoSuchHostedZoneException, AwsServiceException, SdkClientException, Route53Exception {
        return new ListQueryLoggingConfigsIterable(this, this.applyPaginatorUserAgent(listQueryLoggingConfigsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourceRecordSetsResponse listResourceRecordSets(ListResourceRecordSetsRequest listResourceRecordSetsRequest) throws NoSuchHostedZoneException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListResourceRecordSetsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListResourceRecordSets");
            ListResourceRecordSetsResponse listResourceRecordSetsResponse = (ListResourceRecordSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListResourceRecordSets").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listResourceRecordSetsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListResourceRecordSetsRequestMarshaller(this.protocolFactory)));
            return listResourceRecordSetsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, listResourceRecordSetsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListResourceRecordSetsIterable listResourceRecordSetsPaginator(ListResourceRecordSetsRequest listResourceRecordSetsRequest) throws NoSuchHostedZoneException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        return new ListResourceRecordSetsIterable(this, this.applyPaginatorUserAgent(listResourceRecordSetsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReusableDelegationSetsResponse listReusableDelegationSets(ListReusableDelegationSetsRequest listReusableDelegationSetsRequest) throws InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListReusableDelegationSetsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReusableDelegationSets");
            ListReusableDelegationSetsResponse listReusableDelegationSetsResponse = (ListReusableDelegationSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReusableDelegationSets").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listReusableDelegationSetsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListReusableDelegationSetsRequestMarshaller(this.protocolFactory)));
            return listReusableDelegationSetsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, listReusableDelegationSetsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InvalidInputException, NoSuchHealthCheckException, NoSuchHostedZoneException, PriorRequestNotCompleteException, ThrottlingException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListTagsForResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourcesResponse listTagsForResources(ListTagsForResourcesRequest listTagsForResourcesRequest) throws InvalidInputException, NoSuchHealthCheckException, NoSuchHostedZoneException, PriorRequestNotCompleteException, ThrottlingException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListTagsForResourcesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResources");
            ListTagsForResourcesResponse listTagsForResourcesResponse = (ListTagsForResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResources").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listTagsForResourcesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourcesRequestMarshaller(this.protocolFactory)));
            return listTagsForResourcesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, listTagsForResourcesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTrafficPoliciesResponse listTrafficPolicies(ListTrafficPoliciesRequest listTrafficPoliciesRequest) throws InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListTrafficPoliciesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTrafficPolicies");
            ListTrafficPoliciesResponse listTrafficPoliciesResponse = (ListTrafficPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrafficPolicies").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listTrafficPoliciesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTrafficPoliciesRequestMarshaller(this.protocolFactory)));
            return listTrafficPoliciesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, listTrafficPoliciesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTrafficPolicyInstancesResponse listTrafficPolicyInstances(ListTrafficPolicyInstancesRequest listTrafficPolicyInstancesRequest) throws InvalidInputException, NoSuchTrafficPolicyInstanceException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListTrafficPolicyInstancesResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTrafficPolicyInstances");
            ListTrafficPolicyInstancesResponse listTrafficPolicyInstancesResponse = (ListTrafficPolicyInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrafficPolicyInstances").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listTrafficPolicyInstancesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTrafficPolicyInstancesRequestMarshaller(this.protocolFactory)));
            return listTrafficPolicyInstancesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, listTrafficPolicyInstancesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTrafficPolicyInstancesByHostedZoneResponse listTrafficPolicyInstancesByHostedZone(ListTrafficPolicyInstancesByHostedZoneRequest listTrafficPolicyInstancesByHostedZoneRequest) throws InvalidInputException, NoSuchTrafficPolicyInstanceException, NoSuchHostedZoneException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListTrafficPolicyInstancesByHostedZoneResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTrafficPolicyInstancesByHostedZone");
            ListTrafficPolicyInstancesByHostedZoneResponse listTrafficPolicyInstancesByHostedZoneResponse = (ListTrafficPolicyInstancesByHostedZoneResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrafficPolicyInstancesByHostedZone").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listTrafficPolicyInstancesByHostedZoneRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTrafficPolicyInstancesByHostedZoneRequestMarshaller(this.protocolFactory)));
            return listTrafficPolicyInstancesByHostedZoneResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, listTrafficPolicyInstancesByHostedZoneRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTrafficPolicyInstancesByPolicyResponse listTrafficPolicyInstancesByPolicy(ListTrafficPolicyInstancesByPolicyRequest listTrafficPolicyInstancesByPolicyRequest) throws InvalidInputException, NoSuchTrafficPolicyInstanceException, NoSuchTrafficPolicyException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListTrafficPolicyInstancesByPolicyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTrafficPolicyInstancesByPolicy");
            ListTrafficPolicyInstancesByPolicyResponse listTrafficPolicyInstancesByPolicyResponse = (ListTrafficPolicyInstancesByPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrafficPolicyInstancesByPolicy").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listTrafficPolicyInstancesByPolicyRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTrafficPolicyInstancesByPolicyRequestMarshaller(this.protocolFactory)));
            return listTrafficPolicyInstancesByPolicyResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, listTrafficPolicyInstancesByPolicyRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTrafficPolicyVersionsResponse listTrafficPolicyVersions(ListTrafficPolicyVersionsRequest listTrafficPolicyVersionsRequest) throws InvalidInputException, NoSuchTrafficPolicyException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListTrafficPolicyVersionsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTrafficPolicyVersions");
            ListTrafficPolicyVersionsResponse listTrafficPolicyVersionsResponse = (ListTrafficPolicyVersionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrafficPolicyVersions").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listTrafficPolicyVersionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTrafficPolicyVersionsRequestMarshaller(this.protocolFactory)));
            return listTrafficPolicyVersionsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, listTrafficPolicyVersionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVpcAssociationAuthorizationsResponse listVPCAssociationAuthorizations(ListVpcAssociationAuthorizationsRequest listVpcAssociationAuthorizationsRequest) throws NoSuchHostedZoneException, InvalidInputException, InvalidPaginationTokenException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(ListVpcAssociationAuthorizationsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVPCAssociationAuthorizations");
            ListVpcAssociationAuthorizationsResponse listVpcAssociationAuthorizationsResponse = (ListVpcAssociationAuthorizationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVPCAssociationAuthorizations").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)listVpcAssociationAuthorizationsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListVpcAssociationAuthorizationsRequestMarshaller(this.protocolFactory)));
            return listVpcAssociationAuthorizationsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, listVpcAssociationAuthorizationsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestDnsAnswerResponse testDNSAnswer(TestDnsAnswerRequest testDnsAnswerRequest) throws NoSuchHostedZoneException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(TestDnsAnswerResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestDNSAnswer");
            TestDnsAnswerResponse testDnsAnswerResponse = (TestDnsAnswerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestDNSAnswer").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)testDnsAnswerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new TestDnsAnswerRequestMarshaller(this.protocolFactory)));
            return testDnsAnswerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, testDnsAnswerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateHealthCheckResponse updateHealthCheck(UpdateHealthCheckRequest updateHealthCheckRequest) throws NoSuchHealthCheckException, InvalidInputException, HealthCheckVersionMismatchException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateHealthCheckResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateHealthCheck");
            UpdateHealthCheckResponse updateHealthCheckResponse = (UpdateHealthCheckResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateHealthCheck").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)updateHealthCheckRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateHealthCheckRequestMarshaller(this.protocolFactory)));
            return updateHealthCheckResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, updateHealthCheckRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateHostedZoneCommentResponse updateHostedZoneComment(UpdateHostedZoneCommentRequest updateHostedZoneCommentRequest) throws NoSuchHostedZoneException, InvalidInputException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateHostedZoneCommentResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateHostedZoneComment");
            UpdateHostedZoneCommentResponse updateHostedZoneCommentResponse = (UpdateHostedZoneCommentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateHostedZoneComment").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)updateHostedZoneCommentRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateHostedZoneCommentRequestMarshaller(this.protocolFactory)));
            return updateHostedZoneCommentResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, updateHostedZoneCommentRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTrafficPolicyCommentResponse updateTrafficPolicyComment(UpdateTrafficPolicyCommentRequest updateTrafficPolicyCommentRequest) throws InvalidInputException, NoSuchTrafficPolicyException, ConcurrentModificationException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateTrafficPolicyCommentResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTrafficPolicyComment");
            UpdateTrafficPolicyCommentResponse updateTrafficPolicyCommentResponse = (UpdateTrafficPolicyCommentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTrafficPolicyComment").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)updateTrafficPolicyCommentRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTrafficPolicyCommentRequestMarshaller(this.protocolFactory)));
            return updateTrafficPolicyCommentResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, updateTrafficPolicyCommentRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTrafficPolicyInstanceResponse updateTrafficPolicyInstance(UpdateTrafficPolicyInstanceRequest updateTrafficPolicyInstanceRequest) throws InvalidInputException, NoSuchTrafficPolicyException, NoSuchTrafficPolicyInstanceException, PriorRequestNotCompleteException, ConflictingTypesException, AwsServiceException, SdkClientException, Route53Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createCombinedResponseHandler(UpdateTrafficPolicyInstanceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Route 53");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateTrafficPolicyInstance");
            UpdateTrafficPolicyInstanceResponse updateTrafficPolicyInstanceResponse = (UpdateTrafficPolicyInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTrafficPolicyInstance").withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector).withInput((SdkRequest)updateTrafficPolicyInstanceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateTrafficPolicyInstanceRequestMarshaller(this.protocolFactory)));
            return updateTrafficPolicyInstanceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultRoute53Client.resolveMetricPublishers(this.clientConfiguration, updateTrafficPolicyInstanceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private AwsXmlProtocolFactory init() {
        return AwsXmlProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModification").exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTrafficPolicyVersionsForCurrentPolicy").exceptionBuilderSupplier(TooManyTrafficPolicyVersionsForCurrentPolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IncompatibleVersion").exceptionBuilderSupplier(IncompatibleVersionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("VPCAssociationAuthorizationNotFound").exceptionBuilderSupplier(VpcAssociationAuthorizationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchTrafficPolicy").exceptionBuilderSupplier(NoSuchTrafficPolicyException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTrafficPolicies").exceptionBuilderSupplier(TooManyTrafficPoliciesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DelegationSetAlreadyCreated").exceptionBuilderSupplier(DelegationSetAlreadyCreatedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchHostedZone").exceptionBuilderSupplier(NoSuchHostedZoneException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("QueryLoggingConfigAlreadyExists").exceptionBuilderSupplier(QueryLoggingConfigAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HostedZoneNotPrivate").exceptionBuilderSupplier(HostedZoneNotPrivateException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchGeoLocation").exceptionBuilderSupplier(NoSuchGeoLocationException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InsufficientCloudWatchLogsResourcePolicy").exceptionBuilderSupplier(InsufficientCloudWatchLogsResourcePolicyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HealthCheckVersionMismatch").exceptionBuilderSupplier(HealthCheckVersionMismatchException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PublicZoneVPCAssociation").exceptionBuilderSupplier(PublicZoneVpcAssociationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HealthCheckAlreadyExists").exceptionBuilderSupplier(HealthCheckAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchDelegationSet").exceptionBuilderSupplier(NoSuchDelegationSetException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotAuthorizedException").exceptionBuilderSupplier(NotAuthorizedException::builder).httpStatusCode(Integer.valueOf(401)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("VPCAssociationNotFound").exceptionBuilderSupplier(VpcAssociationNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyVPCAssociationAuthorizations").exceptionBuilderSupplier(TooManyVpcAssociationAuthorizationsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidVPCId").exceptionBuilderSupplier(InvalidVpcIdException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTrafficPolicyInstances").exceptionBuilderSupplier(TooManyTrafficPolicyInstancesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidPaginationToken").exceptionBuilderSupplier(InvalidPaginationTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DelegationSetNotAvailable").exceptionBuilderSupplier(DelegationSetNotAvailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchTrafficPolicyInstance").exceptionBuilderSupplier(NoSuchTrafficPolicyInstanceException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HostedZoneNotEmpty").exceptionBuilderSupplier(HostedZoneNotEmptyException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidDomainName").exceptionBuilderSupplier(InvalidDomainNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyHealthChecks").exceptionBuilderSupplier(TooManyHealthChecksException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidChangeBatch").exceptionBuilderSupplier(InvalidChangeBatchException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HostedZoneAlreadyExists").exceptionBuilderSupplier(HostedZoneAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTrafficPolicyDocument").exceptionBuilderSupplier(InvalidTrafficPolicyDocumentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrafficPolicyAlreadyExists").exceptionBuilderSupplier(TrafficPolicyAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DelegationSetAlreadyReusable").exceptionBuilderSupplier(DelegationSetAlreadyReusableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrafficPolicyInUse").exceptionBuilderSupplier(TrafficPolicyInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyHostedZones").exceptionBuilderSupplier(TooManyHostedZonesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TrafficPolicyInstanceAlreadyExists").exceptionBuilderSupplier(TrafficPolicyInstanceAlreadyExistsException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchChange").exceptionBuilderSupplier(NoSuchChangeException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictingTypes").exceptionBuilderSupplier(ConflictingTypesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DelegationSetNotReusable").exceptionBuilderSupplier(DelegationSetNotReusableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PriorRequestNotComplete").exceptionBuilderSupplier(PriorRequestNotCompleteException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HostedZoneNotFound").exceptionBuilderSupplier(HostedZoneNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArgument").exceptionBuilderSupplier(InvalidArgumentException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidInput").exceptionBuilderSupplier(InvalidInputException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictingDomainExists").exceptionBuilderSupplier(ConflictingDomainExistsException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DelegationSetInUse").exceptionBuilderSupplier(DelegationSetInUseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchQueryLoggingConfig").exceptionBuilderSupplier(NoSuchQueryLoggingConfigException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchHealthCheck").exceptionBuilderSupplier(NoSuchHealthCheckException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LastVPCAssociation").exceptionBuilderSupplier(LastVpcAssociationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoSuchCloudWatchLogsLogGroup").exceptionBuilderSupplier(NoSuchCloudWatchLogsLogGroupException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitsExceeded").exceptionBuilderSupplier(LimitsExceededException::builder).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(Route53Exception::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends Route53Request> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.61").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((Route53Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

