/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.route53.model.ResourceRecordSet;
import software.amazon.awssdk.services.route53.model.ResourceRecordSetsCopier;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceRecordSetsResponse
extends Route53Response
implements ToCopyableBuilder<Builder, ListResourceRecordSetsResponse> {
    private static final SdkField<List<ResourceRecordSet>> RESOURCE_RECORD_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListResourceRecordSetsResponse.getter(ListResourceRecordSetsResponse::resourceRecordSets)).setter(ListResourceRecordSetsResponse.setter(Builder::resourceRecordSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRecordSets").unmarshallLocationName("ResourceRecordSets").build(), ListTrait.builder().memberLocationName("ResourceRecordSet").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceRecordSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceRecordSet").unmarshallLocationName("ResourceRecordSet").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ListResourceRecordSetsResponse.getter(ListResourceRecordSetsResponse::isTruncated)).setter(ListResourceRecordSetsResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").unmarshallLocationName("IsTruncated").build()}).build();
    private static final SdkField<String> NEXT_RECORD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListResourceRecordSetsResponse.getter(ListResourceRecordSetsResponse::nextRecordName)).setter(ListResourceRecordSetsResponse.setter(Builder::nextRecordName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextRecordName").unmarshallLocationName("NextRecordName").build()}).build();
    private static final SdkField<String> NEXT_RECORD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListResourceRecordSetsResponse.getter(ListResourceRecordSetsResponse::nextRecordTypeAsString)).setter(ListResourceRecordSetsResponse.setter(Builder::nextRecordType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextRecordType").unmarshallLocationName("NextRecordType").build()}).build();
    private static final SdkField<String> NEXT_RECORD_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListResourceRecordSetsResponse.getter(ListResourceRecordSetsResponse::nextRecordIdentifier)).setter(ListResourceRecordSetsResponse.setter(Builder::nextRecordIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextRecordIdentifier").unmarshallLocationName("NextRecordIdentifier").build()}).build();
    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListResourceRecordSetsResponse.getter(ListResourceRecordSetsResponse::maxItems)).setter(ListResourceRecordSetsResponse.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").unmarshallLocationName("MaxItems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_RECORD_SETS_FIELD, IS_TRUNCATED_FIELD, NEXT_RECORD_NAME_FIELD, NEXT_RECORD_TYPE_FIELD, NEXT_RECORD_IDENTIFIER_FIELD, MAX_ITEMS_FIELD));
    private final List<ResourceRecordSet> resourceRecordSets;
    private final Boolean isTruncated;
    private final String nextRecordName;
    private final String nextRecordType;
    private final String nextRecordIdentifier;
    private final String maxItems;

    private ListResourceRecordSetsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceRecordSets = builder.resourceRecordSets;
        this.isTruncated = builder.isTruncated;
        this.nextRecordName = builder.nextRecordName;
        this.nextRecordType = builder.nextRecordType;
        this.nextRecordIdentifier = builder.nextRecordIdentifier;
        this.maxItems = builder.maxItems;
    }

    public boolean hasResourceRecordSets() {
        return this.resourceRecordSets != null && !(this.resourceRecordSets instanceof SdkAutoConstructList);
    }

    public List<ResourceRecordSet> resourceRecordSets() {
        return this.resourceRecordSets;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String nextRecordName() {
        return this.nextRecordName;
    }

    public RRType nextRecordType() {
        return RRType.fromValue(this.nextRecordType);
    }

    public String nextRecordTypeAsString() {
        return this.nextRecordType;
    }

    public String nextRecordIdentifier() {
        return this.nextRecordIdentifier;
    }

    public String maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceRecordSets());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextRecordName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextRecordTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextRecordIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceRecordSetsResponse)) {
            return false;
        }
        ListResourceRecordSetsResponse other = (ListResourceRecordSetsResponse)((Object)obj);
        return Objects.equals(this.resourceRecordSets(), other.resourceRecordSets()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.nextRecordName(), other.nextRecordName()) && Objects.equals(this.nextRecordTypeAsString(), other.nextRecordTypeAsString()) && Objects.equals(this.nextRecordIdentifier(), other.nextRecordIdentifier()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        return ToString.builder((String)"ListResourceRecordSetsResponse").add("ResourceRecordSets", this.resourceRecordSets()).add("IsTruncated", (Object)this.isTruncated()).add("NextRecordName", (Object)this.nextRecordName()).add("NextRecordType", (Object)this.nextRecordTypeAsString()).add("NextRecordIdentifier", (Object)this.nextRecordIdentifier()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceRecordSets": {
                return Optional.ofNullable(clazz.cast(this.resourceRecordSets()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "NextRecordName": {
                return Optional.ofNullable(clazz.cast(this.nextRecordName()));
            }
            case "NextRecordType": {
                return Optional.ofNullable(clazz.cast(this.nextRecordTypeAsString()));
            }
            case "NextRecordIdentifier": {
                return Optional.ofNullable(clazz.cast(this.nextRecordIdentifier()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceRecordSetsResponse, T> g) {
        return obj -> g.apply((ListResourceRecordSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private List<ResourceRecordSet> resourceRecordSets = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String nextRecordName;
        private String nextRecordType;
        private String nextRecordIdentifier;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceRecordSetsResponse model) {
            super(model);
            this.resourceRecordSets(model.resourceRecordSets);
            this.isTruncated(model.isTruncated);
            this.nextRecordName(model.nextRecordName);
            this.nextRecordType(model.nextRecordType);
            this.nextRecordIdentifier(model.nextRecordIdentifier);
            this.maxItems(model.maxItems);
        }

        public final Collection<ResourceRecordSet.Builder> getResourceRecordSets() {
            return this.resourceRecordSets != null ? (Collection)this.resourceRecordSets.stream().map(ResourceRecordSet::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceRecordSets(Collection<ResourceRecordSet> resourceRecordSets) {
            this.resourceRecordSets = ResourceRecordSetsCopier.copy(resourceRecordSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRecordSets(ResourceRecordSet ... resourceRecordSets) {
            this.resourceRecordSets(Arrays.asList(resourceRecordSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRecordSets(Consumer<ResourceRecordSet.Builder> ... resourceRecordSets) {
            this.resourceRecordSets(Stream.of(resourceRecordSets).map(c -> (ResourceRecordSet)((ResourceRecordSet.Builder)ResourceRecordSet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceRecordSets(Collection<ResourceRecordSet.BuilderImpl> resourceRecordSets) {
            this.resourceRecordSets = ResourceRecordSetsCopier.copyFromBuilder(resourceRecordSets);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getNextRecordName() {
            return this.nextRecordName;
        }

        @Override
        public final Builder nextRecordName(String nextRecordName) {
            this.nextRecordName = nextRecordName;
            return this;
        }

        public final void setNextRecordName(String nextRecordName) {
            this.nextRecordName = nextRecordName;
        }

        public final String getNextRecordType() {
            return this.nextRecordType;
        }

        @Override
        public final Builder nextRecordType(String nextRecordType) {
            this.nextRecordType = nextRecordType;
            return this;
        }

        @Override
        public final Builder nextRecordType(RRType nextRecordType) {
            this.nextRecordType(nextRecordType == null ? null : nextRecordType.toString());
            return this;
        }

        public final void setNextRecordType(String nextRecordType) {
            this.nextRecordType = nextRecordType;
        }

        public final String getNextRecordIdentifier() {
            return this.nextRecordIdentifier;
        }

        @Override
        public final Builder nextRecordIdentifier(String nextRecordIdentifier) {
            this.nextRecordIdentifier = nextRecordIdentifier;
            return this;
        }

        public final void setNextRecordIdentifier(String nextRecordIdentifier) {
            this.nextRecordIdentifier = nextRecordIdentifier;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public ListResourceRecordSetsResponse build() {
            return new ListResourceRecordSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceRecordSetsResponse> {
        public Builder resourceRecordSets(Collection<ResourceRecordSet> var1);

        public Builder resourceRecordSets(ResourceRecordSet ... var1);

        public Builder resourceRecordSets(Consumer<ResourceRecordSet.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder nextRecordName(String var1);

        public Builder nextRecordType(String var1);

        public Builder nextRecordType(RRType var1);

        public Builder nextRecordIdentifier(String var1);

        public Builder maxItems(String var1);
    }
}

