/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrafficPolicyInstancesByPolicyRequest
extends Route53Request
implements ToCopyableBuilder<Builder, ListTrafficPolicyInstancesByPolicyRequest> {
    private static final SdkField<String> TRAFFIC_POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListTrafficPolicyInstancesByPolicyRequest.getter(ListTrafficPolicyInstancesByPolicyRequest::trafficPolicyId)).setter(ListTrafficPolicyInstancesByPolicyRequest.setter(Builder::trafficPolicyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("id").unmarshallLocationName("id").build()}).build();
    private static final SdkField<Integer> TRAFFIC_POLICY_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListTrafficPolicyInstancesByPolicyRequest.getter(ListTrafficPolicyInstancesByPolicyRequest::trafficPolicyVersion)).setter(ListTrafficPolicyInstancesByPolicyRequest.setter(Builder::trafficPolicyVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("version").unmarshallLocationName("version").build()}).build();
    private static final SdkField<String> HOSTED_ZONE_ID_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListTrafficPolicyInstancesByPolicyRequest.getter(ListTrafficPolicyInstancesByPolicyRequest::hostedZoneIdMarker)).setter(ListTrafficPolicyInstancesByPolicyRequest.setter(Builder::hostedZoneIdMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("hostedzoneid").unmarshallLocationName("hostedzoneid").build()}).build();
    private static final SdkField<String> TRAFFIC_POLICY_INSTANCE_NAME_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListTrafficPolicyInstancesByPolicyRequest.getter(ListTrafficPolicyInstancesByPolicyRequest::trafficPolicyInstanceNameMarker)).setter(ListTrafficPolicyInstancesByPolicyRequest.setter(Builder::trafficPolicyInstanceNameMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("trafficpolicyinstancename").unmarshallLocationName("trafficpolicyinstancename").build()}).build();
    private static final SdkField<String> TRAFFIC_POLICY_INSTANCE_TYPE_MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListTrafficPolicyInstancesByPolicyRequest.getter(ListTrafficPolicyInstancesByPolicyRequest::trafficPolicyInstanceTypeMarkerAsString)).setter(ListTrafficPolicyInstancesByPolicyRequest.setter(Builder::trafficPolicyInstanceTypeMarker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("trafficpolicyinstancetype").unmarshallLocationName("trafficpolicyinstancetype").build()}).build();
    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListTrafficPolicyInstancesByPolicyRequest.getter(ListTrafficPolicyInstancesByPolicyRequest::maxItems)).setter(ListTrafficPolicyInstancesByPolicyRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxitems").unmarshallLocationName("maxitems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_POLICY_ID_FIELD, TRAFFIC_POLICY_VERSION_FIELD, HOSTED_ZONE_ID_MARKER_FIELD, TRAFFIC_POLICY_INSTANCE_NAME_MARKER_FIELD, TRAFFIC_POLICY_INSTANCE_TYPE_MARKER_FIELD, MAX_ITEMS_FIELD));
    private final String trafficPolicyId;
    private final Integer trafficPolicyVersion;
    private final String hostedZoneIdMarker;
    private final String trafficPolicyInstanceNameMarker;
    private final String trafficPolicyInstanceTypeMarker;
    private final String maxItems;

    private ListTrafficPolicyInstancesByPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.trafficPolicyId = builder.trafficPolicyId;
        this.trafficPolicyVersion = builder.trafficPolicyVersion;
        this.hostedZoneIdMarker = builder.hostedZoneIdMarker;
        this.trafficPolicyInstanceNameMarker = builder.trafficPolicyInstanceNameMarker;
        this.trafficPolicyInstanceTypeMarker = builder.trafficPolicyInstanceTypeMarker;
        this.maxItems = builder.maxItems;
    }

    public String trafficPolicyId() {
        return this.trafficPolicyId;
    }

    public Integer trafficPolicyVersion() {
        return this.trafficPolicyVersion;
    }

    public String hostedZoneIdMarker() {
        return this.hostedZoneIdMarker;
    }

    public String trafficPolicyInstanceNameMarker() {
        return this.trafficPolicyInstanceNameMarker;
    }

    public RRType trafficPolicyInstanceTypeMarker() {
        return RRType.fromValue(this.trafficPolicyInstanceTypeMarker);
    }

    public String trafficPolicyInstanceTypeMarkerAsString() {
        return this.trafficPolicyInstanceTypeMarker;
    }

    public String maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneIdMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyInstanceNameMarker());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficPolicyInstanceTypeMarkerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrafficPolicyInstancesByPolicyRequest)) {
            return false;
        }
        ListTrafficPolicyInstancesByPolicyRequest other = (ListTrafficPolicyInstancesByPolicyRequest)((Object)obj);
        return Objects.equals(this.trafficPolicyId(), other.trafficPolicyId()) && Objects.equals(this.trafficPolicyVersion(), other.trafficPolicyVersion()) && Objects.equals(this.hostedZoneIdMarker(), other.hostedZoneIdMarker()) && Objects.equals(this.trafficPolicyInstanceNameMarker(), other.trafficPolicyInstanceNameMarker()) && Objects.equals(this.trafficPolicyInstanceTypeMarkerAsString(), other.trafficPolicyInstanceTypeMarkerAsString()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        return ToString.builder((String)"ListTrafficPolicyInstancesByPolicyRequest").add("TrafficPolicyId", (Object)this.trafficPolicyId()).add("TrafficPolicyVersion", (Object)this.trafficPolicyVersion()).add("HostedZoneIdMarker", (Object)this.hostedZoneIdMarker()).add("TrafficPolicyInstanceNameMarker", (Object)this.trafficPolicyInstanceNameMarker()).add("TrafficPolicyInstanceTypeMarker", (Object)this.trafficPolicyInstanceTypeMarkerAsString()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficPolicyId": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyId()));
            }
            case "TrafficPolicyVersion": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyVersion()));
            }
            case "HostedZoneIdMarker": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneIdMarker()));
            }
            case "TrafficPolicyInstanceNameMarker": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyInstanceNameMarker()));
            }
            case "TrafficPolicyInstanceTypeMarker": {
                return Optional.ofNullable(clazz.cast(this.trafficPolicyInstanceTypeMarkerAsString()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrafficPolicyInstancesByPolicyRequest, T> g) {
        return obj -> g.apply((ListTrafficPolicyInstancesByPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String trafficPolicyId;
        private Integer trafficPolicyVersion;
        private String hostedZoneIdMarker;
        private String trafficPolicyInstanceNameMarker;
        private String trafficPolicyInstanceTypeMarker;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrafficPolicyInstancesByPolicyRequest model) {
            super(model);
            this.trafficPolicyId(model.trafficPolicyId);
            this.trafficPolicyVersion(model.trafficPolicyVersion);
            this.hostedZoneIdMarker(model.hostedZoneIdMarker);
            this.trafficPolicyInstanceNameMarker(model.trafficPolicyInstanceNameMarker);
            this.trafficPolicyInstanceTypeMarker(model.trafficPolicyInstanceTypeMarker);
            this.maxItems(model.maxItems);
        }

        public final String getTrafficPolicyId() {
            return this.trafficPolicyId;
        }

        @Override
        public final Builder trafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
            return this;
        }

        public final void setTrafficPolicyId(String trafficPolicyId) {
            this.trafficPolicyId = trafficPolicyId;
        }

        public final Integer getTrafficPolicyVersion() {
            return this.trafficPolicyVersion;
        }

        @Override
        public final Builder trafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
            return this;
        }

        public final void setTrafficPolicyVersion(Integer trafficPolicyVersion) {
            this.trafficPolicyVersion = trafficPolicyVersion;
        }

        public final String getHostedZoneIdMarker() {
            return this.hostedZoneIdMarker;
        }

        @Override
        public final Builder hostedZoneIdMarker(String hostedZoneIdMarker) {
            this.hostedZoneIdMarker = hostedZoneIdMarker;
            return this;
        }

        public final void setHostedZoneIdMarker(String hostedZoneIdMarker) {
            this.hostedZoneIdMarker = hostedZoneIdMarker;
        }

        public final String getTrafficPolicyInstanceNameMarker() {
            return this.trafficPolicyInstanceNameMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
            return this;
        }

        public final void setTrafficPolicyInstanceNameMarker(String trafficPolicyInstanceNameMarker) {
            this.trafficPolicyInstanceNameMarker = trafficPolicyInstanceNameMarker;
        }

        public final String getTrafficPolicyInstanceTypeMarkerAsString() {
            return this.trafficPolicyInstanceTypeMarker;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
            return this;
        }

        @Override
        public final Builder trafficPolicyInstanceTypeMarker(RRType trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker(trafficPolicyInstanceTypeMarker == null ? null : trafficPolicyInstanceTypeMarker.toString());
            return this;
        }

        public final void setTrafficPolicyInstanceTypeMarker(String trafficPolicyInstanceTypeMarker) {
            this.trafficPolicyInstanceTypeMarker = trafficPolicyInstanceTypeMarker;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTrafficPolicyInstancesByPolicyRequest build() {
            return new ListTrafficPolicyInstancesByPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrafficPolicyInstancesByPolicyRequest> {
        public Builder trafficPolicyId(String var1);

        public Builder trafficPolicyVersion(Integer var1);

        public Builder hostedZoneIdMarker(String var1);

        public Builder trafficPolicyInstanceNameMarker(String var1);

        public Builder trafficPolicyInstanceTypeMarker(String var1);

        public Builder trafficPolicyInstanceTypeMarker(RRType var1);

        public Builder maxItems(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

