/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.DelegationSet;
import software.amazon.awssdk.services.route53.model.HostedZone;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.services.route53.model.VPC;
import software.amazon.awssdk.services.route53.model.VPCsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetHostedZoneResponse
extends Route53Response
implements ToCopyableBuilder<Builder, GetHostedZoneResponse> {
    private static final SdkField<HostedZone> HOSTED_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetHostedZoneResponse.getter(GetHostedZoneResponse::hostedZone)).setter(GetHostedZoneResponse.setter(Builder::hostedZone)).constructor(HostedZone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostedZone").unmarshallLocationName("HostedZone").build()}).build();
    private static final SdkField<DelegationSet> DELEGATION_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetHostedZoneResponse.getter(GetHostedZoneResponse::delegationSet)).setter(GetHostedZoneResponse.setter(Builder::delegationSet)).constructor(DelegationSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DelegationSet").unmarshallLocationName("DelegationSet").build()}).build();
    private static final SdkField<List<VPC>> VP_CS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetHostedZoneResponse.getter(GetHostedZoneResponse::vpCs)).setter(GetHostedZoneResponse.setter(Builder::vpCs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCs").unmarshallLocationName("VPCs").build(), ListTrait.builder().memberLocationName("VPC").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VPC::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPC").unmarshallLocationName("VPC").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_FIELD, DELEGATION_SET_FIELD, VP_CS_FIELD));
    private final HostedZone hostedZone;
    private final DelegationSet delegationSet;
    private final List<VPC> vpCs;

    private GetHostedZoneResponse(BuilderImpl builder) {
        super(builder);
        this.hostedZone = builder.hostedZone;
        this.delegationSet = builder.delegationSet;
        this.vpCs = builder.vpCs;
    }

    public HostedZone hostedZone() {
        return this.hostedZone;
    }

    public DelegationSet delegationSet() {
        return this.delegationSet;
    }

    public boolean hasVpCs() {
        return this.vpCs != null && !(this.vpCs instanceof SdkAutoConstructList);
    }

    public List<VPC> vpCs() {
        return this.vpCs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.delegationSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpCs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHostedZoneResponse)) {
            return false;
        }
        GetHostedZoneResponse other = (GetHostedZoneResponse)((Object)obj);
        return Objects.equals(this.hostedZone(), other.hostedZone()) && Objects.equals(this.delegationSet(), other.delegationSet()) && Objects.equals(this.vpCs(), other.vpCs());
    }

    public String toString() {
        return ToString.builder((String)"GetHostedZoneResponse").add("HostedZone", (Object)this.hostedZone()).add("DelegationSet", (Object)this.delegationSet()).add("VPCs", this.vpCs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZone": {
                return Optional.ofNullable(clazz.cast(this.hostedZone()));
            }
            case "DelegationSet": {
                return Optional.ofNullable(clazz.cast(this.delegationSet()));
            }
            case "VPCs": {
                return Optional.ofNullable(clazz.cast(this.vpCs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetHostedZoneResponse, T> g) {
        return obj -> g.apply((GetHostedZoneResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private HostedZone hostedZone;
        private DelegationSet delegationSet;
        private List<VPC> vpCs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetHostedZoneResponse model) {
            super(model);
            this.hostedZone(model.hostedZone);
            this.delegationSet(model.delegationSet);
            this.vpCs(model.vpCs);
        }

        public final HostedZone.Builder getHostedZone() {
            return this.hostedZone != null ? this.hostedZone.toBuilder() : null;
        }

        @Override
        public final Builder hostedZone(HostedZone hostedZone) {
            this.hostedZone = hostedZone;
            return this;
        }

        public final void setHostedZone(HostedZone.BuilderImpl hostedZone) {
            this.hostedZone = hostedZone != null ? hostedZone.build() : null;
        }

        public final DelegationSet.Builder getDelegationSet() {
            return this.delegationSet != null ? this.delegationSet.toBuilder() : null;
        }

        @Override
        public final Builder delegationSet(DelegationSet delegationSet) {
            this.delegationSet = delegationSet;
            return this;
        }

        public final void setDelegationSet(DelegationSet.BuilderImpl delegationSet) {
            this.delegationSet = delegationSet != null ? delegationSet.build() : null;
        }

        public final Collection<VPC.Builder> getVpCs() {
            return this.vpCs != null ? (Collection)this.vpCs.stream().map(VPC::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpCs(Collection<VPC> vpCs) {
            this.vpCs = VPCsCopier.copy(vpCs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpCs(VPC ... vpCs) {
            this.vpCs(Arrays.asList(vpCs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpCs(Consumer<VPC.Builder> ... vpCs) {
            this.vpCs(Stream.of(vpCs).map(c -> (VPC)((VPC.Builder)VPC.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpCs(Collection<VPC.BuilderImpl> vpCs) {
            this.vpCs = VPCsCopier.copyFromBuilder(vpCs);
        }

        @Override
        public GetHostedZoneResponse build() {
            return new GetHostedZoneResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetHostedZoneResponse> {
        public Builder hostedZone(HostedZone var1);

        default public Builder hostedZone(Consumer<HostedZone.Builder> hostedZone) {
            return this.hostedZone((HostedZone)((HostedZone.Builder)HostedZone.builder().applyMutation(hostedZone)).build());
        }

        public Builder delegationSet(DelegationSet var1);

        default public Builder delegationSet(Consumer<DelegationSet.Builder> delegationSet) {
            return this.delegationSet((DelegationSet)((DelegationSet.Builder)DelegationSet.builder().applyMutation(delegationSet)).build());
        }

        public Builder vpCs(Collection<VPC> var1);

        public Builder vpCs(VPC ... var1);

        public Builder vpCs(Consumer<VPC.Builder> ... var1);
    }
}

